/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.blockprotector;

import java.util.List;
import mcjty.lib.api.Infusable;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.blockprotector.BlockProtectorContainer;
import mcjty.rftools.blocks.blockprotector.BlockProtectorTileEntity;
import mcjty.rftools.blocks.blockprotector.BlockProtectors;
import mcjty.rftools.blocks.blockprotector.GuiBlockProtector;
import mcjty.rftools.items.smartwrench.SmartWrenchItem;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class BlockProtectorBlock
extends GenericRFToolsBlock<BlockProtectorTileEntity, BlockProtectorContainer>
implements Infusable {
    public static final PropertyBool WORKING = PropertyBool.func_177716_a((String)"working");

    public BlockProtectorBlock() {
        super(Material.field_151573_f, BlockProtectorTileEntity.class, BlockProtectorContainer.class, "block_protector", true);
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GenericGuiContainer> getGuiClass() {
        return GuiBlockProtector.class;
    }

    public int getGuiID() {
        return RFTools.GUI_BLOCK_PROTECTOR;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            int id = tagCompound.func_74762_e("protectorId");
            list.add(TextFormatting.GREEN + "Id: " + id);
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "Use the smart wrench with this block to select");
            list.add(TextFormatting.WHITE + "other blocks to protect them against explosions");
            list.add(TextFormatting.WHITE + "and other breackage.");
            list.add(TextFormatting.YELLOW + "Infusing bonus: reduced power consumption.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof BlockProtectorTileEntity) {
            BlockProtectorTileEntity blockProtectorTileEntity = (BlockProtectorTileEntity)te;
            int id = blockProtectorTileEntity.getId();
            probeInfo.text(TextFormatting.GREEN + "Id: " + id);
            probeInfo.text(TextFormatting.GREEN + "Blocks protected: " + blockProtectorTileEntity.getProtectedBlocks().size());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof BlockProtectorTileEntity) {
            BlockProtectorTileEntity blockProtectorTileEntity = (BlockProtectorTileEntity)te;
            int id = blockProtectorTileEntity.getId();
            currenttip.add(TextFormatting.GREEN + "Id: " + id);
            currenttip.add(TextFormatting.GREEN + "Blocks protected: " + blockProtectorTileEntity.getProtectedBlocks().size());
        }
        return currenttip;
    }

    protected boolean wrenchSneakSelect(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K) {
            GlobalCoordinate currentBlock = SmartWrenchItem.getCurrentBlock(player.func_184586_b(EnumHand.MAIN_HAND));
            if (currentBlock == null) {
                SmartWrenchItem.setCurrentBlock(player.func_184586_b(EnumHand.MAIN_HAND), new GlobalCoordinate(pos, world.field_73011_w.getDimension()));
                Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Selected block"));
            } else {
                SmartWrenchItem.setCurrentBlock(player.func_184586_b(EnumHand.MAIN_HAND), null);
                Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Cleared selected block"));
            }
        }
        return true;
    }

    protected IBlockState clGetStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState rc = super.clGetStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        if (world.field_72995_K) {
            return rc;
        }
        BlockProtectors protectors = BlockProtectors.getProtectors(world);
        GlobalCoordinate gc = new GlobalCoordinate(pos, world.field_73011_w.getDimension());
        protectors.getNewId(gc);
        protectors.save(world);
        return rc;
    }

    public boolean needsRedstoneCheck() {
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            BlockProtectorTileEntity blockProtectorTileEntity = (BlockProtectorTileEntity)world.func_175625_s(pos);
            blockProtectorTileEntity.getOrCalculateID();
            blockProtectorTileEntity.updateDestination();
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        if (world.field_72995_K) {
            return;
        }
        BlockProtectors protectors = BlockProtectors.getProtectors(world);
        protectors.removeDestination(pos, world.field_73011_w.getDimension());
        protectors.save(world);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        boolean working = false;
        if (te instanceof BlockProtectorTileEntity) {
            working = ((BlockProtectorTileEntity)te).isActive();
        }
        return state.func_177226_a((IProperty)WORKING, (Comparable)Boolean.valueOf(working));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, WORKING});
    }
}

