/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.elevator;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.blocks.elevator.ElevatorLoopSound;
import mcjty.rftools.blocks.elevator.ElevatorStartupSound;
import mcjty.rftools.blocks.elevator.ElevatorStopSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ElevatorSounds {
    private static final Map<GlobalCoordinate, MovingSound> sounds = new HashMap<GlobalCoordinate, MovingSound>();
    public static SoundEvent startSound;
    public static SoundEvent loopSound;
    public static SoundEvent stopSound;

    public static void init() {
        startSound = ElevatorSounds.registerSound(new ResourceLocation("rftools", "elevator_start"));
        loopSound = ElevatorSounds.registerSound(new ResourceLocation("rftools", "elevator_loop"));
        stopSound = ElevatorSounds.registerSound(new ResourceLocation("rftools", "elevator_stop"));
    }

    private static SoundEvent registerSound(ResourceLocation sound) {
        SoundEvent event = (SoundEvent)new SoundEvent(sound).setRegistryName(sound);
        SoundEvent.field_187505_a.func_177775_a(-1, (Object)sound, (Object)event);
        return event;
    }

    public static void moveSound(World world, BlockPos pos, float y) {
        GlobalCoordinate g = new GlobalCoordinate(pos, world.field_73011_w.getDimension());
        if (sounds.containsKey(g)) {
            MovingSound movingSound = sounds.get(g);
            if (movingSound instanceof ElevatorLoopSound) {
                ((ElevatorLoopSound)movingSound).move(movingSound.func_147649_g(), y, movingSound.func_147651_i());
            } else if (movingSound instanceof ElevatorStartupSound) {
                ((ElevatorStartupSound)movingSound).move(movingSound.func_147649_g(), y, movingSound.func_147651_i());
            } else if (movingSound instanceof ElevatorStopSound) {
                ((ElevatorStopSound)movingSound).move(movingSound.func_147649_g(), y, movingSound.func_147651_i());
            }
        }
    }

    public static void stopSound(World worldObj, BlockPos pos) {
        GlobalCoordinate g = new GlobalCoordinate(pos, worldObj.field_73011_w.getDimension());
        if (sounds.containsKey(g)) {
            MovingSound movingSound = sounds.get(g);
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)movingSound);
            sounds.remove(g);
        }
    }

    private static void playSound(World worldObj, BlockPos pos, MovingSound sound) {
        ElevatorSounds.stopSound(worldObj, pos);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        GlobalCoordinate g = new GlobalCoordinate(pos, worldObj.field_73011_w.getDimension());
        sounds.put(g, sound);
    }

    public static void playStartup(World worldObj, BlockPos pos) {
        ElevatorStartupSound sound = new ElevatorStartupSound(worldObj, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        ElevatorSounds.playSound(worldObj, pos, sound);
    }

    public static void playLoop(World worldObj, BlockPos pos) {
        ElevatorLoopSound sound = new ElevatorLoopSound(worldObj, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        ElevatorSounds.playSound(worldObj, pos, sound);
    }

    public static void playStop(World worldObj, BlockPos pos) {
        ElevatorStopSound sound = new ElevatorStopSound(worldObj, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        ElevatorSounds.playSound(worldObj, pos, sound);
    }

    public static boolean isStartupPlaying(World worldObj, BlockPos pos) {
        GlobalCoordinate g = new GlobalCoordinate(pos, worldObj.field_73011_w.getDimension());
        MovingSound movingSound = sounds.get(g);
        return movingSound instanceof ElevatorStartupSound;
    }

    public static boolean isLoopPlaying(World worldObj, BlockPos pos) {
        GlobalCoordinate g = new GlobalCoordinate(pos, worldObj.field_73011_w.getDimension());
        MovingSound movingSound = sounds.get(g);
        return movingSound instanceof ElevatorLoopSound;
    }

    public static boolean isStopPlaying(World worldObj, BlockPos pos) {
        GlobalCoordinate g = new GlobalCoordinate(pos, worldObj.field_73011_w.getDimension());
        MovingSound movingSound = sounds.get(g);
        return movingSound instanceof ElevatorStopSound;
    }
}

