/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.endergen;

import java.util.Map;
import mcjty.lib.network.Argument;
import mcjty.rftools.blocks.endergen.EnderMonitorMode;
import mcjty.rftools.blocks.logic.generic.LogicTileEntity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public class EnderMonitorTileEntity
extends LogicTileEntity
implements ITickable {
    public static final String CMD_MODE = "mode";
    private EnderMonitorMode mode = EnderMonitorMode.MODE_LOSTPEARL;
    private boolean needpulse = false;

    public EnderMonitorMode getMode() {
        return this.mode;
    }

    public void setMode(EnderMonitorMode mode) {
        this.mode = mode;
        this.markDirtyClient();
    }

    public void fireFromEndergenic(EnderMonitorMode mode) {
        if (this.mode != mode) {
            return;
        }
        this.needpulse = true;
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        boolean newout = false;
        if (this.needpulse) {
            this.func_70296_d();
            newout = true;
            this.needpulse = false;
        }
        this.setRedstoneState(newout);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powered = tagCompound.func_74767_n("rs");
        this.needpulse = tagCompound.func_74767_n("needPulse");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        int m = tagCompound.func_74762_e(CMD_MODE);
        this.mode = EnderMonitorMode.values()[m];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powered);
        tagCompound.func_74757_a("needPulse", this.needpulse);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a(CMD_MODE, this.mode.ordinal());
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_MODE.equals(command)) {
            String m = args.get(CMD_MODE).getString();
            this.setMode(EnderMonitorMode.getMode(m));
            return true;
        }
        return false;
    }
}

