/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spawner;

import java.text.DecimalFormat;
import java.util.List;
import mcjty.lib.api.IModuleSupport;
import mcjty.lib.api.Infusable;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.network.clientinfo.InfoPacketServer;
import mcjty.lib.network.clientinfo.PacketGetInfoFromServer;
import mcjty.lib.varia.ModuleSupport;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.spawner.GuiSpawner;
import mcjty.rftools.blocks.spawner.SpawnerContainer;
import mcjty.rftools.blocks.spawner.SpawnerInfoPacketClient;
import mcjty.rftools.blocks.spawner.SpawnerInfoPacketServer;
import mcjty.rftools.blocks.spawner.SpawnerTileEntity;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class SpawnerBlock
extends GenericRFToolsBlock<SpawnerTileEntity, SpawnerContainer>
implements Infusable {
    private static long lastTime = 0L;

    public SpawnerBlock() {
        super(Material.field_151573_f, SpawnerTileEntity.class, SpawnerContainer.class, "spawner", true);
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GenericGuiContainer> getGuiClass() {
        return GuiSpawner.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This block can spawn creatures. It needs a syringe");
            list.add(TextFormatting.WHITE + "of the appropriate type, RF power and also it");
            list.add(TextFormatting.WHITE + "needs beams of energized matter.");
            list.add(TextFormatting.YELLOW + "Infusing bonus: reduced power usage.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    protected IModuleSupport getModuleSupport() {
        return new ModuleSupport(0){

            public boolean isModule(ItemStack itemStack) {
                return itemStack.func_77973_b() == ModItems.syringeItem;
            }
        };
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof SpawnerTileEntity) {
            SpawnerTileEntity spawnerTileEntity = (SpawnerTileEntity)te;
            float[] matter = spawnerTileEntity.getMatter();
            DecimalFormat fmt = new DecimalFormat("#.##");
            probeInfo.text(TextFormatting.GREEN + "Key Matter: " + fmt.format(matter[0]));
            probeInfo.text(TextFormatting.GREEN + "Bulk Matter: " + fmt.format(matter[1]));
            probeInfo.text(TextFormatting.GREEN + "Living Matter: " + fmt.format(matter[2]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof SpawnerTileEntity) {
            float[] matter;
            SpawnerTileEntity spawnerTileEntity = (SpawnerTileEntity)te;
            if (System.currentTimeMillis() - lastTime > 500L) {
                lastTime = System.currentTimeMillis();
                RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetInfoFromServer("rftools", (InfoPacketServer)new SpawnerInfoPacketServer(te.func_145831_w().field_73011_w.getDimension(), te.func_174877_v())));
            }
            if ((matter = SpawnerInfoPacketClient.matterReceived) != null && matter.length == 3) {
                DecimalFormat fmt = new DecimalFormat("#.##");
                currenttip.add(TextFormatting.GREEN + "Key Matter: " + fmt.format(matter[0]));
                currenttip.add(TextFormatting.GREEN + "Bulk Matter: " + fmt.format(matter[1]));
                currenttip.add(TextFormatting.GREEN + "Living Matter: " + fmt.format(matter[2]));
            }
        }
        return currenttip;
    }

    public int getGuiID() {
        return RFTools.GUI_SPAWNER;
    }

    protected boolean wrenchUse(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        if (world.field_72995_K) {
            SpawnerTileEntity spawnerTileEntity = (SpawnerTileEntity)world.func_175625_s(pos);
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("block.note.pling")), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            spawnerTileEntity.useWrench(player);
        }
        return true;
    }
}

