/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage.sorters;

import java.util.Comparator;
import mcjty.rftools.blocks.storage.sorters.ItemSorter;
import mcjty.rftools.blocks.storage.sorters.NameItemSorter;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class ModItemSorter
implements ItemSorter {
    @Override
    public String getName() {
        return "mod";
    }

    @Override
    public String getTooltip() {
        return "Sort on mod";
    }

    @Override
    public int getU() {
        return 240;
    }

    @Override
    public int getV() {
        return 0;
    }

    @Override
    public Comparator<Pair<ItemStack, Integer>> getComparator() {
        return new Comparator<Pair<ItemStack, Integer>>(){

            @Override
            public int compare(Pair<ItemStack, Integer> o1, Pair<ItemStack, Integer> o2) {
                return ModItemSorter.compareMod(o1, o2);
            }
        };
    }

    @Override
    public boolean isSameGroup(Pair<ItemStack, Integer> o1, Pair<ItemStack, Integer> o2) {
        String name1 = ModItemSorter.getMod(o1);
        String name2 = ModItemSorter.getMod(o2);
        return name1.equals(name2);
    }

    public static int compareMod(Pair<ItemStack, Integer> o1, Pair<ItemStack, Integer> o2) {
        String name2;
        String name1 = ModItemSorter.getMod(o1);
        if (name1.equals(name2 = ModItemSorter.getMod(o2))) {
            return NameItemSorter.compareNames(o1, o2);
        }
        return name1.compareTo(name2);
    }

    public static String getModidForBlock(Block block) {
        ResourceLocation nameForObject = GameData.getBlockRegistry().getNameForObject((IForgeRegistryEntry)block);
        if (nameForObject == null) {
            return "?";
        }
        return nameForObject.func_110624_b();
    }

    public static String getModidForItem(Item item) {
        ResourceLocation nameForObject = GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)item);
        if (nameForObject == null) {
            return "?";
        }
        return nameForObject.func_110624_b();
    }

    private static String getMod(Pair<ItemStack, Integer> object) {
        ItemStack stack = (ItemStack)object.getKey();
        return ModItemSorter.getMod(stack);
    }

    public static String getMod(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            Block block = ((ItemBlock)item).func_179223_d();
            if (block != null) {
                return ModItemSorter.getModidForBlock(block);
            }
            return "Unknown";
        }
        if (item != null) {
            return ModItemSorter.getModidForItem(item);
        }
        return "Unknown";
    }

    @Override
    public String getGroupName(Pair<ItemStack, Integer> object) {
        return ModItemSorter.getMod(object);
    }
}

