/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.clientinfo.InfoPacketClient;
import mcjty.lib.network.clientinfo.InfoPacketServer;
import mcjty.rftools.blocks.storagemonitor.GetContentsInfoPacketClient;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.varia.RFToolsTools;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class GetContentsInfoPacketServer
implements InfoPacketServer {
    private int id;
    private BlockPos pos;
    private BlockPos cpos;

    public void fromBytes(ByteBuf byteBuf) {
        this.pos = NetworkTools.readPos((ByteBuf)byteBuf);
        this.cpos = NetworkTools.readPos((ByteBuf)byteBuf);
        this.id = byteBuf.readInt();
    }

    public void toBytes(ByteBuf byteBuf) {
        NetworkTools.writePos((ByteBuf)byteBuf, (BlockPos)this.pos);
        NetworkTools.writePos((ByteBuf)byteBuf, (BlockPos)this.cpos);
        byteBuf.writeInt(this.id);
    }

    public GetContentsInfoPacketServer() {
    }

    public GetContentsInfoPacketServer(int worldId, BlockPos pos, BlockPos cpos) {
        this.id = worldId;
        this.pos = pos;
        this.cpos = cpos;
    }

    public Optional<InfoPacketClient> onMessageServer(EntityPlayerMP entityPlayerMP) {
        WorldServer world = DimensionManager.getWorld((int)this.id);
        if (world == null) {
            return Optional.empty();
        }
        if (!RFToolsTools.chunkLoaded((World)world, this.pos)) {
            return Optional.empty();
        }
        TileEntity te = world.func_175625_s(this.pos);
        if (te instanceof StorageScannerTileEntity) {
            StorageScannerTileEntity scannerTileEntity = (StorageScannerTileEntity)te;
            List<ItemStack> inv = scannerTileEntity.getInventoryForBlock(this.cpos);
            return Optional.of(new GetContentsInfoPacketClient(inv));
        }
        return Optional.empty();
    }
}

