/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.clientinfo.InfoPacketClient;
import mcjty.rftools.blocks.storagemonitor.GuiStorageScanner;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class InventoriesInfoPacketClient
implements InfoPacketClient {
    private List<InventoryInfo> inventories;

    public void fromBytes(ByteBuf byteBuf) {
        int size = byteBuf.readInt();
        this.inventories = new ArrayList<InventoryInfo>(size);
        for (int i = 0; i < size; ++i) {
            BlockPos pos = NetworkTools.readPos((ByteBuf)byteBuf);
            String name = NetworkTools.readString((ByteBuf)byteBuf);
            boolean routable = byteBuf.readBoolean();
            Block block = null;
            if (byteBuf.readBoolean()) {
                block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(NetworkTools.readString((ByteBuf)byteBuf)));
            }
            this.inventories.add(new InventoryInfo(pos, name, routable, block));
        }
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.inventories.size());
        for (InventoryInfo info : this.inventories) {
            NetworkTools.writePos((ByteBuf)byteBuf, (BlockPos)info.getPos());
            NetworkTools.writeString((ByteBuf)byteBuf, (String)info.getName());
            byteBuf.writeBoolean(info.isRoutable());
            if (info.getBlock() == null) {
                byteBuf.writeBoolean(false);
                continue;
            }
            byteBuf.writeBoolean(true);
            String id = info.getBlock().getRegistryName().toString();
            NetworkTools.writeString((ByteBuf)byteBuf, (String)id);
        }
    }

    public InventoriesInfoPacketClient() {
    }

    public InventoriesInfoPacketClient(List<InventoryInfo> inventories) {
        this.inventories = inventories;
    }

    public void onMessageClient(EntityPlayerSP entityPlayerSP) {
        GuiStorageScanner.fromServer_inventories = this.inventories;
    }

    public static class InventoryInfo {
        private final BlockPos pos;
        private final String name;
        private final boolean routable;
        private final Block block;

        public InventoryInfo(BlockPos pos, String name, boolean routable, Block block) {
            this.pos = pos;
            this.name = name;
            this.routable = routable;
            this.block = block;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRoutable() {
            return this.routable;
        }

        public Block getBlock() {
            return this.block;
        }
    }
}

