/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import java.util.List;
import mcjty.lib.api.Infusable;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.varia.BlockPosTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.teleporter.BeamRenderer;
import mcjty.rftools.blocks.teleporter.GuiMatterTransmitter;
import mcjty.rftools.blocks.teleporter.MatterTransmitterTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.network.PacketGetDestinationInfo;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.network.ReturnDestinationInfoHelper;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class MatterTransmitterBlock
extends GenericRFToolsBlock<MatterTransmitterTileEntity, EmptyContainer>
implements Infusable {
    private static long lastTime = 0L;

    public MatterTransmitterBlock() {
        super(Material.field_151573_f, MatterTransmitterTileEntity.class, EmptyContainer.class, "matter_transmitter", false);
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GenericGuiContainer> getGuiClass() {
        return GuiMatterTransmitter.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
        ClientRegistry.bindTileEntitySpecialRenderer(MatterTransmitterTileEntity.class, (TileEntitySpecialRenderer)new BeamRenderer());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            boolean once;
            String name = tagCompound.func_74779_i("tpName");
            list.add(TextFormatting.GREEN + "Name: " + name);
            boolean dialed = false;
            BlockPos c = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"dest");
            if (c != null && c.func_177956_o() >= 0) {
                dialed = true;
            } else if (tagCompound.func_74764_b("destId") && tagCompound.func_74762_e("destId") != -1) {
                dialed = true;
            }
            if (dialed) {
                int destId = tagCompound.func_74762_e("destId");
                if (System.currentTimeMillis() - lastTime > 500L) {
                    lastTime = System.currentTimeMillis();
                    RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetDestinationInfo(destId));
                }
                String destname = "?";
                if (ReturnDestinationInfoHelper.id != null && ReturnDestinationInfoHelper.id == destId) {
                    destname = ReturnDestinationInfoHelper.name;
                }
                list.add(TextFormatting.YELLOW + "[DIALED to " + destname + "]");
            }
            if (once = tagCompound.func_74767_n("once")) {
                list.add(TextFormatting.YELLOW + "[ONCE]");
            }
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "If you place this block near a Dialing Device then");
            list.add(TextFormatting.WHITE + "you can dial it to a Matter Receiver. Make sure to give");
            list.add(TextFormatting.WHITE + "it sufficient power!");
            list.add(TextFormatting.WHITE + "Use a Destination Analyzer adjacent to this block");
            list.add(TextFormatting.WHITE + "to check destination status (red is bad, green ok,");
            list.add(TextFormatting.WHITE + "yellow is unknown).");
            list.add(TextFormatting.WHITE + "Use a  Matter Booster adjacent to this block");
            list.add(TextFormatting.WHITE + "to be able to teleport to unpowered receivers.");
            list.add(TextFormatting.YELLOW + "Infusing bonus: reduced power consumption and");
            list.add(TextFormatting.YELLOW + "increased teleportation speed.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof MatterTransmitterTileEntity) {
            MatterTransmitterTileEntity matterTransmitterTileEntity = (MatterTransmitterTileEntity)te;
            probeInfo.text(TextFormatting.GREEN + "Name: " + matterTransmitterTileEntity.getName());
            if (matterTransmitterTileEntity.isDialed()) {
                Integer teleportId = matterTransmitterTileEntity.getTeleportId();
                TeleportDestinations destinations = TeleportDestinations.getDestinations(world);
                String name = "?";
                if (teleportId != null) {
                    name = TeleportDestinations.getDestinationName(destinations, teleportId);
                }
                probeInfo.text(TextFormatting.YELLOW + "[DIALED to " + name + "]");
            }
            if (matterTransmitterTileEntity.isOnce()) {
                probeInfo.text(TextFormatting.YELLOW + "[ONCE]");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof MatterTransmitterTileEntity) {
            MatterTransmitterTileEntity matterTransmitterTileEntity = (MatterTransmitterTileEntity)te;
            currenttip.add(TextFormatting.GREEN + "Name: " + matterTransmitterTileEntity.getName());
            if (matterTransmitterTileEntity.isDialed()) {
                if (System.currentTimeMillis() - lastTime > 500L) {
                    lastTime = System.currentTimeMillis();
                    RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetDestinationInfo(matterTransmitterTileEntity.getTeleportId()));
                }
                String name = "?";
                if (ReturnDestinationInfoHelper.id != null && ReturnDestinationInfoHelper.id == matterTransmitterTileEntity.getTeleportId()) {
                    name = ReturnDestinationInfoHelper.name;
                }
                currenttip.add(TextFormatting.YELLOW + "[DIALED to " + name + "]");
            }
            if (matterTransmitterTileEntity.isOnce()) {
                currenttip.add(TextFormatting.YELLOW + "[ONCE]");
            }
        }
        return currenttip;
    }

    public int getGuiID() {
        return RFTools.GUI_MATTER_TRANSMITTER;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.restoreBlockFromNBT(world, pos, stack);
        this.setOwner(world, pos, placer);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[0]);
    }
}

