/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.netmonitor;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.GuiItemScreen;
import mcjty.lib.gui.Scrollable;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tools.MinecraftTools;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.BlockInfo;
import mcjty.rftools.RFTools;
import mcjty.rftools.items.netmonitor.NetworkMonitorConfiguration;
import mcjty.rftools.items.netmonitor.PacketGetConnectedBlocks;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiNetworkMonitor
extends GuiItemScreen {
    private static final int MONITOR_XSIZE = 356;
    private static final int MONITOR_YSIZE = 206;
    private Map<BlockPos, BlockInfo> connectedBlocks;
    private Map<BlockPos, EnergyBar> labelMap;
    private Map<BlockPos, Integer> previousRf = null;
    private long previousRfMillis = 0L;
    private Map<Integer, BlockPos> indexToCoordinate;
    private static Map<BlockPos, BlockInfo> serverConnectedBlocks = null;
    private static BlockPos selected;
    public static final int TEXT_COLOR = 0;
    public static final int SEL_TEXT_COLOR = 0xFFFFFF;
    private ToggleButton showRfPerTick;
    private WidgetList list;
    private TextField filterTextField;
    private int listDirty = 0;
    private String filter = null;

    public static void setSelected(BlockPos selected) {
        GuiNetworkMonitor.selected = selected;
    }

    public GuiNetworkMonitor() {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, 356, 206, RFTools.GUI_MANUAL_MAIN, "netmon");
    }

    public static void setServerConnectedBlocks(Map<BlockPos, BlockInfo> serverConnectedBlocks) {
        GuiNetworkMonitor.serverConnectedBlocks = new HashMap<BlockPos, BlockInfo>(serverConnectedBlocks);
    }

    private void requestConnectedBlocksFromServer() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetConnectedBlocks(selected));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.list = new WidgetList(this.field_146297_k, (Gui)this).addSelectionEvent((SelectionEvent)new DefaultSelectionEvent(){

            public void doubleClick(Widget parent, int index) {
                GuiNetworkMonitor.this.hilightBlock(index);
            }
        });
        this.listDirty = 0;
        Slider listSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(11)).setVertical().setScrollable((Scrollable)this.list);
        Panel listPanel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(1)).setHorizontalMargin(3)).addChild((Widget)this.list)).addChild((Widget)listSlider);
        this.showRfPerTick = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setCheckMarker(true).setText("RF/tick")).setDesiredWidth(80)).addButtonEvent(parent -> {
            this.previousRfMillis = 0L;
        }).setDesiredHeight(14);
        this.filterTextField = ((TextField)new TextField(this.field_146297_k, (Gui)this).setDesiredHeight(14)).addTextEvent((parent, newText) -> {
            this.filter = this.filterTextField.getText();
            if (this.filter.trim().isEmpty()) {
                this.filter = null;
            }
            this.connectedBlocks = null;
        });
        Panel buttonPanel = (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)this.showRfPerTick)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Filter:"))).addChild((Widget)this.filterTextField)).setDesiredHeight(17);
        AbstractContainerWidget toplevel = ((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout((Layout)new VerticalLayout().setVerticalMargin(3)).addChild((Widget)listPanel)).addChild((Widget)buttonPanel);
        toplevel.setBounds(new Rectangle(this.guiLeft, this.guiTop, this.xSize, this.ySize));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        serverConnectedBlocks = null;
    }

    private void hilightBlock(int index) {
        if (index == -1) {
            return;
        }
        BlockPos c = this.indexToCoordinate.get(index);
        RFTools.instance.clientInfo.hilightBlock(c, System.currentTimeMillis() + (long)(1000 * NetworkMonitorConfiguration.hilightTime));
        Logging.message((EntityPlayer)MinecraftTools.getPlayer((Minecraft)this.field_146297_k), (String)"The block is now highlighted");
        MinecraftTools.getPlayer((Minecraft)Minecraft.func_71410_x()).func_71053_j();
    }

    private void refreshList(boolean recalcPerTick) {
        long millis = System.currentTimeMillis();
        boolean rftick = this.showRfPerTick.isPressed();
        for (Map.Entry<BlockPos, BlockInfo> me : this.connectedBlocks.entrySet()) {
            BlockInfo blockInfo = me.getValue();
            int energy = blockInfo.getEnergyStored();
            int maxEnergy = blockInfo.getMaxEnergyStored();
            EnergyBar energyLabel = this.labelMap.get(me.getKey());
            if (energyLabel == null) continue;
            this.setEnergyLabel(millis, rftick, recalcPerTick, me, energy, maxEnergy, energyLabel);
        }
    }

    private void setEnergyLabel(long millis, boolean rftick, boolean recalcPerTick, Map.Entry<BlockPos, BlockInfo> me, int energy, int maxEnergy, EnergyBar energyLabel) {
        energyLabel.setValue(energy).setMaxValue(maxEnergy).setShowRfPerTick(rftick);
        if (rftick && recalcPerTick) {
            long dt = millis - this.previousRfMillis;
            int rft = 0;
            if (dt > 0L && this.previousRf != null && this.previousRf.containsKey(me.getKey())) {
                rft = energy - this.previousRf.get(me.getKey());
                rft = rft * 50 / (int)dt;
            }
            energyLabel.setRfPerTick(rft);
        }
    }

    private void populateList() {
        boolean recalcPerTick;
        this.requestConnectedBlocksFromServer();
        if (serverConnectedBlocks == null) {
            return;
        }
        boolean rftick = this.showRfPerTick.isPressed();
        long millis = System.currentTimeMillis();
        boolean bl = recalcPerTick = this.previousRfMillis == 0L || millis - this.previousRfMillis > 1000L;
        if (serverConnectedBlocks.equals(this.connectedBlocks)) {
            this.refreshList(recalcPerTick);
        } else {
            this.connectedBlocks = new HashMap<BlockPos, BlockInfo>(serverConnectedBlocks);
            Map<BlockPos, EnergyBar> oldLabelMap = this.labelMap;
            this.labelMap = new HashMap<BlockPos, EnergyBar>();
            this.indexToCoordinate = new HashMap<Integer, BlockPos>();
            this.list.removeChildren();
            int index = 0;
            for (Map.Entry<BlockPos, BlockInfo> me : this.connectedBlocks.entrySet()) {
                EnergyBar energyLabel;
                BlockInfo blockInfo = me.getValue();
                BlockPos coordinate = me.getKey();
                if (MinecraftTools.getWorld((Minecraft)this.field_146297_k).func_175623_d(coordinate)) continue;
                int energy = blockInfo.getEnergyStored();
                int maxEnergy = blockInfo.getMaxEnergyStored();
                int color = this.getTextColor(blockInfo);
                IBlockState state = MinecraftTools.getWorld((Minecraft)this.field_146297_k).func_180495_p(coordinate);
                String displayName = BlockInfo.getReadableName(state);
                if (this.filter != null && !displayName.toLowerCase().contains(this.filter)) continue;
                Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout());
                panel.addChild((Widget)new BlockRender(this.field_146297_k, (Gui)this).setRenderItem((Object)state.func_177230_c()));
                panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setColor(StyleConfig.colorTextInListNormal).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setText(displayName).setColor(color).setDesiredWidth(100));
                panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setColor(StyleConfig.colorTextInListNormal).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setText(BlockPosTools.toString((BlockPos)coordinate)).setColor(color).setDesiredWidth(75));
                EnergyBar energyBar = energyLabel = oldLabelMap == null ? null : oldLabelMap.get(coordinate);
                if (energyLabel == null) {
                    energyLabel = new EnergyBar(this.field_146297_k, (Gui)this).setHorizontal();
                }
                this.setEnergyLabel(millis, rftick, recalcPerTick, me, energy, maxEnergy, energyLabel);
                panel.addChild((Widget)energyLabel);
                this.list.addChild((Widget)panel);
                this.labelMap.put(coordinate, energyLabel);
                this.indexToCoordinate.put(index, coordinate);
                ++index;
            }
        }
        if (rftick && recalcPerTick) {
            this.previousRfMillis = millis;
            this.previousRf = new HashMap<BlockPos, Integer>(this.connectedBlocks.size());
            for (Map.Entry<BlockPos, BlockInfo> me : this.connectedBlocks.entrySet()) {
                this.previousRf.put(me.getKey(), me.getValue().getEnergyStored());
            }
        }
    }

    public void func_73863_a(int xSize_lo, int ySize_lo, float par3) {
        super.func_73863_a(xSize_lo, ySize_lo, par3);
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.populateList();
            this.listDirty = 10;
        }
        this.drawWindow();
    }

    private int getTextColor(BlockInfo blockInfo) {
        BlockPos c = blockInfo.getCoordinate();
        int color = c.equals((Object)selected) ? 0xFFFFFF : 0;
        return color;
    }
}

