/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography;

import java.awt.image.BufferedImage;
import journeymap.client.cartography.render.BaseRenderer;
import journeymap.client.cartography.render.CaveRenderer;
import journeymap.client.cartography.render.EndRenderer;
import journeymap.client.cartography.render.NetherRenderer;
import journeymap.client.cartography.render.SurfaceRenderer;
import journeymap.client.cartography.render.TopoRenderer;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageCache;
import journeymap.client.model.RegionImageSet;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import org.apache.logging.log4j.Level;

public class ChunkRenderController {
    private final SurfaceRenderer overWorldSurfaceRenderer;
    private final BaseRenderer netherRenderer = new NetherRenderer();
    private final BaseRenderer endRenderer = new EndRenderer();
    private final BaseRenderer topoRenderer;
    private final BaseRenderer overWorldCaveRenderer;

    public ChunkRenderController() {
        SurfaceRenderer surfaceRenderer;
        this.overWorldSurfaceRenderer = surfaceRenderer = new SurfaceRenderer();
        this.overWorldCaveRenderer = new CaveRenderer(surfaceRenderer);
        this.topoRenderer = new TopoRenderer();
    }

    public BaseRenderer getRenderer(RegionCoord rCoord, MapType mapType, ChunkMD chunkMd) {
        block8: {
            try {
                RegionImageSet regionImageSet = RegionImageCache.INSTANCE.getRegionImageSet(rCoord);
                if (mapType.isUnderground()) {
                    BufferedImage image = regionImageSet.getChunkImage(chunkMd, mapType);
                    if (image != null) {
                        switch (rCoord.dimension) {
                            case -1: {
                                return this.netherRenderer;
                            }
                            case 1: {
                                return this.endRenderer;
                            }
                        }
                        return this.overWorldCaveRenderer;
                    }
                    break block8;
                }
                return this.overWorldSurfaceRenderer;
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Unexpected error in ChunkRenderController: " + LogFormatter.toPartialString(t));
            }
        }
        return null;
    }

    public boolean renderChunk(RegionCoord rCoord, MapType mapType, ChunkMD chunkMd) {
        if (!Journeymap.getClient().isMapping().booleanValue()) {
            return false;
        }
        boolean renderOkay = false;
        try {
            RegionImageSet regionImageSet = RegionImageCache.INSTANCE.getRegionImageSet(rCoord);
            if (mapType.isUnderground()) {
                BufferedImage chunkSliceImage = regionImageSet.getChunkImage(chunkMd, mapType);
                if (chunkSliceImage != null) {
                    switch (rCoord.dimension) {
                        case -1: {
                            renderOkay = this.netherRenderer.render(chunkSliceImage, chunkMd, mapType.vSlice);
                            break;
                        }
                        case 1: {
                            renderOkay = this.endRenderer.render(chunkSliceImage, chunkMd, mapType.vSlice);
                            break;
                        }
                        default: {
                            renderOkay = this.overWorldCaveRenderer.render(chunkSliceImage, chunkMd, mapType.vSlice);
                        }
                    }
                    if (renderOkay) {
                        regionImageSet.setChunkImage(chunkMd, mapType, chunkSliceImage);
                    }
                }
            } else if (mapType.isTopo()) {
                BufferedImage imageTopo = regionImageSet.getChunkImage(chunkMd, MapType.topo(rCoord.dimension));
                renderOkay = this.topoRenderer.render(imageTopo, chunkMd, null);
                if (renderOkay) {
                    regionImageSet.setChunkImage(chunkMd, MapType.topo(rCoord.dimension), imageTopo);
                    chunkMd.setRendered();
                }
            } else {
                BufferedImage imageNight;
                BufferedImage imageDay = regionImageSet.getChunkImage(chunkMd, MapType.day(rCoord.dimension));
                renderOkay = this.overWorldSurfaceRenderer.render(imageDay, imageNight = regionImageSet.getChunkImage(chunkMd, MapType.night(rCoord.dimension)), chunkMd);
                if (renderOkay) {
                    regionImageSet.setChunkImage(chunkMd, MapType.day(rCoord.dimension), imageDay);
                    regionImageSet.setChunkImage(chunkMd, MapType.night(rCoord.dimension), imageNight);
                    chunkMd.setRendered();
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Journeymap.getLogger().log(Level.WARN, LogFormatter.toString(e));
            return false;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected error in ChunkRenderController: " + LogFormatter.toString(t));
        }
        if (!renderOkay && Journeymap.getLogger().isDebugEnabled()) {
            Journeymap.getLogger().debug("Chunk render failed: %s / %s / %s", new Object[]{rCoord, chunkMd, mapType});
        }
        return renderOkay;
    }
}

