/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.render;

import com.google.common.cache.ForwardingLoadingCache;
import com.google.common.cache.RemovalNotification;
import java.awt.image.BufferedImage;
import journeymap.client.cartography.IChunkRenderer;
import journeymap.client.cartography.RGB;
import journeymap.client.cartography.Strata;
import journeymap.client.cartography.Stratum;
import journeymap.client.cartography.render.BaseRenderer;
import journeymap.client.cartography.render.SurfaceRenderer;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.properties.CoreProperties;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldProviderHell;

public class CaveRenderer
extends BaseRenderer
implements IChunkRenderer {
    private final Object chunkLock = new Object();
    private final BaseRenderer.HeightsCache[] chunkSliceHeights = new BaseRenderer.HeightsCache[16];
    private final BaseRenderer.SlopesCache[] chunkSliceSlopes = new BaseRenderer.SlopesCache[16];
    protected CoreProperties coreProperties;
    protected SurfaceRenderer surfaceRenderer;
    protected StatTimer renderCaveTimer = StatTimer.get("CaveRenderer.render");
    protected Strata strata = new Strata("Cave", 40, 8, true);
    protected float defaultDim = 0.2f;
    protected boolean mapSurfaceAboveCaves;

    public CaveRenderer(SurfaceRenderer surfaceRenderer) {
        this.surfaceRenderer = surfaceRenderer;
        this.cachePrefix = "Cave";
        this.updateOptions();
        this.shadingSlopeMin = 0.2f;
        this.shadingSlopeMax = 1.1f;
        this.shadingPrimaryDownslopeMultiplier = 0.7f;
        this.shadingPrimaryUpslopeMultiplier = 1.05f;
        this.shadingSecondaryDownslopeMultiplier = 0.99f;
        this.shadingSecondaryUpslopeMultiplier = 1.01f;
    }

    @Override
    protected void updateOptions() {
        super.updateOptions();
        this.mapSurfaceAboveCaves = Journeymap.getClient().getCoreProperties().mapSurfaceAboveCaves.get();
    }

    @Override
    public int getBlockHeight(ChunkMD chunkMd, BlockPos blockPos) {
        Integer vSlice = blockPos.func_177956_o() >> 4;
        int[] sliceBounds = this.getVSliceBounds(chunkMd, vSlice);
        int sliceMinY = sliceBounds[0];
        int sliceMaxY = sliceBounds[1];
        BaseRenderer.HeightsCache heightsCache = this.chunkSliceHeights[vSlice];
        Integer y = null;
        if (heightsCache != null) {
            y = this.getSliceBlockHeight(chunkMd, blockPos.func_177958_n() & 0xF, vSlice, blockPos.func_177952_p() & 0xF, sliceMinY, sliceMaxY, heightsCache);
        }
        return y == null ? blockPos.func_177956_o() : y.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean render(BufferedImage chunkImage, ChunkMD chunkMd, Integer vSlice) {
        if (vSlice == null) {
            Journeymap.getLogger().warn("ChunkOverworldCaveRenderer is for caves. vSlice can't be null");
            return false;
        }
        this.updateOptions();
        boolean ok = false;
        if (this.mapSurfaceAboveCaves && !chunkMd.getHasNoSky().booleanValue() && this.surfaceRenderer != null && !(ok = this.surfaceRenderer.render(chunkImage, null, chunkMd, vSlice, true))) {
            Journeymap.getLogger().debug("The surface chunk didn't paint: " + chunkMd.toString());
        }
        this.renderCaveTimer.start();
        try {
            if (this.chunkSliceHeights[vSlice] == null) {
                this.chunkSliceHeights[vSlice.intValue()] = new BaseRenderer.HeightsCache(String.format("%sHeights_%d", this.cachePrefix, vSlice));
            } else {
                this.chunkSliceHeights[vSlice].invalidateAll();
            }
            if (this.chunkSliceSlopes[vSlice] == null) {
                this.chunkSliceSlopes[vSlice.intValue()] = new BaseRenderer.SlopesCache(String.format("%sSlopes_%d", this.cachePrefix, vSlice));
            } else {
                this.chunkSliceSlopes[vSlice].invalidateAll();
            }
            this.populateSlopes(chunkMd, vSlice, this.chunkSliceHeights[vSlice], this.chunkSliceSlopes[vSlice]);
            ok = this.renderUnderground(chunkImage, chunkMd, vSlice, this.chunkSliceHeights[vSlice], this.chunkSliceSlopes[vSlice]);
            if (!ok) {
                Journeymap.getLogger().debug("The underground chunk didn't paint: " + chunkMd.toString());
            }
            boolean bl = ok;
            return bl;
        }
        finally {
            this.renderCaveTimer.stop();
        }
    }

    protected boolean renderUnderground(BufferedImage chunkSliceImage, ChunkMD chunkMd, int vSlice, BaseRenderer.HeightsCache chunkHeights, BaseRenderer.SlopesCache chunkSlopes) {
        int[] sliceBounds = this.getVSliceBounds(chunkMd, vSlice);
        int sliceMinY = sliceBounds[0];
        int sliceMaxY = sliceBounds[1];
        boolean chunkOk = false;
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                this.strata.reset();
                try {
                    int ceiling = this.getSliceBlockHeight(chunkMd, x, vSlice, z, sliceMinY, sliceMaxY, chunkHeights);
                    if (ceiling < 0) {
                        chunkOk = true;
                        this.paintVoidBlock(chunkSliceImage, x, z);
                        continue;
                    }
                    if (ceiling < sliceMinY && this.surfaceRenderer != null && this.mapSurfaceAboveCaves) {
                        this.paintDimOverlay(chunkSliceImage, x, z, this.defaultDim);
                        chunkOk = true;
                        continue;
                    }
                    int y = ceiling > sliceMaxY ? sliceMaxY : ceiling;
                    this.buildStrata(this.strata, sliceMinY, chunkMd, x, y, z, chunkHeights, chunkSlopes);
                    if (this.strata.isEmpty()) {
                        if (this.surfaceRenderer == null) {
                            if (this.strata.isBlocksFound()) {
                                this.paintBlackBlock(chunkSliceImage, x, z);
                            } else {
                                this.paintVoidBlock(chunkSliceImage, x, z);
                            }
                        } else if (ceiling > sliceMaxY) {
                            int distance = ceiling - y;
                            if (distance < 16 && this.mapSurfaceAboveCaves) {
                                this.paintDimOverlay(chunkSliceImage, x, z, Math.max(this.defaultDim, (float)(distance / 16)));
                            } else {
                                this.paintBlackBlock(chunkSliceImage, x, z);
                            }
                        } else if (this.mapSurfaceAboveCaves) {
                            this.paintDimOverlay(chunkSliceImage, x, z, this.defaultDim);
                        }
                        chunkOk = true;
                        continue;
                    }
                    chunkOk = this.paintStrata(this.strata, chunkSliceImage, chunkMd, vSlice, x, ceiling, z, chunkHeights, chunkSlopes) || chunkOk;
                    continue;
                }
                catch (Throwable t) {
                    this.paintBadBlock(chunkSliceImage, x, vSlice, z);
                    String error = "CaveRenderer error at x,vSlice,z = " + x + "," + vSlice + "," + z + " : " + LogFormatter.toString(t);
                    Journeymap.getLogger().error(error);
                }
            }
        }
        this.strata.reset();
        return chunkOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildStrata(Strata strata, int minY, ChunkMD chunkMd, int x, int topY, int z, BaseRenderer.HeightsCache chunkHeights, BaseRenderer.SlopesCache chunkSlopes) {
        BlockMD lavaBlockMD = null;
        try {
            for (int y = this.getSliceBlockHeight(chunkMd, x, topY >> 4, z, minY, topY, chunkHeights).intValue(); y > 0; --y) {
                BlockMD blockMD = BlockMD.getBlockMDFromChunkLocal(chunkMd, x, y, z);
                if (blockMD.isAir()) continue;
                strata.setBlocksFound(true);
                BlockMD blockAboveMD = BlockMD.getBlockMDFromChunkLocal(chunkMd, x, y + 1, z);
                if (blockMD.isLava() && (blockAboveMD.isLava() || y < minY)) {
                    lavaBlockMD = blockMD;
                }
                if (blockAboveMD.isAir() || blockAboveMD.hasFlag(BlockMD.Flag.OpenToSky)) {
                    if (chunkMd.canBlockSeeTheSky(x, y + 1, z)) continue;
                    int lightLevel = this.getSliceLightLevel(chunkMd, x, y, z, true);
                    if (lightLevel > 0) {
                        strata.push(chunkMd, blockMD, x, y, z, lightLevel);
                        if (blockMD.getAlpha() != 1.0f) {
                            if (this.mapTransparency) continue;
                        }
                    } else if (y >= minY) continue;
                }
                break;
            }
        }
        finally {
            if (strata.isEmpty() && lavaBlockMD != null && chunkMd.getWorld().field_73011_w instanceof WorldProviderHell) {
                strata.push(chunkMd, lavaBlockMD, x, topY, z, 14);
            }
        }
    }

    protected boolean paintStrata(Strata strata, BufferedImage chunkSliceImage, ChunkMD chunkMd, Integer vSlice, int x, int y, int z, BaseRenderer.HeightsCache chunkHeights, BaseRenderer.SlopesCache chunkSlopes) {
        if (strata.isEmpty()) {
            this.paintBadBlock(chunkSliceImage, x, y, z);
            return false;
        }
        try {
            float slope;
            Stratum stratum = null;
            BlockMD blockMD = null;
            while (!strata.isEmpty()) {
                stratum = strata.nextUp(this, true);
                if (strata.getRenderCaveColor() == null) {
                    strata.setRenderCaveColor(stratum.getCaveColor());
                } else {
                    strata.setRenderCaveColor(RGB.blendWith(strata.getRenderCaveColor(), stratum.getCaveColor(), stratum.getBlockMD().getAlpha()));
                }
                blockMD = stratum.getBlockMD();
                strata.release(stratum);
            }
            if (strata.getRenderCaveColor() == null) {
                this.paintBadBlock(chunkSliceImage, x, y, z);
                return false;
            }
            if (!blockMD.hasNoShadow() && (slope = this.getSlope(chunkMd, blockMD, x, vSlice, z, chunkHeights, chunkSlopes)) != 1.0f) {
                strata.setRenderCaveColor(RGB.bevelSlope(strata.getRenderCaveColor(), slope));
            }
            this.paintBlock(chunkSliceImage, x, z, strata.getRenderCaveColor());
        }
        catch (RuntimeException e) {
            this.paintBadBlock(chunkSliceImage, x, y, z);
            throw e;
        }
        return true;
    }

    @Override
    protected Integer getSliceBlockHeight(ChunkMD chunkMd, int x, Integer vSlice, int z, int sliceMinY, int sliceMaxY, BaseRenderer.HeightsCache chunkHeights) {
        Integer[][] blockSliceHeights = (Integer[][])chunkHeights.getUnchecked(chunkMd.getCoord());
        if (blockSliceHeights == null) {
            return null;
        }
        Integer y = blockSliceHeights[x][z];
        if (y != null) {
            return y;
        }
        try {
            y = sliceMaxY - 1;
            BlockMD blockMD = BlockMD.getBlockMDFromChunkLocal(chunkMd, x, y, z);
            BlockMD blockMDAbove = BlockMD.getBlockMDFromChunkLocal(chunkMd, x, y + 1, z);
            boolean inAirPocket = false;
            while (y > 0 && y > sliceMinY) {
                Integer n;
                Integer n2;
                if (this.mapBathymetry && blockMD.isWater()) {
                    n2 = y;
                    n = y = Integer.valueOf(y - 1);
                }
                inAirPocket = blockMD.isAir();
                if (!blockMDAbove.isAir() && !blockMDAbove.hasTranparency() && !blockMDAbove.hasFlag(BlockMD.Flag.OpenToSky) || blockMD.isAir()) {
                    n2 = y;
                    n = y = Integer.valueOf(y - 1);
                    blockMD = BlockMD.getBlockMDFromChunkLocal(chunkMd, x, y, z);
                    blockMDAbove = BlockMD.getBlockMDFromChunkLocal(chunkMd, x, y + 1, z);
                    if (y >= sliceMinY || inAirPocket) continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Couldn't get safe slice block height at " + x + "," + z + ": " + e);
            y = sliceMaxY;
        }
        blockSliceHeights[x][z] = y = Integer.valueOf(Math.max(0, y));
        return y;
    }

    protected int getSliceLightLevel(ChunkMD chunkMd, int x, int y, int z, boolean adjusted) {
        return this.mapCaveLighting ? chunkMd.getSavedLightValue(x, y + 1, z) : 15;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemoval(RemovalNotification<ChunkPos, ChunkMD> notification) {
        Object object = this.chunkLock;
        synchronized (object) {
            ChunkPos coord = (ChunkPos)notification.getKey();
            for (BaseRenderer.HeightsCache heightsCache : this.chunkSliceHeights) {
                if (heightsCache == null) continue;
                heightsCache.invalidate(coord);
            }
            for (ForwardingLoadingCache forwardingLoadingCache : this.chunkSliceSlopes) {
                if (forwardingLoadingCache == null) continue;
                forwardingLoadingCache.invalidate((Object)coord);
            }
        }
    }
}

