/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.event;

import java.util.EnumSet;
import java.util.HashSet;
import journeymap.client.Constants;
import journeymap.client.forge.event.EventHandlerManager;
import journeymap.client.log.ChatLog;
import journeymap.client.model.Waypoint;
import journeymap.client.render.map.Tile;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.lwjgl.input.Keyboard;

public class KeyEventHandler
implements EventHandlerManager.EventHandler {
    public static void initKeyBindings() {
        Minecraft minecraft = Minecraft.func_71410_x();
        HashSet<String> keyDescs = new HashSet<String>();
        for (KeyBinding existing : minecraft.field_71474_y.field_74324_K) {
            try {
                if (existing == null || existing.func_151464_g() == null) continue;
                keyDescs.add(existing.func_151464_g());
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Unexpected error when checking existing keybinding : " + existing);
            }
        }
        for (KeyBinding kb : Constants.initKeybindings()) {
            try {
                if (!keyDescs.contains(kb.func_151464_g())) {
                    ClientRegistry.registerKeyBinding((KeyBinding)kb);
                    continue;
                }
                Journeymap.getLogger().warn("Avoided duplicate keybinding that was already registered: " + kb.func_151464_g());
            }
            catch (Throwable t) {
                ChatLog.announceError("Unexpected error when registering keybinding : " + kb);
            }
        }
    }

    public static boolean onKeypress(boolean minimapOnly) {
        try {
            boolean controlDown;
            boolean bl = controlDown = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
            if (controlDown && Constants.KB_MAP.func_151470_d()) {
                UIManager.INSTANCE.toggleMinimap();
                return true;
            }
            if (controlDown && Constants.KB_MAP_ZOOMIN.func_151470_d()) {
                Tile.switchTileRenderType();
                return false;
            }
            if (controlDown && Constants.KB_MAP_ZOOMOUT.func_151470_d()) {
                Tile.switchTileDisplayQuality();
                return false;
            }
            if (Constants.KB_MAP_ZOOMIN.func_151470_d()) {
                MiniMap.state().zoomIn();
                return false;
            }
            if (Constants.KB_MAP_ZOOMOUT.func_151470_d()) {
                MiniMap.state().zoomOut();
                return false;
            }
            if (Constants.KB_MAP_DAY.func_151470_d() || Constants.KB_MAP_NIGHT.func_151470_d()) {
                MiniMap.state().toggleMapType();
                return false;
            }
            if (Constants.KB_MINIMAP_PRESET.func_151470_d()) {
                UIManager.INSTANCE.switchMiniMapPreset();
                return true;
            }
            if (controlDown && Constants.KB_WAYPOINT.func_151470_d()) {
                UIManager.INSTANCE.openWaypointManager(null, null);
                return true;
            }
            if (!minimapOnly) {
                if (Constants.KB_MAP.func_151470_d()) {
                    if (FMLClientHandler.instance().getClient().field_71462_r == null) {
                        UIManager.INSTANCE.openFullscreenMap();
                    } else if (FMLClientHandler.instance().getClient().field_71462_r instanceof Fullscreen) {
                        UIManager.INSTANCE.closeAll();
                    }
                    return true;
                }
                if (Constants.KB_WAYPOINT.func_151470_d()) {
                    if (FMLClientHandler.instance().getClient().field_71462_r == null) {
                        Minecraft mc = FMLClientHandler.instance().getClient();
                        Waypoint waypoint = Waypoint.of((EntityPlayer)mc.field_71439_g);
                        UIManager.INSTANCE.openWaypointEditor(waypoint, true, null);
                    }
                    return true;
                }
            }
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error during keypress: " + LogFormatter.toPartialString(e));
        }
        return false;
    }

    @Override
    public EnumSet<EventHandlerManager.BusType> getBus() {
        return EnumSet.of(EventHandlerManager.BusType.FMLCommonHandlerBus);
    }

    @SubscribeEvent
    public void onKeyboardEvent(InputEvent.KeyInputEvent event) {
        boolean clearKeys = KeyEventHandler.onKeypress(false);
        if (clearKeys) {
            KeyBinding.func_74506_a();
        }
    }
}

