/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.properties;

import journeymap.common.properties.config.BooleanField;
import journeymap.server.properties.GlobalProperties;
import journeymap.server.properties.PermissionProperties;
import journeymap.server.properties.PropertiesManager;
import journeymap.server.properties.ServerCategory;

public class DimensionProperties
extends PermissionProperties {
    public final BooleanField enabled = new BooleanField(ServerCategory.General, "Enable Configuration", false).categoryMaster(true);
    protected final Integer dimension;

    public DimensionProperties(Integer dimension) {
        super(String.format("Dimension %s Configuration", dimension), "Overrides the Global Server Configuration for this dimension - sent enable true to override global settings for this dim");
        this.dimension = dimension;
    }

    @Override
    public String getName() {
        return "dim" + this.dimension;
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public DimensionProperties build() {
        GlobalProperties gProp = PropertiesManager.getInstance().getGlobalProperties();
        this.opCaveMappingEnabled.set(gProp.opCaveMappingEnabled.get());
        this.caveMappingEnabled.set(gProp.caveMappingEnabled.get());
        this.opRadarEnabled.set(gProp.opRadarEnabled.get());
        this.radarEnabled.set(gProp.radarEnabled.get());
        this.playerRadarEnabled.set(gProp.playerRadarEnabled.get());
        this.villagerRadarEnabled.set(gProp.villagerRadarEnabled.get());
        this.animalRadarEnabled.set(gProp.animalRadarEnabled.get());
        this.mobRadarEnabled.set(gProp.mobRadarEnabled.get());
        this.save();
        return this;
    }
}

