/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.event;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import journeymap.client.cartography.ColorManager;
import journeymap.client.command.ClientCommandInvoker;
import journeymap.client.command.CmdChatPosition;
import journeymap.client.command.CmdEditWaypoint;
import journeymap.client.forge.event.ChatEventHandler;
import journeymap.client.forge.event.ChunkUpdateHandler;
import journeymap.client.forge.event.KeyEventHandler;
import journeymap.client.forge.event.MiniMapOverlayHandler;
import journeymap.client.forge.event.StateTickHandler;
import journeymap.client.forge.event.TextureAtlasHandler;
import journeymap.client.forge.event.WaypointBeaconHandler;
import journeymap.client.forge.event.WorldEventHandler;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventBus;

public class EventHandlerManager {
    private static HashMap<Class<? extends EventHandler>, EventHandler> handlers = new HashMap();

    public static void registerGeneralHandlers() {
        EventHandlerManager.register(new ChatEventHandler());
        EventHandlerManager.register(new StateTickHandler());
        EventHandlerManager.register(new WorldEventHandler());
        EventHandlerManager.register(new ChunkUpdateHandler());
        EventHandlerManager.register(new WaypointBeaconHandler());
        EventHandlerManager.register(new TextureAtlasHandler());
        ColorManager.instance();
        ClientCommandInvoker clientCommandInvoker = new ClientCommandInvoker();
        clientCommandInvoker.register(new CmdChatPosition());
        clientCommandInvoker.register(new CmdEditWaypoint());
        ClientCommandHandler.instance.func_71560_a((ICommand)clientCommandInvoker);
    }

    public static void registerGuiHandlers() {
        EventHandlerManager.register(new MiniMapOverlayHandler());
        KeyEventHandler.initKeyBindings();
        EventHandlerManager.register(new KeyEventHandler());
    }

    public static void unregisterAll() {
        ArrayList<Class<? extends EventHandler>> list = new ArrayList<Class<? extends EventHandler>>(handlers.keySet());
        for (Class<? extends EventHandler> handlerClass : list) {
            EventHandlerManager.unregister(handlerClass);
        }
    }

    private static void register(EventHandler handler) {
        if (handlers.containsKey(handler.getClass())) {
            Journeymap.getLogger().warn("Handler already registered: " + handler.getClass().getName());
            return;
        }
        boolean registered = false;
        for (BusType busType : handler.getBus()) {
            String name = handler.getClass().getName();
            try {
                busType.eventBus.register((Object)handler);
                registered = true;
                Journeymap.getLogger().debug(name + " registered in " + (Object)((Object)busType));
            }
            catch (Throwable t) {
                Journeymap.getLogger().error(name + " registration FAILED in " + (Object)((Object)busType) + ": " + LogFormatter.toString(t));
            }
        }
        if (registered) {
            handlers.put(handler.getClass(), handler);
        } else {
            Journeymap.getLogger().warn("Handler was not registered at all: " + handler.getClass().getName());
        }
    }

    public static void unregister(Class<? extends EventHandler> handlerClass) {
        EventHandler handler = handlers.remove(handlerClass);
        if (handler != null) {
            EnumSet<BusType> buses = handler.getBus();
            for (BusType busType : handler.getBus()) {
                String name = handler.getClass().getName();
                try {
                    boolean unregistered = false;
                    switch (busType) {
                        case MinecraftForgeBus: {
                            MinecraftForge.EVENT_BUS.unregister((Object)handler);
                            unregistered = true;
                        }
                    }
                    if (!unregistered) continue;
                    Journeymap.getLogger().debug(name + " unregistered from " + (Object)((Object)busType));
                }
                catch (Throwable t) {
                    Journeymap.getLogger().error(name + " unregistration FAILED from " + (Object)((Object)busType) + ": " + LogFormatter.toString(t));
                }
            }
        }
    }

    public static interface EventHandler {
        public EnumSet<BusType> getBus();
    }

    public static enum BusType {
        FMLCommonHandlerBus(FMLCommonHandler.instance().bus()),
        MinecraftForgeBus(MinecraftForge.EVENT_BUS);

        protected final EventBus eventBus;

        private BusType(EventBus eventBus) {
            this.eventBus = eventBus;
        }
    }
}

