/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import journeymap.client.data.DataCache;
import journeymap.client.forge.helper.ColorHelper;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.mod.ModBlockDelegate;
import journeymap.client.model.mod.vanilla.VanillaColorHandler;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.registry.GameData;
import org.apache.logging.log4j.Logger;

public class BlockMD
implements Comparable<BlockMD> {
    public static final EnumSet FlagsPlantAndCrop = EnumSet.of(Flag.Plant, Flag.Crop);
    public static final EnumSet FlagsBiomeColored = EnumSet.of(Flag.Grass, Flag.Foliage, Flag.Water, Flag.CustomBiomeColor);
    public static BlockMD AIRBLOCK;
    public static BlockMD VOIDBLOCK;
    private static Logger LOGGER;
    private static ModBlockDelegate modBlockDelegate;
    private final IBlockState blockState;
    private final String uid;
    private final String name;
    private EnumSet<Flag> flags;
    private int textureSide;
    private Integer color;
    private float alpha;
    private String iconName;
    private ModBlockDelegate.IModBlockColorHandler blockColorHandler;
    private ModBlockDelegate.IModBlockHandler modBlockHandler;
    private boolean useDefaultState;

    public static BlockMD create(IBlockState blockState) {
        try {
            if (blockState.func_177230_c() == Blocks.field_150350_a || blockState.func_177230_c() instanceof BlockAir || blockState.func_185901_i() == EnumBlockRenderType.INVISIBLE) {
                return AIRBLOCK;
            }
            if (blockState.func_177230_c().getRegistryName() == null) {
                if (LOGGER.isDebugEnabled()) {
                    Journeymap.getLogger().debug("Unregistered block will be treated like air: " + blockState);
                }
                return AIRBLOCK;
            }
            return new BlockMD(blockState);
        }
        catch (Exception e) {
            Journeymap.getLogger().error(String.format("Can't get BlockMD for %s : %s", blockState, LogFormatter.toString(e)));
            return AIRBLOCK;
        }
    }

    private BlockMD(IBlockState blockState) {
        this(blockState, blockState.func_177230_c().getRegistryName().toString(), BlockMD.getBlockName(blockState), Float.valueOf(1.0f), 1, EnumSet.noneOf(Flag.class));
    }

    private BlockMD(IBlockState blockState, String uid, String name, Float alpha, int textureSide, EnumSet<Flag> flags) {
        this.blockState = blockState;
        this.uid = uid;
        this.name = name;
        this.alpha = alpha.floatValue();
        this.textureSide = textureSide;
        this.flags = flags;
        this.blockColorHandler = VanillaColorHandler.INSTANCE;
        if (blockState != null && blockState.func_177230_c() != null && uid != null) {
            modBlockDelegate.initialize(this);
        }
    }

    public boolean isUseDefaultState() {
        return this.useDefaultState;
    }

    public BlockMD setUseDefaultState(boolean useDefaultState) {
        this.useDefaultState = useDefaultState;
        return this;
    }

    public Block getBlock() {
        return this.blockState.func_177230_c();
    }

    public int getMeta() {
        return this.blockState.func_177230_c().func_176201_c(this.blockState);
    }

    public static void reset() {
        DataCache.INSTANCE.resetBlockMetadata();
        ColorHelper.INSTANCE.resetIconColorCache();
        modBlockDelegate = new ModBlockDelegate();
        AIRBLOCK = new BlockMD(Blocks.field_150350_a.func_176223_P(), "minecraft:air", "Air", Float.valueOf(0.0f), 1, EnumSet.of(Flag.HasAir));
        VOIDBLOCK = new BlockMD(null, "journeymap:void", "Void", Float.valueOf(0.0f), 1, EnumSet.noneOf(Flag.class));
        Collection<BlockMD> all = BlockMD.getAll();
        VanillaColorHandler.INSTANCE.setExplicitColors();
    }

    public static Collection<BlockMD> getAll() {
        ArrayList<BlockMD> allBlockMDs = new ArrayList<BlockMD>(512);
        Block.field_149771_c.forEach(block -> allBlockMDs.addAll(BlockMD.getAllBlockMDs(block)));
        Collections.sort(allBlockMDs);
        return allBlockMDs;
    }

    public static BlockMD getBlockMDFromChunkLocal(ChunkMD chunkMd, int localX, int y, int localZ) {
        return BlockMD.getBlockMD(chunkMd, chunkMd.getBlockPos(localX, y, localZ));
    }

    public static BlockMD getBlockMD(ChunkMD chunkMd, BlockPos blockPos) {
        try {
            if (blockPos.func_177956_o() >= 0) {
                IBlockState blockState = chunkMd != null && chunkMd.hasChunk() ? chunkMd.getChunk().func_177435_g(blockPos) : ForgeHelper.INSTANCE.getIBlockAccess().func_180495_p(blockPos);
                return BlockMD.get(blockState);
            }
            return VOIDBLOCK;
        }
        catch (Exception e) {
            Journeymap.getLogger().error(String.format("Can't get blockId/meta for chunk %s,%s at %s : %s", chunkMd.getChunk().field_76635_g, chunkMd.getChunk().field_76647_h, blockPos, LogFormatter.toString(e)));
            return AIRBLOCK;
        }
    }

    public static BlockMD get(String uid, int meta) {
        Block block = (Block)GameData.getBlockRegistry().getObject(new ResourceLocation(uid));
        if (block == null) {
            return null;
        }
        return BlockMD.get(block.func_176203_a(meta));
    }

    public static BlockMD get(IBlockState blockState) {
        return DataCache.INSTANCE.getBlockMD(blockState);
    }

    public static void debug() {
        for (BlockMD blockMD : BlockMD.getAll()) {
            Journeymap.getLogger().info((Object)blockMD);
        }
    }

    private static String getBlockName(IBlockState blockState) {
        String displayName = null;
        try {
            Block block = blockState.func_177230_c();
            Item item = Item.func_150898_a((Block)block);
            if (item != null) {
                ItemStack idPicked = new ItemStack(item, 1, block.func_176201_c(blockState));
                displayName = I18n.func_74838_a((String)(item.func_77667_c(idPicked) + ".name"));
            }
            if (Strings.isNullOrEmpty(displayName)) {
                displayName = block.func_149732_F();
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().warn(String.format("Couldn't get display name for %s: %s ", blockState, e));
        }
        if (Strings.isNullOrEmpty((String)displayName) || displayName.contains("tile")) {
            displayName = blockState.func_177230_c().getClass().getSimpleName().replaceAll("Block", "");
        }
        return displayName;
    }

    public static Collection<BlockMD> getAllBlockMDs(Block block) {
        ArrayList states = new ArrayList(block.func_176194_O().func_177619_a());
        Collections.sort(states, (o1, o2) -> Integer.compare(o1.func_177230_c().func_176201_c(o1), o2.func_177230_c().func_176201_c(o2)));
        ArrayList<BlockMD> blockMDs = new ArrayList<BlockMD>(states.size());
        for (IBlockState state : states) {
            blockMDs.add(BlockMD.get(state));
        }
        return blockMDs;
    }

    public static void setAllFlags(Block block, Flag ... flags) {
        for (BlockMD blockMD : BlockMD.getAllBlockMDs(block)) {
            blockMD.addFlags(flags);
        }
        Journeymap.getLogger().debug(block.func_149739_a() + " flags set: " + flags);
    }

    public boolean hasFlag(Flag checkFlag) {
        return this.flags.contains((Object)checkFlag);
    }

    public boolean hasAnyFlag(EnumSet<Flag> checkFlags) {
        for (Flag flag : checkFlags) {
            if (!this.flags.contains((Object)flag)) continue;
            return true;
        }
        return false;
    }

    public void addFlags(Flag ... addFlags) {
        Collections.addAll(this.flags, addFlags);
    }

    public void addFlags(Collection<Flag> addFlags) {
        this.flags.addAll(addFlags);
    }

    public void clearFlags() {
        this.flags.clear();
    }

    public int getColor(ChunkMD chunkMD, BlockPos blockPos) {
        return this.blockColorHandler.getBlockColor(chunkMD, this, blockPos);
    }

    public Integer getColor() {
        return this.color;
    }

    public void setColor(Integer baseColor) {
        this.color = baseColor;
    }

    public boolean ensureColor() {
        if (this.color == null) {
            this.color = this.blockColorHandler.getTextureColor(this);
            return true;
        }
        return false;
    }

    public void setBlockColorHandler(ModBlockDelegate.IModBlockColorHandler blockColorHandler) {
        this.blockColorHandler = blockColorHandler;
    }

    public String getIconName() {
        return this.iconName == null ? "" : this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
        if (alpha < 1.0f) {
            this.flags.add(Flag.Transparency);
        } else if (this.hasFlag(Flag.Transparency)) {
            this.flags.remove((Object)Flag.Transparency);
        }
    }

    public boolean hasNoShadow() {
        if (this.hasFlag(Flag.NoShadow)) {
            return true;
        }
        return this.hasAnyFlag(FlagsPlantAndCrop) && Journeymap.getClient().getCoreProperties().mapPlantShadows.get() == false;
    }

    public IBlockState getBlockState() {
        return this.useDefaultState ? this.blockState.func_177230_c().func_176223_P() : this.blockState;
    }

    public boolean hasTranparency() {
        return this.hasFlag(Flag.Transparency);
    }

    public boolean isAir() {
        try {
            return this.blockState == null || this.hasFlag(Flag.HasAir) || this.blockState.func_177230_c() instanceof BlockAir;
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean isIce() {
        return this.blockState.func_177230_c() == Blocks.field_150432_aD;
    }

    public boolean isWater() {
        return this.hasFlag(Flag.Water);
    }

    public boolean isTransparentRoof() {
        return this.hasFlag(Flag.TransparentRoof);
    }

    public boolean isLava() {
        return this.blockState.func_177230_c() == Blocks.field_150353_l || this.blockState.func_177230_c() == Blocks.field_150356_k;
    }

    public boolean isFoliage() {
        return this.hasFlag(Flag.Foliage);
    }

    public boolean isGrass() {
        return this.hasFlag(Flag.Grass);
    }

    public String getName() {
        return this.name;
    }

    public String getUid() {
        return this.uid;
    }

    public EnumSet<Flag> getFlags() {
        return this.flags;
    }

    public boolean isBiomeColored() {
        return this.hasAnyFlag(FlagsBiomeColored);
    }

    public ModBlockDelegate.IModBlockHandler getModBlockHandler() {
        return this.modBlockHandler;
    }

    public void setModBlockHandler(ModBlockDelegate.IModBlockHandler modBlockHandler) {
        this.modBlockHandler = modBlockHandler;
        if (modBlockHandler == null) {
            this.flags.remove((Object)Flag.SpecialHandling);
        } else {
            this.flags.add(Flag.SpecialHandling);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.blockState.equals(((BlockMD)o).blockState);
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    public String toString() {
        return String.format("BlockMD [%s:%s] (%s)", this.uid, this.blockState, Joiner.on((String)",").join(this.flags));
    }

    @Override
    public int compareTo(BlockMD that) {
        Ordering ordering = Ordering.natural().nullsLast();
        return ComparisonChain.start().compare((Object)this.uid, (Object)that.uid, (Comparator)ordering).compare((Object)this.getMeta(), (Object)that.getMeta(), (Comparator)ordering).compare((Object)this.name, (Object)that.name, (Comparator)ordering).compare((Object)this.color, (Object)that.color, (Comparator)ordering).compare((Object)Float.valueOf(this.alpha), (Object)Float.valueOf(that.alpha), (Comparator)ordering).result();
    }

    static {
        LOGGER = Journeymap.getLogger();
        modBlockDelegate = new ModBlockDelegate();
    }

    public static enum Flag {
        HasAir,
        CustomBiomeColor,
        Foliage,
        Grass,
        Water,
        OpenToSky,
        NoShadow,
        Transparency,
        Error,
        TransparentRoof,
        Plant,
        Crop,
        TileEntity,
        SpecialHandling,
        NoTopo,
        TintError;

    }
}

