/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.events;

import journeymap.common.Journeymap;
import journeymap.common.network.PacketHandler;
import journeymap.common.network.model.InitLogin;
import journeymap.server.properties.DimensionProperties;
import journeymap.server.properties.GlobalProperties;
import journeymap.server.properties.PermissionProperties;
import journeymap.server.properties.PropertiesManager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.fml.server.FMLServerHandler;

public class ForgeEvents {
    @SideOnly(value=Side.SERVER)
    @SubscribeEvent
    public void on(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP && event.getEntity() != null) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            Journeymap.getLogger().info(((EntityPlayerMP)event.getEntity()).getDisplayNameString() + " joining dimension " + event.getEntity().field_71093_bK);
            DimensionProperties dimensionProperties = PropertiesManager.getInstance().getDimProperties(player.field_71093_bK);
            try {
                PermissionProperties prop = dimensionProperties.enabled.get() != false ? (DimensionProperties)dimensionProperties.clone() : (GlobalProperties)PropertiesManager.getInstance().getGlobalProperties().clone();
                if (this.isOp(player)) {
                    prop.radarEnabled.set(prop.opRadarEnabled.get());
                    prop.caveMappingEnabled.set(prop.opCaveMappingEnabled.get());
                }
                PacketHandler.sendDimensionPacketToPlayer(player, prop);
            }
            catch (CloneNotSupportedException e) {
                Journeymap.getLogger().error("CloneNotSupportedException: ", (Throwable)e);
            }
        }
    }

    @SideOnly(value=Side.SERVER)
    @SubscribeEvent
    public void playerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP && event.player != null) {
            if (PropertiesManager.getInstance().getGlobalProperties().useWorldId.get().booleanValue()) {
                PacketHandler.sendPlayerWorldID((EntityPlayerMP)event.player);
            }
            if (PropertiesManager.getInstance().getGlobalProperties().teleportEnabled.get().booleanValue()) {
                InitLogin init = new InitLogin();
                init.setTeleportEnabled(PropertiesManager.getInstance().getGlobalProperties().teleportEnabled.get());
                PacketHandler.sendLoginPacket((EntityPlayerMP)event.player, init);
            }
            if (this.isOp((EntityPlayerMP)event.player)) {
                // empty if block
            }
        }
    }

    private boolean isOp(EntityPlayerMP player) {
        String[] ops;
        for (String opName : ops = FMLServerHandler.instance().getServer().func_184103_al().func_152606_n()) {
            if (!player.getDisplayNameString().equalsIgnoreCase(opName)) continue;
            return true;
        }
        return false;
    }
}

