/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.entity;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.network.Argument;
import mcjty.lib.network.ClientCommandHandler;
import mcjty.lib.network.CommandHandler;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.varia.NullSidedInvWrapper;
import mcjty.lib.varia.RedstoneMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class GenericTileEntity
extends TileEntity
implements CommandHandler,
ClientCommandHandler {
    private int infused = 0;
    private String ownerName = "";
    private UUID ownerUUID = null;
    private int securityChannel = -1;
    protected RedstoneMode rsMode = RedstoneMode.REDSTONE_IGNORED;
    protected int powerLevel = 0;
    protected IItemHandler invHandlerNull;
    protected IItemHandler invHandlerSided;

    public void markDirtyClient() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
    }

    public void onBlockBreak(World workd, BlockPos pos, IBlockState state) {
    }

    protected boolean needsRedstoneMode() {
        return false;
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            this.powerLevel = powered;
            this.func_70296_d();
        }
    }

    public RedstoneMode getRSMode() {
        return this.rsMode;
    }

    public void setRSMode(RedstoneMode redstoneMode) {
        this.rsMode = redstoneMode;
        this.markDirtyClient();
    }

    public boolean isMachineEnabled() {
        if (this.rsMode != RedstoneMode.REDSTONE_IGNORED) {
            boolean rs;
            boolean bl = rs = this.powerLevel > 0;
            if (this.rsMode == RedstoneMode.REDSTONE_OFFREQUIRED && rs) {
                return false;
            }
            if (this.rsMode == RedstoneMode.REDSTONE_ONREQUIRED && !rs) {
                return false;
            }
        }
        return true;
    }

    public void onSlotChanged(int index, ItemStack stack) {
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeClientDataToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.readClientDataFromNBT(packet.func_148857_g());
    }

    public void setInfused(int infused) {
        this.infused = infused;
        this.markDirtyClient();
    }

    public int getInfused() {
        return this.infused;
    }

    public float getInfusedFactor() {
        return (float)this.infused / (float)GeneralConfig.maxInfuse;
    }

    public boolean canPlayerAccess(EntityPlayer player) {
        return !this.func_145837_r() && player.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound updateTag = super.func_189517_E_();
        this.writeClientDataToNBT(updateTag);
        return updateTag;
    }

    public void writeClientDataToNBT(NBTTagCompound tagCompound) {
        this.func_189515_b(tagCompound);
    }

    public void readClientDataFromNBT(NBTTagCompound tagCompound) {
        this.func_145839_a(tagCompound);
    }

    public void syncDataForGUI(Object[] data) {
    }

    public Object[] getDataForGUI() {
        return new Object[0];
    }

    protected void readBufferFromNBT(NBTTagCompound tagCompound, InventoryHelper inventoryHelper) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            inventoryHelper.setStackInSlot(i, ItemStackTools.loadFromNBT((NBTTagCompound)nbtTagCompound));
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powerLevel = tagCompound.func_74771_c("powered");
        this.readRestorableFromNBT(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        if (this.needsRedstoneMode()) {
            byte m = tagCompound.func_74771_c("rsMode");
            this.rsMode = RedstoneMode.values()[m];
        }
        this.infused = tagCompound.func_74762_e("infused");
        this.ownerName = tagCompound.func_74779_i("owner");
        this.ownerUUID = tagCompound.func_74764_b("idM") ? new UUID(tagCompound.func_74763_f("idM"), tagCompound.func_74763_f("idL")) : null;
        this.securityChannel = tagCompound.func_74764_b("secChannel") ? tagCompound.func_74762_e("secChannel") : -1;
    }

    protected void writeBufferToNBT(NBTTagCompound tagCompound, InventoryHelper inventoryHelper) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < inventoryHelper.getCount(); ++i) {
            ItemStack stack = inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (ItemStackTools.isValid((ItemStack)stack)) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        if (this.powerLevel > 0) {
            tagCompound.func_74774_a("powered", (byte)this.powerLevel);
        }
        this.writeRestorableToNBT(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        if (this.needsRedstoneMode()) {
            tagCompound.func_74774_a("rsMode", (byte)this.rsMode.ordinal());
        }
        tagCompound.func_74768_a("infused", this.infused);
        tagCompound.func_74778_a("owner", this.ownerName);
        if (this.ownerUUID != null) {
            tagCompound.func_74772_a("idM", this.ownerUUID.getMostSignificantBits());
            tagCompound.func_74772_a("idL", this.ownerUUID.getLeastSignificantBits());
        }
        if (this.securityChannel != -1) {
            tagCompound.func_74768_a("secChannel", this.securityChannel);
        }
    }

    public boolean setOwner(EntityPlayer player) {
        if (!GeneralConfig.manageOwnership) {
            return false;
        }
        if (this.ownerUUID != null) {
            return false;
        }
        this.ownerUUID = player.func_146103_bH().getId();
        this.ownerName = player.func_70005_c_();
        this.markDirtyClient();
        return true;
    }

    public void clearOwner() {
        if (!GeneralConfig.manageOwnership) {
            return;
        }
        this.ownerUUID = null;
        this.ownerName = "";
        this.securityChannel = -1;
        this.markDirtyClient();
    }

    public void setSecurityChannel(int id) {
        this.securityChannel = id;
        this.markDirtyClient();
    }

    public int getSecurityChannel() {
        return this.securityChannel;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        return false;
    }

    @Override
    public List executeWithResultList(String command, Map<String, Argument> args) {
        return null;
    }

    @Override
    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        return null;
    }

    @Override
    public boolean execute(String command, List list) {
        return false;
    }

    @Override
    public boolean execute(String command, Integer result) {
        return false;
    }

    protected boolean needsCustomInvWrapper() {
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.needsCustomInvWrapper() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.needsCustomInvWrapper()) {
            if (facing == null) {
                if (this.invHandlerNull == null) {
                    this.invHandlerNull = new InvWrapper((IInventory)this);
                }
                return (T)this.invHandlerNull;
            }
            if (this.invHandlerSided == null) {
                this.invHandlerSided = new NullSidedInvWrapper((ISidedInventory)this);
            }
            return (T)this.invHandlerSided;
        }
        return (T)super.getCapability(capability, facing);
    }
}

