/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.Random;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.tools.WorldTools;
import mcjty.lib.varia.MathTools;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class BlockTools {
    private static final Random random = new Random();
    public static final int MASK_ORIENTATION = 7;
    public static final int MASK_REDSTONE = 8;
    public static final int MASK_ORIENTATION_HORIZONTAL = 3;
    public static final int MASK_REDSTONE_IN = 8;
    public static final int MASK_REDSTONE_OUT = 4;
    public static final int MASK_STATE = 12;

    public static EnumFacing getOrientation(int metadata) {
        return EnumFacing.field_82609_l[metadata & 7];
    }

    public static EnumFacing reorient(EnumFacing side, int meta) {
        return BlockTools.reorient(side, BlockTools.getOrientation(meta));
    }

    public static EnumFacing reorientHoriz(EnumFacing side, int meta) {
        return BlockTools.reorient(side, BlockTools.getOrientationHoriz(meta));
    }

    public static EnumFacing reorient(EnumFacing side, EnumFacing blockDirection) {
        switch (blockDirection) {
            case DOWN: {
                switch (side) {
                    case DOWN: {
                        return EnumFacing.SOUTH;
                    }
                    case UP: {
                        return EnumFacing.NORTH;
                    }
                    case NORTH: {
                        return EnumFacing.UP;
                    }
                    case SOUTH: {
                        return EnumFacing.DOWN;
                    }
                    case WEST: {
                        return EnumFacing.EAST;
                    }
                    case EAST: {
                        return EnumFacing.WEST;
                    }
                }
                return side;
            }
            case UP: {
                switch (side) {
                    case DOWN: {
                        return EnumFacing.NORTH;
                    }
                    case UP: {
                        return EnumFacing.SOUTH;
                    }
                    case NORTH: {
                        return EnumFacing.UP;
                    }
                    case SOUTH: {
                        return EnumFacing.DOWN;
                    }
                    case WEST: {
                        return EnumFacing.WEST;
                    }
                    case EAST: {
                        return EnumFacing.EAST;
                    }
                }
                return side;
            }
            case NORTH: {
                if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
                    return side;
                }
                return side.func_176734_d();
            }
            case SOUTH: {
                return side;
            }
            case WEST: {
                if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
                    return side;
                }
                if (side == EnumFacing.WEST) {
                    return EnumFacing.SOUTH;
                }
                if (side == EnumFacing.NORTH) {
                    return EnumFacing.WEST;
                }
                if (side == EnumFacing.EAST) {
                    return EnumFacing.NORTH;
                }
                return EnumFacing.EAST;
            }
            case EAST: {
                if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
                    return side;
                }
                if (side == EnumFacing.WEST) {
                    return EnumFacing.NORTH;
                }
                if (side == EnumFacing.NORTH) {
                    return EnumFacing.EAST;
                }
                if (side == EnumFacing.EAST) {
                    return EnumFacing.SOUTH;
                }
                return EnumFacing.WEST;
            }
        }
        return side;
    }

    public static EnumFacing getTopDirection(EnumFacing direction) {
        switch (direction) {
            case DOWN: {
                return EnumFacing.SOUTH;
            }
            case UP: {
                return EnumFacing.NORTH;
            }
        }
        return EnumFacing.UP;
    }

    public static EnumFacing getBottomDirection(EnumFacing direction) {
        switch (direction) {
            case DOWN: {
                return EnumFacing.NORTH;
            }
            case UP: {
                return EnumFacing.SOUTH;
            }
        }
        return EnumFacing.DOWN;
    }

    public static int setOrientation(int metadata, EnumFacing orientation) {
        return metadata & 0xFFFFFFF8 | orientation.ordinal();
    }

    public static EnumFacing getOrientationHoriz(int metadata) {
        return EnumFacing.field_82609_l[(metadata & 3) + 2];
    }

    public static int setOrientationHoriz(int metadata, EnumFacing orientation) {
        return metadata & 0xFFFFFFFC | orientation.ordinal() - 2;
    }

    public static int setState(int metadata, int value) {
        return metadata & 0xFFFFFFF3 | value << 2;
    }

    public static int getState(int metadata) {
        return (metadata & 0xC) >> 2;
    }

    public static EnumFacing determineOrientation(BlockPos pos, EntityLivingBase entityLivingBase) {
        return BlockTools.determineOrientation(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), entityLivingBase);
    }

    public static EnumFacing determineOrientation(int x, int y, int z, EntityLivingBase entityLivingBase) {
        int l;
        if (MathHelper.func_76135_e((float)((float)entityLivingBase.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entityLivingBase.field_70161_v - (float)z)) < 2.0f) {
            double d0 = entityLivingBase.field_70163_u + 1.82 - entityLivingBase.func_70033_W();
            if (d0 - (double)y > 2.0) {
                return EnumFacing.UP;
            }
            if ((double)y - d0 > 0.0) {
                return EnumFacing.DOWN;
            }
        }
        return (l = MathTools.floor((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5) & 3) == 0 ? EnumFacing.NORTH : (l == 1 ? EnumFacing.EAST : (l == 2 ? EnumFacing.SOUTH : (l == 3 ? EnumFacing.WEST : EnumFacing.DOWN)));
    }

    public static EnumFacing determineOrientationHoriz(EntityLivingBase entityLivingBase) {
        int l = MathTools.floor((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5) & 3;
        return l == 0 ? EnumFacing.NORTH : (l == 1 ? EnumFacing.EAST : (l == 2 ? EnumFacing.SOUTH : (l == 3 ? EnumFacing.WEST : EnumFacing.DOWN)));
    }

    public static void emptyInventoryInWorld(World world, int x, int y, int z, Block block, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            BlockTools.spawnItemStack(world, x, y, z, itemstack);
            inventory.func_70299_a(i, ItemStackTools.getEmptyStack());
        }
    }

    public static void spawnItemStack(World world, int x, int y, int z, ItemStack itemstack) {
        if (ItemStackTools.isValid((ItemStack)itemstack)) {
            float f = random.nextFloat() * 0.8f + 0.1f;
            float f1 = random.nextFloat() * 0.8f + 0.1f;
            float f2 = random.nextFloat() * 0.8f + 0.1f;
            while (ItemStackTools.getStackSize((ItemStack)itemstack) > 0) {
                int j = random.nextInt(21) + 10;
                if (j > ItemStackTools.getStackSize((ItemStack)itemstack)) {
                    j = ItemStackTools.getStackSize((ItemStack)itemstack);
                }
                ItemStackTools.incStackSize((ItemStack)itemstack, (int)(-j));
                EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j, itemstack.func_77952_i()));
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)random.nextGaussian() * f3;
                entityitem.field_70181_x = (float)random.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)random.nextGaussian() * f3;
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d(itemstack.func_77978_p().func_74737_b());
                }
                WorldTools.spawnEntity((World)world, (Entity)entityitem);
            }
        }
    }

    public static Block getBlock(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            return ((ItemBlock)stack.func_77973_b()).func_179223_d();
        }
        return null;
    }
}

