/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import mcjty.lib.tools.ItemStackTools;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class FacedSidedInvWrapper
implements IItemHandlerModifiable {
    private final ISidedInventory inv;
    private final EnumFacing facing;

    public FacedSidedInvWrapper(ISidedInventory inv, EnumFacing facing) {
        this.inv = inv;
        this.facing = facing;
    }

    public static int getSlot(ISidedInventory inv, int slot, EnumFacing facing) {
        if (facing == null) {
            return slot;
        }
        int[] slots = inv.func_180463_a(facing);
        if (slot < slots.length) {
            return slots[slot];
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FacedSidedInvWrapper that = (FacedSidedInvWrapper)o;
        return !(this.inv != null ? !this.inv.equals(that.inv) : that.inv != null);
    }

    public int hashCode() {
        int result = this.inv != null ? this.inv.hashCode() : 0;
        result = 31 * result + (this.facing != null ? this.facing.hashCode() : 0);
        return result;
    }

    public int getSlots() {
        if (this.facing == null) {
            return this.inv.func_70302_i_();
        }
        return this.inv.func_180463_a(this.facing).length;
    }

    public ItemStack getStackInSlot(int slot) {
        int i = FacedSidedInvWrapper.getSlot(this.inv, slot, this.facing);
        return i == -1 ? ItemStackTools.getEmptyStack() : this.inv.func_70301_a(i);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (ItemStackTools.isEmpty((ItemStack)stack)) {
            return ItemStackTools.getEmptyStack();
        }
        if ((slot = FacedSidedInvWrapper.getSlot(this.inv, slot, this.facing)) == -1) {
            return stack;
        }
        if (!this.inv.func_94041_b(slot, stack) || this.facing != null && !this.inv.func_180462_a(slot, stack, this.facing)) {
            return stack;
        }
        ItemStack stackInSlot = this.inv.func_70301_a(slot);
        if (ItemStackTools.isValid((ItemStack)stackInSlot)) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            int m = Math.min(stack.func_77976_d(), this.inv.func_70297_j_()) - ItemStackTools.getStackSize((ItemStack)stackInSlot);
            if (ItemStackTools.getStackSize((ItemStack)stack) <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    ItemStackTools.incStackSize((ItemStack)copy, (int)ItemStackTools.getStackSize((ItemStack)stackInSlot));
                    this.inv.func_70299_a(slot, copy);
                }
                return ItemStackTools.getEmptyStack();
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                ItemStackTools.incStackSize((ItemStack)copy, (int)ItemStackTools.getStackSize((ItemStack)stackInSlot));
                this.inv.func_70299_a(slot, copy);
                return stack;
            }
            ItemStackTools.incStackSize((ItemStack)stack, (int)(-m));
            return stack;
        }
        int m = Math.min(stack.func_77976_d(), this.inv.func_70297_j_());
        if (m < ItemStackTools.getStackSize((ItemStack)stack)) {
            stack = stack.func_77946_l();
            if (!simulate) {
                this.inv.func_70299_a(slot, stack.func_77979_a(m));
                return stack;
            }
            ItemStackTools.incStackSize((ItemStack)stack, (int)(-m));
            return stack;
        }
        if (!simulate) {
            this.inv.func_70299_a(slot, stack);
        }
        return ItemStackTools.getEmptyStack();
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        int i = FacedSidedInvWrapper.getSlot(this.inv, slot, this.facing);
        this.inv.func_70299_a(i, stack);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStackTools.getEmptyStack();
        }
        int slot1 = FacedSidedInvWrapper.getSlot(this.inv, slot, this.facing);
        if (slot1 == -1) {
            return ItemStackTools.getEmptyStack();
        }
        ItemStack stackInSlot = this.inv.func_70301_a(slot1);
        if (ItemStackTools.isEmpty((ItemStack)stackInSlot)) {
            return ItemStackTools.getEmptyStack();
        }
        if (this.facing != null && !this.inv.func_180461_b(slot1, stackInSlot, this.facing)) {
            return ItemStackTools.getEmptyStack();
        }
        if (simulate) {
            if (ItemStackTools.getStackSize((ItemStack)stackInSlot) < amount) {
                return stackInSlot.func_77946_l();
            }
            ItemStack copy = stackInSlot.func_77946_l();
            ItemStackTools.setStackSize((ItemStack)copy, (int)amount);
            return copy;
        }
        int m = Math.min(ItemStackTools.getStackSize((ItemStack)stackInSlot), amount);
        return this.inv.func_70298_a(slot1, m);
    }
}

