/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib;

import mcjty.lib.network.PacketSendPreferencesToClient;
import mcjty.lib.network.PacketSetGuiStyle;
import mcjty.lib.preferences.PreferencesDispatcher;
import mcjty.lib.preferences.PreferencesProperties;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class McJtyLib {
    public static final String VERSION = "1.11-2.2.0alpha1";
    public static final String OWNER = "McJty";
    public static final String PROVIDES = "McJtyLib";
    private static final ResourceLocation PREFERENCES_CAPABILITY_KEY = new ResourceLocation("McJtyLib", "Preferences");
    @CapabilityInject(value=PreferencesProperties.class)
    public static Capability<PreferencesProperties> PREFERENCES_CAPABILITY;
    public static SimpleNetworkWrapper networkHandler;
    private static boolean init;

    public static void preInit(FMLPreInitializationEvent event) {
        if (init) {
            return;
        }
        McJtyLib.registerCapabilities();
        networkHandler = new SimpleNetworkWrapper(PROVIDES);
        networkHandler.registerMessage(PacketSendPreferencesToClient.Handler.class, PacketSendPreferencesToClient.class, 0, Side.CLIENT);
        networkHandler.registerMessage(PacketSetGuiStyle.Handler.class, PacketSetGuiStyle.class, 1, Side.SERVER);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        init = true;
    }

    public static PreferencesProperties getPreferencesProperties(EntityPlayer player) {
        return (PreferencesProperties)player.getCapability(PREFERENCES_CAPABILITY, null);
    }

    private static void registerCapabilities() {
        CapabilityManager.INSTANCE.register(PreferencesProperties.class, (Capability.IStorage)new Capability.IStorage<PreferencesProperties>(){

            public NBTBase writeNBT(Capability<PreferencesProperties> capability, PreferencesProperties instance, EnumFacing side) {
                throw new UnsupportedOperationException();
            }

            public void readNBT(Capability<PreferencesProperties> capability, PreferencesProperties instance, EnumFacing side, NBTBase nbt) {
                throw new UnsupportedOperationException();
            }
        }, () -> {
            throw new UnsupportedOperationException();
        });
    }

    public static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.START && !event.player.func_130014_f_().field_72995_K) {
                PreferencesProperties preferencesProperties = McJtyLib.getPreferencesProperties(event.player);
                preferencesProperties.tick((EntityPlayerMP)event.player);
            }
        }

        @SubscribeEvent
        public void onEntityConstructing(AttachCapabilitiesEvent.Entity event) {
            if (event.getEntity() instanceof EntityPlayer) {
                if (!event.getCapabilities().containsKey(PREFERENCES_CAPABILITY_KEY) && !event.getEntity().hasCapability(PREFERENCES_CAPABILITY, null)) {
                    event.addCapability(PREFERENCES_CAPABILITY_KEY, (ICapabilityProvider)new PreferencesDispatcher());
                } else {
                    throw new IllegalStateException(event.getEntity().toString());
                }
            }
        }
    }
}

