/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotFactory;
import mcjty.lib.container.SlotRanges;
import mcjty.lib.container.SlotType;
import net.minecraft.item.ItemStack;

public class ContainerFactory {
    private Map<Integer, SlotDefinition> indexToType = new HashMap<Integer, SlotDefinition>();
    private Map<SlotDefinition, SlotRanges> slotRangesMap = new HashMap<SlotDefinition, SlotRanges>();
    private List<SlotFactory> slots = new ArrayList<SlotFactory>();
    public static final String CONTAINER_PLAYER = "player";
    private boolean slotsSetup = false;
    private int[] accessibleSlots;
    private int[] accessibleInputSlots;
    private int[] accessibleOutputSlots;

    public ContainerFactory() {
        this.setup();
    }

    protected void setup() {
    }

    protected void setupAccessibleSlots() {
        if (this.slotsSetup) {
            return;
        }
        this.slotsSetup = true;
        ArrayList<Integer> s = new ArrayList<Integer>();
        ArrayList<Integer> si = new ArrayList<Integer>();
        ArrayList<Integer> so = new ArrayList<Integer>();
        int index = 0;
        for (SlotFactory slotFactory : this.slots) {
            if (slotFactory.getSlotType() == SlotType.SLOT_INPUT) {
                s.add(index);
                si.add(index);
            }
            if (slotFactory.getSlotType() == SlotType.SLOT_OUTPUT) {
                s.add(index);
                so.add(index);
            }
            ++index;
        }
        this.accessibleSlots = ContainerFactory.convertList(s);
        this.accessibleInputSlots = ContainerFactory.convertList(si);
        this.accessibleOutputSlots = ContainerFactory.convertList(so);
    }

    private static int[] convertList(List<Integer> list) {
        int[] s = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            s[i] = list.get(i);
        }
        return s;
    }

    public Map<SlotDefinition, SlotRanges> getSlotRangesMap() {
        return this.slotRangesMap;
    }

    public int[] getAccessibleSlots() {
        this.setupAccessibleSlots();
        return this.accessibleSlots;
    }

    public int[] getAccessibleInputSlots() {
        this.setupAccessibleSlots();
        return this.accessibleInputSlots;
    }

    public int[] getAccessibleOutputSlots() {
        this.setupAccessibleSlots();
        return this.accessibleOutputSlots;
    }

    public Iterable<SlotFactory> getSlots() {
        return this.slots;
    }

    public SlotType getSlotType(int index) {
        SlotDefinition slotDefinition = this.indexToType.get(index);
        if (slotDefinition == null) {
            return SlotType.SLOT_UNKNOWN;
        }
        return slotDefinition.getType();
    }

    public boolean isContainerSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_CONTAINER;
    }

    public boolean isOutputSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_OUTPUT;
    }

    public boolean isInputSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_INPUT;
    }

    public boolean isGhostSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_GHOST;
    }

    public boolean isGhostOutputSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_GHOSTOUT;
    }

    public boolean isCraftResultSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_CRAFTRESULT;
    }

    public boolean isPlayerInventorySlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_PLAYERINV;
    }

    public boolean isSpecificItemSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_SPECIFICITEM;
    }

    public boolean isPlayerHotbarSlot(int index) {
        return this.getSlotType(index) == SlotType.SLOT_PLAYERHOTBAR;
    }

    public void addSlot(SlotDefinition slotDefinition, String inventoryName, int index, int x, int y) {
        SlotFactory slotFactory = new SlotFactory(slotDefinition, inventoryName, index, x, y);
        int slotIndex = this.slots.size();
        this.slots.add(slotFactory);
        SlotRanges slotRanges = this.slotRangesMap.get(slotDefinition);
        if (slotRanges == null) {
            slotRanges = new SlotRanges(slotDefinition);
            this.slotRangesMap.put(slotDefinition, slotRanges);
        }
        slotRanges.addSingle(slotIndex);
        this.indexToType.put(slotIndex, slotDefinition);
    }

    public int addSlotRange(SlotDefinition slotDefinition, String inventoryName, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot(slotDefinition, inventoryName, index, x, y);
            x += dx;
            ++index;
        }
        return index;
    }

    public int addSlotBox(SlotDefinition slotDefinition, String inventoryName, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(slotDefinition, inventoryName, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    protected void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(new SlotDefinition(SlotType.SLOT_PLAYERINV, new ItemStack[0]), CONTAINER_PLAYER, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(new SlotDefinition(SlotType.SLOT_PLAYERHOTBAR, new ItemStack[0]), CONTAINER_PLAYER, 0, leftCol, topRow += 58, 9, 18);
    }
}

