/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.icons;

import java.util.Optional;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.icons.IIcon;
import mcjty.lib.gui.widgets.IconHolder;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Mouse;

public class IconManager {
    private final WindowManager windowManager;
    private IIcon draggingIcon;
    private IconHolder origin;
    private int dx;
    private int dy;
    private int x;
    private int y;
    private boolean clickHoldToDrag = false;

    public IconManager(WindowManager windowManager) {
        this.windowManager = windowManager;
    }

    public void startDragging(IIcon icon, IconHolder origin, int iconX, int iconY) {
        this.draggingIcon = icon;
        this.origin = origin;
        this.dx = iconX - 2;
        this.dy = iconY - 1;
    }

    public boolean isClickHoldToDrag() {
        return this.clickHoldToDrag;
    }

    public void setClickHoldToDrag(boolean clickHoldToDrag) {
        this.clickHoldToDrag = clickHoldToDrag;
    }

    public void cancelDragging() {
        if (this.draggingIcon == null) {
            return;
        }
        if (this.origin != null) {
            this.origin.setIcon(this.draggingIcon);
        }
        this.draggingIcon = null;
        this.origin = null;
    }

    public void stopDragging(int x, int y) {
        if (this.draggingIcon == null) {
            return;
        }
        IconHolder iconHolder = this.findClosestIconHolder(x, y);
        if (iconHolder == null || iconHolder.getIcon() != null) {
            if (this.origin != null) {
                this.origin.setIcon(this.draggingIcon);
            }
        } else if (!iconHolder.setIcon(this.draggingIcon)) {
            if (this.origin != null) {
                this.origin.setIcon(this.draggingIcon);
            }
        } else if (iconHolder.isSelectable()) {
            this.windowManager.setFocus(iconHolder);
        }
        this.draggingIcon = null;
        this.origin = null;
    }

    private IconHolder findClosestIconHolder(int x, int y) {
        Optional<Widget> widget = this.windowManager.findWidgetAtPosition(x, y);
        if (widget.isPresent() && widget.get() instanceof IconHolder) {
            return (IconHolder)widget.get();
        }
        return null;
    }

    public boolean isDragging() {
        return this.draggingIcon != null;
    }

    public void draw(Minecraft mc, Gui gui) {
        if (this.draggingIcon != null) {
            this.draggingIcon.draw(mc, gui, this.getRelativeX() - this.dx, this.getRelativeY() - this.dy);
        }
    }

    private int getRelativeX() {
        GuiScreen gui = this.windowManager.getGui();
        return Mouse.getEventX() * gui.field_146294_l / gui.field_146297_k.field_71443_c;
    }

    private int getRelativeY() {
        GuiScreen gui = this.windowManager.getGui();
        return gui.field_146295_m - Mouse.getEventY() * gui.field_146295_m / gui.field_146297_k.field_71440_d - 1;
    }
}

