/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyTools {
    public static boolean isEnergyTE(TileEntity te) {
        return te instanceof IEnergyHandler || te != null && te.hasCapability(CapabilityEnergy.ENERGY, null);
    }

    public static EnergyLevelMulti getEnergyLevelMulti(TileEntity tileEntity) {
        long energyStored;
        long maxEnergyStored;
        if (tileEntity instanceof IEnergyHandler) {
            IEnergyHandler handler = (IEnergyHandler)tileEntity;
            maxEnergyStored = handler.getMaxEnergyStored(EnumFacing.DOWN);
            energyStored = handler.getEnergyStored(EnumFacing.DOWN);
        } else if (tileEntity != null && tileEntity.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage energy = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, null);
            maxEnergyStored = energy.getMaxEnergyStored();
            energyStored = energy.getEnergyStored();
        } else {
            maxEnergyStored = 0L;
            energyStored = 0L;
        }
        return new EnergyLevelMulti(energyStored, maxEnergyStored);
    }

    public static EnergyLevel getEnergyLevel(TileEntity tileEntity) {
        int energyStored;
        int maxEnergyStored;
        if (tileEntity instanceof IEnergyHandler) {
            IEnergyHandler handler = (IEnergyHandler)tileEntity;
            maxEnergyStored = handler.getMaxEnergyStored(EnumFacing.DOWN);
            energyStored = handler.getEnergyStored(EnumFacing.DOWN);
        } else if (tileEntity != null && tileEntity.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage energy = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, null);
            maxEnergyStored = energy.getMaxEnergyStored();
            energyStored = energy.getEnergyStored();
        } else {
            maxEnergyStored = 0;
            energyStored = 0;
        }
        return new EnergyLevel(energyStored, maxEnergyStored);
    }

    public static int receiveEnergy(TileEntity tileEntity, EnumFacing from, int maxReceive) {
        IEnergyStorage capability;
        if (tileEntity instanceof IEnergyReceiver) {
            return ((IEnergyReceiver)tileEntity).receiveEnergy(from, maxReceive, false);
        }
        if (tileEntity != null && tileEntity.hasCapability(CapabilityEnergy.ENERGY, from) && (capability = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, from)).canReceive()) {
            return capability.receiveEnergy(maxReceive, false);
        }
        return 0;
    }

    public static class EnergyLevelMulti {
        private final long energy;
        private final long maxEnergy;

        public EnergyLevelMulti(long energy, long maxEnergy) {
            this.energy = energy;
            this.maxEnergy = maxEnergy;
        }

        public long getEnergy() {
            return this.energy;
        }

        public long getMaxEnergy() {
            return this.maxEnergy;
        }
    }

    public static class EnergyLevel {
        private final int energy;
        private final int maxEnergy;

        public EnergyLevel(int energy, int maxEnergy) {
            this.energy = energy;
            this.maxEnergy = maxEnergy;
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getMaxEnergy() {
            return this.maxEnergy;
        }
    }
}

