/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.streak.common;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import me.ichun.mods.ichunutil.common.core.Logger;
import me.ichun.mods.ichunutil.common.core.config.ConfigBase;
import me.ichun.mods.ichunutil.common.core.config.ConfigHandler;
import me.ichun.mods.ichunutil.common.core.util.ResourceHelper;
import me.ichun.mods.ichunutil.common.module.update.UpdateChecker;
import me.ichun.mods.streak.common.core.Config;
import me.ichun.mods.streak.common.core.EventHandlerClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="streak", name="Streak", version="6.0.0", guiFactory="me.ichun.mods.ichunutil.common.core.config.GenericModGuiFactory", dependencies="required-after:ichunutil@[6.0.0,7.0.0)", clientSideOnly=true, acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.10.2]")
public class Streak {
    public static final String VERSION = "6.0.0";
    public static final String MOD_NAME = "Streak";
    public static final String MOD_ID = "streak";
    @Mod.Instance(value="streak")
    public static Streak instance;
    public static final Logger LOGGER;
    public static Config config;
    public static EventHandlerClient eventHandlerClient;
    public static HashMap<String, Integer> flavourNames;
    public static HashMap<Integer, BufferedImage> flavours;
    public static HashMap<BufferedImage, Integer> flavourImageId;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = (Config)ConfigHandler.registerConfig((ConfigBase)new Config(event.getSuggestedConfigurationFile()));
        UpdateChecker.registerMod((UpdateChecker.ModVersionInfo)new UpdateChecker.ModVersionInfo(MOD_NAME, "1.10.2", VERSION, false));
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        eventHandlerClient = new EventHandlerClient();
        MinecraftForge.EVENT_BUS.register((Object)eventHandlerClient);
        File streakDir = new File(ResourceHelper.getModsFolder(), "/Streak Flavours");
        if (!streakDir.exists() && streakDir.mkdirs()) {
            try (InputStream in = Streak.class.getResourceAsStream("/flavours.zip");
                 ZipInputStream zipStream = new ZipInputStream(in);){
                ZipEntry entry = null;
                int extractCount = 0;
                while ((entry = zipStream.getNextEntry()) != null) {
                    int len;
                    File file = new File(streakDir, entry.getName());
                    if (file.exists() && file.length() > 3L) continue;
                    FileOutputStream out = new FileOutputStream(file);
                    byte[] buffer = new byte[8192];
                    while ((len = zipStream.read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                    }
                    out.close();
                    ++extractCount;
                }
                if (extractCount > 0) {
                    LOGGER.info((Object)("Extracted " + Integer.toString(extractCount) + (extractCount == 1 ? " flavour" : " flavours from mod zip.")));
                }
            }
            catch (IOException | NullPointerException e) {
                LOGGER.warn((Object)"Failed to extract streak flavours from mod jar");
                e.printStackTrace();
            }
        }
        for (File file : streakDir.listFiles()) {
            if (!file.getName().endsWith(".png")) continue;
            try {
                BufferedImage img = ImageIO.read(file);
                if (img == null) continue;
                flavourNames.put(file.getName().substring(0, file.getName().length() - 4).toLowerCase(), flavours.size());
                flavours.put(flavours.size(), img);
                flavourImageId.put(img, -1);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        LOGGER = Logger.createLogger((String)MOD_NAME);
        flavourNames = new HashMap();
        flavours = new HashMap();
        flavourImageId = new HashMap();
    }
}

