/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.client;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import twopiradians.blockArmor.client.gui.armorDisplay.OpenGuiEvent;
import twopiradians.blockArmor.client.model.ModelBlockArmor;
import twopiradians.blockArmor.client.model.ModelDynBlockArmor;
import twopiradians.blockArmor.common.BlockArmor;
import twopiradians.blockArmor.common.CommonProxy;
import twopiradians.blockArmor.common.block.ModBlocks;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.item.ModItems;
import twopiradians.blockArmor.jei.BlockArmorJEIPlugin;
import twopiradians.blockArmor.packets.DisableItemsPacket;

public class ClientProxy
extends CommonProxy {
    private HashMap<String, ModelBlockArmor> modelMaps = Maps.newHashMap();
    private boolean sendDisablePacket;

    @Override
    public void preInit() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelDynBlockArmor.LoaderDynBlockArmor.INSTANCE);
    }

    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new OpenGuiEvent());
    }

    @Override
    public void postInit() {
        ModBlocks.registerRenders();
        ModItems.registerRenders();
    }

    @Override
    public Object getBlockArmorModel(int height, int width, int currentFrame, int nextFrame, EntityEquipmentSlot slot) {
        String key = height + "" + width + "" + currentFrame + "" + nextFrame + "" + slot.func_188450_d();
        ModelBlockArmor model = this.modelMaps.get(key);
        if (model == null) {
            model = new ModelBlockArmor(height, width, currentFrame, nextFrame, slot);
            this.modelMaps.put(key, model);
        }
        return model;
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        this.sendDisablePacket = true;
    }

    @Override
    public void loadComplete(FMLLoadCompleteEvent event) {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(new IResourceManagerReloadListener(){

            public void func_110549_a(IResourceManager resourceManager) {
                ClientProxy.this.mapTextures();
                if (ArmorSet.disabledItems != null && !ArmorSet.disabledItems.isEmpty() && Loader.isModLoaded((String)"JEI") && BlockArmorJEIPlugin.helpers != null) {
                    try {
                        BlockArmor.logger.info("Reloading JEI...");
                        BlockArmorJEIPlugin.helpers.reload();
                    }
                    catch (Exception e) {
                        BlockArmor.logger.error("Another mod caused an exception while reloading JEI: ", (Throwable)e);
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (this.sendDisablePacket && Minecraft.func_71410_x().field_71439_g != null) {
            this.sendDisablePacket = false;
            BlockArmor.network.sendToServer((IMessage)new DisableItemsPacket(ArmorSet.disabledItems));
        }
        if (!Minecraft.func_71410_x().func_147113_T() && event.side == Side.CLIENT) {
            for (ArmorSet set : ArmorSet.allSets) {
                for (int i = 0; i < 4; ++i) {
                    if (set.animations[i] == null) continue;
                    int n = i;
                    set.frames[n] = set.frames[n] + 0.5f / (float)set.animations[i].func_110472_a((int)set.frames[i]);
                    if (!(set.frames[i] >= (float)set.animations[i].func_110473_c())) continue;
                    int n2 = i;
                    set.frames[n2] = set.frames[n2] - (float)set.animations[i].func_110473_c();
                }
            }
        }
    }

    private void mapTextures() {
        this.modelMaps = Maps.newHashMap();
        int numTextures = 0;
        ArmorSet.disabledItems = new ArrayList();
        for (ArmorSet set : ArmorSet.allSets) {
            numTextures += set.initTextures();
        }
        if (numTextures == 0) {
            BlockArmor.logger.info("Textures not loaded yet, clearing disabled items");
            ArmorSet.disabledItems.clear();
            return;
        }
        BlockArmor.logger.info("Found " + numTextures + " block textures for Block Armor");
        this.sendDisablePacket = true;
        ArmorSet.disableItems();
        int numIcons = ModelDynBlockArmor.BakedDynBlockArmorOverrideHandler.createInventoryIcons();
        BlockArmor.logger.info("Created " + numIcons + " inventory icons for Block Armor");
    }

    @SubscribeEvent
    public void textureStitch(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/reeds"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_helmet_base"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_helmet_cover"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_helmet1_template"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_helmet2_template"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_chestplate_base"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_chestplate_cover"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_chestplate1_template"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_chestplate2_template"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_leggings_base"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_leggings_cover"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_leggings1_template"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_leggings2_template"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_boots_base"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_boots_cover"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_boots1_template"));
        event.getMap().func_174942_a(new ResourceLocation("blockarmor", "items/icons/block_armor_boots2_template"));
    }
}

