/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.client.model;

import java.awt.Color;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twopiradians.blockArmor.client.model.ModelPlane;
import twopiradians.blockArmor.common.command.CommandDev;

@SideOnly(value=Side.CLIENT)
public class ModelBlockArmor
extends ModelBiped {
    private ModelRenderer normalBipedHead;
    private ModelRenderer normalBipedBody;
    private ModelRenderer normalBipedRightArm;
    private ModelRenderer normalBipedLeftArm;
    private ModelRenderer normalBipedRightLeg;
    private ModelRenderer normalBipedLeftLeg;
    private ModelRenderer normalBipedWaist;
    private ModelRenderer normalBipedRightFoot;
    private ModelRenderer normalBipedLeftFoot;
    private ModelRenderer offsetBipedHead;
    private ModelRenderer offsetBipedBody;
    private ModelRenderer offsetBipedRightArm;
    private ModelRenderer offsetBipedLeftArm;
    private ModelRenderer offsetBipedRightLeg;
    private ModelRenderer offsetBipedLeftLeg;
    private ModelRenderer offsetBipedWaist;
    private ModelRenderer offsetBipedRightFoot;
    private ModelRenderer offsetBipedLeftFoot;
    private ModelRenderer bipedWaist;
    private ModelRenderer bipedRightFoot;
    private ModelRenderer bipedLeftFoot;
    public boolean translucent;
    public int color;
    public float alpha;
    private boolean renderingEnchantment;

    public ModelBlockArmor(int textureHeight, int textureWidth, int currentFrame, int nextFrame, EntityEquipmentSlot slot) {
        int size = Math.max(1, textureWidth / 16);
        this.field_78089_u = textureHeight / size;
        this.field_78090_t = textureWidth / size;
        if (currentFrame != nextFrame) {
            this.createModel(slot, this.field_78090_t * nextFrame);
            this.offsetBipedHead = this.field_78116_c;
            this.offsetBipedBody = this.field_78115_e;
            this.offsetBipedRightArm = this.field_178723_h;
            this.offsetBipedLeftArm = this.field_178724_i;
            this.offsetBipedRightLeg = this.field_178721_j;
            this.offsetBipedLeftLeg = this.field_178722_k;
            this.offsetBipedWaist = this.bipedWaist;
            this.offsetBipedRightFoot = this.bipedRightFoot;
            this.offsetBipedLeftFoot = this.bipedLeftFoot;
        }
        this.createModel(slot, this.field_78090_t * currentFrame);
        this.normalBipedHead = this.field_78116_c;
        this.normalBipedBody = this.field_78115_e;
        this.normalBipedRightArm = this.field_178723_h;
        this.normalBipedLeftArm = this.field_178724_i;
        this.normalBipedRightLeg = this.field_178721_j;
        this.normalBipedLeftLeg = this.field_178722_k;
        this.normalBipedWaist = this.bipedWaist;
        this.normalBipedRightFoot = this.bipedRightFoot;
        this.normalBipedLeftFoot = this.bipedLeftFoot;
    }

    public void createModel(EntityEquipmentSlot slot, int yOffset) {
        this.field_178720_f = new ModelRenderer((ModelBase)this, 0, 0);
        this.field_78116_c = new ModelRenderer((ModelBase)this, 0, 0);
        this.field_78116_c.func_78793_a(0.0f, 0.0f, 0.0f);
        this.field_78115_e = new ModelRenderer((ModelBase)this, 0, 0);
        this.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
        this.field_178723_h = new ModelRenderer((ModelBase)this, 0, 0);
        this.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
        this.field_178724_i = new ModelRenderer((ModelBase)this, 0, 0);
        this.field_178724_i.field_78809_i = true;
        this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
        this.bipedWaist = new ModelRenderer((ModelBase)this, 0, 0);
        this.bipedWaist.func_78793_a(0.0f, 0.0f, 0.0f);
        this.field_178721_j = new ModelRenderer((ModelBase)this, 0, 0);
        this.field_178721_j.func_78793_a(-1.9f, 12.0f, 0.0f);
        this.field_178722_k = new ModelRenderer((ModelBase)this, 0, 0);
        this.field_178722_k.field_78809_i = true;
        this.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
        this.bipedRightFoot = new ModelRenderer((ModelBase)this, 0, 0);
        this.bipedRightFoot.func_78793_a(-1.9f, 12.0f, 0.0f);
        this.bipedLeftFoot = new ModelRenderer((ModelBase)this, 0, 0);
        this.bipedLeftFoot.field_78809_i = true;
        this.bipedLeftFoot.func_78793_a(1.9f, 12.0f, 0.0f);
        switch (slot) {
            case HEAD: {
                this.field_78116_c.field_78804_l.add(new ModelPlane(this.field_78116_c, 9, 3 + yOffset, -5.0f, -9.0f, -5.0f, 10, 0, 10, false));
                this.field_78116_c.field_78804_l.add(new ModelPlane(this.field_78116_c, 3, 0 + yOffset, -5.0f, -9.0f, 5.0f, 10, 8, 0, true));
                this.field_78116_c.field_78804_l.add(new ModelPlane(this.field_78116_c, 5, 8 + yOffset, -3.0f, -1.0f, 5.0f, 6, 1, 0, true));
                this.field_78116_c.field_78804_l.add(new ModelPlane(this.field_78116_c, 0, -10 + yOffset, -5.0f, -9.0f, -5.0f, 0, 5, 10, false));
                this.field_78116_c.field_78804_l.add(new ModelPlane(this.field_78116_c, 0, 0 + yOffset, -5.0f, -4.0f, -0.0f, 0, 1, 5, false));
                this.field_78116_c.field_78804_l.add(new ModelPlane(this.field_78116_c, 6, -10 + yOffset, 5.0f, -9.0f, -5.0f, 0, 5, 10, true));
                this.field_78116_c.field_78804_l.add(new ModelPlane(this.field_78116_c, 11, 0 + yOffset, 5.0f, -4.0f, -0.0f, 0, 1, 5, true));
                this.field_78116_c.field_78804_l.add(new ModelPlane(this.field_78116_c, 3, 0 + yOffset, -5.0f, -9.0f, -5.0f, 10, 4, 0, false));
                this.field_78116_c.field_78804_l.add(new ModelPlane(this.field_78116_c, 0, 4 + yOffset, -5.0f, -5.0f, -5.0f, 1, 1, 0, false));
                this.field_78116_c.field_78804_l.add(new ModelPlane(this.field_78116_c, 7, 4 + yOffset, -1.0f, -5.0f, -5.0f, 2, 2, 0, false));
                this.field_78116_c.field_78804_l.add(new ModelPlane(this.field_78116_c, 12, 4 + yOffset, 4.0f, -5.0f, -5.0f, 1, 1, 0, false));
                break;
            }
            case CHEST: {
                this.field_78115_e.field_78804_l.add(new ModelPlane(this.field_78115_e, 3, 4 + yOffset, -5.0f, 1.0f, -3.0f, 10, 8, 0, false));
                this.field_78115_e.field_78804_l.add(new ModelPlane(this.field_78115_e, 4, 12 + yOffset, -4.0f, 9.0f, -3.0f, 8, 1, 0, false));
                this.field_78115_e.field_78804_l.add(new ModelPlane(this.field_78115_e, 5, 13 + yOffset, -3.0f, 10.0f, -3.0f, 6, 1, 0, false));
                this.field_78115_e.field_78804_l.add(new ModelPlane(this.field_78115_e, 3, 2 + yOffset, -5.0f, -1.0f, -3.0f, 2, 2, 0, false));
                this.field_78115_e.field_78804_l.add(new ModelPlane(this.field_78115_e, 5, 2 + yOffset, -3.0f, -0.0f, -3.0f, 1, 1, 0, false));
                this.field_78115_e.field_78804_l.add(new ModelPlane(this.field_78115_e, 11, 2 + yOffset, 3.0f, -1.0f, -3.0f, 2, 2, 0, false));
                this.field_78115_e.field_78804_l.add(new ModelPlane(this.field_78115_e, 10, 2 + yOffset, 2.0f, -0.0f, -3.0f, 1, 1, 0, false));
                this.field_78115_e.field_78804_l.add(new ModelPlane(this.field_78115_e, 5, -4 + yOffset, -5.0f, -1.0f, -3.0f, 0, 10, 6, true));
                this.field_78115_e.field_78804_l.add(new ModelPlane(this.field_78115_e, 5, -4 + yOffset, 5.0f, -1.0f, -3.0f, 0, 10, 6, false));
                this.field_78115_e.field_78804_l.add(new ModelPlane(this.field_78115_e, 3, 3 + yOffset, -5.0f, 0.0f, 3.0f, 10, 9, 0, true));
                this.field_78115_e.field_78804_l.add(new ModelPlane(this.field_78115_e, 11, 2 + yOffset, -5.0f, -1.0f, 3.0f, 2, 1, 0, true));
                this.field_78115_e.field_78804_l.add(new ModelPlane(this.field_78115_e, 3, 2 + yOffset, 3.0f, -1.0f, 3.0f, 2, 1, 0, true));
                this.field_78115_e.field_78804_l.add(new ModelPlane(this.field_78115_e, 4, 12 + yOffset, -4.0f, 9.0f, 3.0f, 8, 1, 0, true));
                this.field_178723_h.field_78804_l.add(new ModelPlane(this.field_178723_h, 5, -1 + yOffset, -4.5f, -3.0f, -3.0f, 0, 6, 6, true));
                this.field_178723_h.field_78804_l.add(new ModelPlane(this.field_178723_h, 5, -1 + yOffset, 1.5f, -3.0f, -3.0f, 0, 6, 6, true));
                this.field_178723_h.field_78804_l.add(new ModelPlane(this.field_178723_h, 5, 5 + yOffset, -4.5f, -3.0f, -3.0f, 6, 6, 0, false));
                this.field_178723_h.field_78804_l.add(new ModelPlane(this.field_178723_h, 5, 5 + yOffset, -4.5f, -3.0f, 3.0f, 6, 6, 0, true));
                this.field_178723_h.field_78804_l.add(new ModelPlane(this.field_178723_h, 15, 5 + yOffset, -4.5f, -3.0f, -3.0f, 6, 0, 6, false));
                this.field_178724_i.field_78804_l.add(new ModelPlane(this.field_178724_i, 5, -1 + yOffset, -1.5f, -3.0f, -3.0f, 0, 6, 6, false));
                this.field_178724_i.field_78804_l.add(new ModelPlane(this.field_178724_i, 5, -1 + yOffset, 4.5f, -3.0f, -3.0f, 0, 6, 6, false));
                this.field_178724_i.field_78804_l.add(new ModelPlane(this.field_178724_i, 5, 5 + yOffset, -1.5f, -3.0f, -3.0f, 6, 6, 0, false));
                this.field_178724_i.field_78804_l.add(new ModelPlane(this.field_178724_i, 5, 5 + yOffset, -1.5f, -3.0f, 3.0f, 6, 6, 0, true));
                this.field_178724_i.field_78804_l.add(new ModelPlane(this.field_178724_i, 15, 5 + yOffset, -1.5f, -3.0f, -3.0f, 6, 0, 6, false));
                break;
            }
            case LEGS: {
                this.bipedWaist.field_78804_l.add(new ModelPlane(this.bipedWaist, 3, 1 + yOffset, -4.5f, 6.5f, -2.5f, 9, 6, 0, false));
                this.bipedWaist.field_78804_l.add(new ModelPlane(this.bipedWaist, 5, -4 + yOffset, -4.5f, 6.5f, -2.5f, 0, 6, 5, true));
                this.bipedWaist.field_78804_l.add(new ModelPlane(this.bipedWaist, 5, -4 + yOffset, 4.5f, 6.5f, -2.5f, 0, 6, 5, false));
                this.bipedWaist.field_78804_l.add(new ModelPlane(this.bipedWaist, 3, 1 + yOffset, -4.5f, 6.5f, 2.5f, 9, 6, 0, true));
                this.field_178721_j.field_78804_l.add(new ModelPlane(this.field_178721_j, 5, 0 + yOffset, -2.5f, -0.5f, -2.5f, 0, 10, 5, true));
                this.field_178721_j.field_78804_l.add(new ModelPlane(this.field_178721_j, 9, 5 + yOffset, 2.5f, -0.5f, -2.5f, 0, 10, 5, true));
                this.field_178721_j.field_78804_l.add(new ModelPlane(this.field_178721_j, 3, 5 + yOffset, -2.5f, -0.5f, -2.5f, 5, 10, 0, false));
                this.field_178721_j.field_78804_l.add(new ModelPlane(this.field_178721_j, 7, 5 + yOffset, -2.5f, -0.5f, 2.5f, 5, 10, 0, true));
                this.field_178721_j.field_78804_l.add(new ModelPlane(this.field_178721_j, 9, 0 + yOffset, -2.5f, -0.5f, -2.5f, 5, 0, 5, false));
                this.field_178722_k.field_78804_l.add(new ModelPlane(this.field_178722_k, 9, 5 + yOffset, -2.5f, -0.5f, -2.5f, 0, 10, 5, true));
                this.field_178722_k.field_78804_l.add(new ModelPlane(this.field_178722_k, 6, 0 + yOffset, 2.5f, -0.5f, -2.5f, 0, 10, 5, true));
                this.field_178722_k.field_78804_l.add(new ModelPlane(this.field_178722_k, 7, 5 + yOffset, -2.5f, -0.5f, -2.5f, 5, 10, 0, false));
                this.field_178722_k.field_78804_l.add(new ModelPlane(this.field_178722_k, 3, 5 + yOffset, -2.5f, -0.5f, 2.5f, 5, 10, 0, true));
                this.field_178722_k.field_78804_l.add(new ModelPlane(this.field_178722_k, 9, 0 + yOffset, -2.5f, -0.5f, -2.5f, 5, 0, 5, false));
                break;
            }
            case FEET: {
                this.bipedRightFoot.field_78804_l.add(new ModelPlane(this.bipedRightFoot, 21, -6 + yOffset, -3.0f, 6.0f, -3.0f, 0, 7, 6, false));
                this.bipedRightFoot.field_78804_l.add(new ModelPlane(this.bipedRightFoot, 21, -6 + yOffset, 3.0f, 6.0f, -3.0f, 0, 7, 6, true));
                this.bipedRightFoot.field_78804_l.add(new ModelPlane(this.bipedRightFoot, 11, 0 + yOffset, -3.0f, 6.0f, -3.0f, 6, 7, 0, false));
                this.bipedRightFoot.field_78804_l.add(new ModelPlane(this.bipedRightFoot, 15, 0 + yOffset, -3.0f, 6.0f, 3.0f, 6, 7, 0, true));
                this.bipedRightFoot.field_78804_l.add(new ModelPlane(this.bipedRightFoot, 18, 0 + yOffset, -3.0f, 13.0f, -3.0f, 6, 0, 6, false));
                this.bipedLeftFoot.field_78804_l.add(new ModelPlane(this.bipedLeftFoot, 21, -6 + yOffset, -3.0f, 6.0f, -3.0f, 0, 7, 6, true));
                this.bipedLeftFoot.field_78804_l.add(new ModelPlane(this.bipedLeftFoot, 21, -6 + yOffset, 3.0f, 6.0f, -3.0f, 0, 7, 6, true));
                this.bipedLeftFoot.field_78804_l.add(new ModelPlane(this.bipedLeftFoot, 15, 0 + yOffset, -3.0f, 6.0f, -3.0f, 6, 7, 0, false));
                this.bipedLeftFoot.field_78804_l.add(new ModelPlane(this.bipedLeftFoot, 11, 0 + yOffset, -3.0f, 6.0f, 3.0f, 6, 7, 0, true));
                this.bipedLeftFoot.field_78804_l.add(new ModelPlane(this.bipedLeftFoot, 18, 0 + yOffset, -3.0f, 13.0f, -3.0f, 6, 0, 6, false));
                break;
            }
        }
    }

    public void func_78086_a(EntityLivingBase entitylivingbaseIn, float p_78086_2_, float p_78086_3_, float partialTickTime) {
        super.func_78086_a(entitylivingbaseIn, p_78086_2_, p_78086_3_, partialTickTime);
        this.renderingEnchantment = false;
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.actualRender(false, entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        if (this.alpha > 0.0f && this.offsetBipedHead != null && !this.renderingEnchantment) {
            this.field_78116_c = this.offsetBipedHead;
            this.field_78115_e = this.offsetBipedBody;
            this.field_178723_h = this.offsetBipedRightArm;
            this.field_178724_i = this.offsetBipedLeftArm;
            this.field_178721_j = this.offsetBipedRightLeg;
            this.field_178722_k = this.offsetBipedLeftLeg;
            this.bipedWaist = this.offsetBipedWaist;
            this.bipedRightFoot = this.offsetBipedRightFoot;
            this.bipedLeftFoot = this.offsetBipedLeftFoot;
            this.actualRender(true, entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            this.field_78116_c = this.normalBipedHead;
            this.field_78115_e = this.normalBipedBody;
            this.field_178723_h = this.normalBipedRightArm;
            this.field_178724_i = this.normalBipedLeftArm;
            this.field_178721_j = this.normalBipedRightLeg;
            this.field_178722_k = this.normalBipedLeftLeg;
            this.bipedWaist = this.normalBipedWaist;
            this.bipedRightFoot = this.normalBipedRightFoot;
            this.bipedLeftFoot = this.normalBipedLeftFoot;
        }
        this.renderingEnchantment = true;
    }

    private void actualRender(boolean animationOverlay, Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        Float[] color;
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entityIn);
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        if (this.color != -1) {
            this.color |= 0xFF000000;
            float cb = this.color & 0xFF;
            float cg = this.color >>> 8 & 0xFF;
            float cr = this.color >>> 16 & 0xFF;
            red = cr / 255.0f;
            green = cg / 255.0f;
            blue = cb / 255.0f;
        }
        if ((color = CommandDev.devColors.get(entityIn.getPersistentID())) != null) {
            if (color[0].floatValue() == 0.0f && color[1].floatValue() == 0.0f && color[2].floatValue() == 0.0f) {
                Color color2 = Color.getHSBColor(ageInTicks / 30.0f, 1.0f, 1.0f);
                red = (float)color2.getRed() / 255.0f;
                green = (float)color2.getGreen() / 255.0f;
                blue = (float)color2.getBlue() / 255.0f;
            } else {
                double pulse = (Math.cos(ageInTicks / 5.0f) + 1.0) / 3.0 + 0.01;
                red = (float)((double)red + pulse * (double)color[0].floatValue());
                green = (float)((double)green + pulse * (double)color[1].floatValue());
                blue = (float)((double)blue + pulse * (double)color[2].floatValue());
            }
        }
        if (!this.renderingEnchantment) {
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)(animationOverlay ? this.alpha : 1.0f));
        }
        GlStateManager.func_179094_E();
        if (this.translucent || animationOverlay) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        if (this.field_78091_s) {
            GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
            GlStateManager.func_179109_b((float)0.0f, (float)(16.0f * scale), (float)0.0f);
            this.field_78116_c.func_78785_a(scale);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179109_b((float)0.0f, (float)(24.0f * scale), (float)0.0f);
            this.field_78115_e.func_78785_a(scale);
            this.field_178723_h.func_78785_a(scale);
            this.field_178724_i.func_78785_a(scale);
            this.bipedWaist.func_78785_a(scale);
            this.field_178721_j.func_78785_a(scale);
            this.field_178722_k.func_78785_a(scale);
            this.bipedRightFoot.func_78785_a(scale);
            this.bipedLeftFoot.func_78785_a(scale);
        } else {
            if (entityIn.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            this.field_78116_c.func_78785_a(scale);
            this.field_78115_e.func_78785_a(scale);
            this.field_178723_h.func_78785_a(scale);
            this.field_178724_i.func_78785_a(scale);
            this.bipedWaist.func_78785_a(scale);
            this.field_178721_j.func_78785_a(scale);
            this.field_178722_k.func_78785_a(scale);
            this.bipedRightFoot.func_78785_a(scale);
            this.bipedLeftFoot.func_78785_a(scale);
        }
        if (this.translucent || animationOverlay) {
            GlStateManager.func_179084_k();
        }
        GlStateManager.func_179121_F();
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        super.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
        if (entityIn instanceof EntityZombie) {
            float f2;
            boolean flag = entityIn instanceof EntityZombie && ((EntityZombie)entityIn).func_184734_db();
            float f = MathHelper.func_76126_a((float)(this.field_78095_p * (float)Math.PI));
            float f1 = MathHelper.func_76126_a((float)((1.0f - (1.0f - this.field_78095_p) * (1.0f - this.field_78095_p)) * (float)Math.PI));
            this.field_178723_h.field_78808_h = 0.0f;
            this.field_178724_i.field_78808_h = 0.0f;
            this.field_178723_h.field_78796_g = -(0.1f - f * 0.6f);
            this.field_178724_i.field_78796_g = 0.1f - f * 0.6f;
            this.field_178723_h.field_78795_f = f2 = (float)(-Math.PI) / (flag ? 1.5f : 2.25f);
            this.field_178724_i.field_78795_f = f2;
            this.field_178723_h.field_78795_f += f * 1.2f - f1 * 0.4f;
            this.field_178724_i.field_78795_f += f * 1.2f - f1 * 0.4f;
            this.field_178723_h.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.field_178724_i.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.field_178723_h.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
            this.field_178724_i.field_78795_f -= MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
        } else if (entityIn instanceof EntitySkeleton) {
            ItemStack itemstack = ((EntityLivingBase)entityIn).func_184614_ca();
            EntitySkeleton entityskeleton = (EntitySkeleton)entityIn;
            if (entityskeleton.func_184725_db() && (itemstack == null || itemstack.func_77973_b() != Items.field_151031_f)) {
                float f = MathHelper.func_76126_a((float)(this.field_78095_p * (float)Math.PI));
                float f1 = MathHelper.func_76126_a((float)((1.0f - (1.0f - this.field_78095_p) * (1.0f - this.field_78095_p)) * (float)Math.PI));
                this.field_178723_h.field_78808_h = 0.0f;
                this.field_178724_i.field_78808_h = 0.0f;
                this.field_178723_h.field_78796_g = -(0.1f - f * 0.6f);
                this.field_178724_i.field_78796_g = 0.1f - f * 0.6f;
                this.field_178723_h.field_78795_f = -1.5707964f;
                this.field_178724_i.field_78795_f = -1.5707964f;
                this.field_178723_h.field_78795_f -= f * 1.2f - f1 * 0.4f;
                this.field_178724_i.field_78795_f -= f * 1.2f - f1 * 0.4f;
                this.field_178723_h.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
                this.field_178724_i.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
                this.field_178723_h.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
                this.field_178724_i.field_78795_f -= MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
            }
        } else if (entityIn instanceof EntityArmorStand) {
            EntityArmorStand entityarmorstand = (EntityArmorStand)entityIn;
            this.field_78116_c.field_78795_f = (float)Math.PI / 180 * entityarmorstand.func_175418_s().func_179415_b();
            this.field_78116_c.field_78796_g = (float)Math.PI / 180 * entityarmorstand.func_175418_s().func_179416_c();
            this.field_78116_c.field_78808_h = (float)Math.PI / 180 * entityarmorstand.func_175418_s().func_179413_d();
            this.field_78116_c.func_78793_a(0.0f, 1.0f, 0.0f);
            this.field_78115_e.field_78795_f = (float)Math.PI / 180 * entityarmorstand.func_175408_t().func_179415_b();
            this.field_78115_e.field_78796_g = (float)Math.PI / 180 * entityarmorstand.func_175408_t().func_179416_c();
            this.field_78115_e.field_78808_h = (float)Math.PI / 180 * entityarmorstand.func_175408_t().func_179413_d();
            this.field_178724_i.field_78795_f = (float)Math.PI / 180 * entityarmorstand.func_175404_u().func_179415_b();
            this.field_178724_i.field_78796_g = (float)Math.PI / 180 * entityarmorstand.func_175404_u().func_179416_c();
            this.field_178724_i.field_78808_h = (float)Math.PI / 180 * entityarmorstand.func_175404_u().func_179413_d();
            this.field_178723_h.field_78795_f = (float)Math.PI / 180 * entityarmorstand.func_175411_v().func_179415_b();
            this.field_178723_h.field_78796_g = (float)Math.PI / 180 * entityarmorstand.func_175411_v().func_179416_c();
            this.field_178723_h.field_78808_h = (float)Math.PI / 180 * entityarmorstand.func_175411_v().func_179413_d();
            this.field_178722_k.field_78795_f = (float)Math.PI / 180 * entityarmorstand.func_175403_w().func_179415_b();
            this.field_178722_k.field_78796_g = (float)Math.PI / 180 * entityarmorstand.func_175403_w().func_179416_c();
            this.field_178722_k.field_78808_h = (float)Math.PI / 180 * entityarmorstand.func_175403_w().func_179413_d();
            this.field_178722_k.func_78793_a(1.9f, 11.0f, 0.0f);
            this.field_178721_j.field_78795_f = (float)Math.PI / 180 * entityarmorstand.func_175407_x().func_179415_b();
            this.field_178721_j.field_78796_g = (float)Math.PI / 180 * entityarmorstand.func_175407_x().func_179416_c();
            this.field_178721_j.field_78808_h = (float)Math.PI / 180 * entityarmorstand.func_175407_x().func_179413_d();
            this.field_178721_j.func_78793_a(-1.9f, 11.0f, 0.0f);
        }
        ModelBlockArmor.func_178685_a((ModelRenderer)this.field_78115_e, (ModelRenderer)this.bipedWaist);
        ModelBlockArmor.func_178685_a((ModelRenderer)this.field_178722_k, (ModelRenderer)this.bipedLeftFoot);
        ModelBlockArmor.func_178685_a((ModelRenderer)this.field_178721_j, (ModelRenderer)this.bipedRightFoot);
    }
}

