/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.item;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockSlab;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twopiradians.blockArmor.common.BlockArmor;
import twopiradians.blockArmor.common.command.CommandDev;
import twopiradians.blockArmor.common.config.Config;
import twopiradians.blockArmor.common.item.ItemBlockArmor;

public class ArmorSet {
    public static ArrayList<ArmorSet> allSets;
    public static HashMap<ArmorSet, Boolean> autoGeneratedSets;
    public static HashMap<ArmorSet, Boolean> setsWithEffects;
    public static final ArrayList<ArmorSet> MANUALLY_ADDED_SETS;
    public static ArrayList<ItemStack> disabledItems;
    public ItemStack stack;
    public Item item;
    public int meta;
    public Block block;
    public ItemArmor.ArmorMaterial material;
    public boolean hasSetEffect;
    public ItemBlockArmor helmet;
    public ItemBlockArmor chestplate;
    public ItemBlockArmor leggings;
    public ItemBlockArmor boots;
    public boolean isFromModdedBlock;
    @SideOnly(value=Side.CLIENT)
    public boolean isTranslucent;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite[] sprites;
    @SideOnly(value=Side.CLIENT)
    public AnimationMetadataSection[] animations;
    @SideOnly(value=Side.CLIENT)
    public float[] frames;
    @SideOnly(value=Side.CLIENT)
    private int[] colors;
    @SideOnly(value=Side.CLIENT)
    private static TextureAtlasSprite missingSprite;

    public ArmorSet(ItemStack stack, boolean hasSetEffect) {
        this.stack = stack;
        this.item = stack.func_77973_b();
        try {
            ResourceLocation loc = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.item);
            if (!loc.func_110624_b().equals("minecraft")) {
                this.isFromModdedBlock = true;
            }
        }
        catch (Exception e) {
            this.isFromModdedBlock = true;
        }
        this.meta = stack.func_77960_j();
        this.block = this.item == Items.field_151120_aE ? Blocks.field_150436_aH : ((ItemBlock)this.item).func_179223_d();
        this.hasSetEffect = hasSetEffect;
        if (hasSetEffect) {
            setsWithEffects.put(this, true);
        }
        float blockHardness = 0.0f;
        double durability = 5.0;
        float toughness = 0.0f;
        int enchantability = 12;
        try {
            blockHardness = this.block.func_176195_g(this.block.func_176223_P(), null, new BlockPos(0, 0, 0));
        }
        catch (Exception e) {
            blockHardness = ((Float)ReflectionHelper.getPrivateValue(Block.class, (Object)this.block, (int)11)).floatValue();
        }
        if (blockHardness == -1.0f) {
            durability = 0.0;
            blockHardness = 1000.0f;
        } else {
            durability = 2.0 + 8.0 * Math.log(blockHardness + 1.0f);
        }
        if (blockHardness > 10.0f) {
            toughness = Math.min(blockHardness / 10.0f, 10.0f);
        }
        durability = Math.min(30.0, durability);
        blockHardness = (float)Math.log((double)blockHardness + 1.5) + 1.0f;
        int reductionHelmetBoots = (int)Math.min(Math.floor(Math.log10(Math.pow(blockHardness, 2.0) + 1.0) + 1.6), 3.0);
        int reductionChest = (int)Math.min(blockHardness + 1.0f, 8.0f);
        int reductionLegs = Math.max(reductionChest - 2, reductionHelmetBoots);
        int[] reductionAmounts = new int[]{reductionHelmetBoots, reductionLegs, reductionChest, reductionHelmetBoots};
        this.material = EnumHelper.addArmorMaterial((String)(ArmorSet.getItemStackDisplayName(stack, null) + " Material"), (String)"", (int)((int)durability), (int[])reductionAmounts, (int)enchantability, (SoundEvent)SoundEvents.field_187719_p, (float)toughness);
        this.material.customCraftingMaterial = this.item;
        CommandDev.addBlockName(this);
    }

    public ItemBlockArmor getArmorForSlot(EntityEquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                return this.helmet;
            }
            case CHEST: {
                return this.chestplate;
            }
            case LEGS: {
                return this.leggings;
            }
            case FEET: {
                return this.boots;
            }
        }
        return null;
    }

    public static void postInit() {
        ArrayList<String> displayNames = new ArrayList<String>();
        Block[] blocks = (Block[])Iterators.toArray((Iterator)Block.field_149771_c.iterator(), Block.class);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        block2: for (Block block : blocks) {
            for (int i = 0; i < 16; ++i) {
                try {
                    ItemStack stack = new ItemStack(block, 1, i);
                    if (block.equals(Blocks.field_150364_r) && i > 3) continue block2;
                    if (stack == null || stack.func_77973_b() == null || stack.func_82833_r().equals("") || displayNames.contains(stack.func_82833_r())) continue;
                    stacks.add(stack);
                    displayNames.add(stack.func_82833_r());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        ArrayList<String> registryNames = new ArrayList<String>();
        for (ArmorSet set : MANUALLY_ADDED_SETS) {
            registryNames.add(ArmorSet.getItemStackRegistryName(set.stack));
        }
        allSets = new ArrayList();
        allSets.addAll(MANUALLY_ADDED_SETS);
        for (ItemStack stack : stacks) {
            String registryName;
            if (!ArmorSet.isValid(stack) || ArmorSet.getSet(stack.func_77973_b(), stack.func_77960_j()) != null || registryNames.contains(registryName = ArmorSet.getItemStackRegistryName(stack)) || registryName.equals("")) continue;
            allSets.add(new ArmorSet(stack, false));
            registryNames.add(registryName);
            BlockArmor.logger.debug("Created ArmorSet for: " + stack.func_82833_r());
        }
        for (ArmorSet set : allSets) {
            if (MANUALLY_ADDED_SETS.contains(set)) continue;
            autoGeneratedSets.put(set, true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getSprite(ItemBlockArmor item) {
        ArmorSet set = ArmorSet.getSet(item);
        if (set != null) {
            TextureAtlasSprite sprite = set.sprites[item.func_185083_B_().func_188454_b()];
            return sprite == null ? missingSprite : sprite;
        }
        return missingSprite;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getAlpha(ItemBlockArmor item) {
        ArmorSet set = ArmorSet.getSet(item);
        if (set != null) {
            float frame = set.frames[item.func_185083_B_().func_188454_b()];
            return frame - (float)((int)frame);
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getCurrentAnimationFrame(ItemBlockArmor item) {
        AnimationMetadataSection animation;
        ArmorSet set = ArmorSet.getSet(item);
        if (set != null && (animation = set.animations[item.func_185083_B_().func_188454_b()]) != null) {
            int frame = (int)set.frames[item.func_185083_B_().func_188454_b()];
            return animation.func_110468_c(frame);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getNextAnimationFrame(ItemBlockArmor item) {
        AnimationMetadataSection animation;
        ArmorSet set = ArmorSet.getSet(item);
        if (set != null && (animation = set.animations[item.func_185083_B_().func_188454_b()]) != null) {
            int frame = (int)set.frames[item.func_185083_B_().func_188454_b()];
            if (frame++ >= animation.func_110473_c() - 1) {
                frame -= animation.func_110473_c();
            }
            return animation.func_110468_c(frame);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getColor(ItemBlockArmor item) {
        ArmorSet set = ArmorSet.getSet(item);
        if (set != null) {
            return set.colors[item.func_185083_B_().func_188454_b()];
        }
        return -1;
    }

    public static String getItemStackRegistryName(ItemStack stack) {
        try {
            String registryName = stack.func_77973_b().getRegistryName().func_110623_a().toLowerCase().replace(" ", "_");
            registryName = registryName + (stack.func_77981_g() ? "_" + stack.func_77960_j() : "");
            return registryName;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getItemStackDisplayName(ItemStack stack, EntityEquipmentSlot slot) {
        String name;
        if (stack.func_77973_b() instanceof ItemBlockArmor) {
            ArmorSet set = ArmorSet.getSet((ItemBlockArmor)stack.func_77973_b());
            name = set.stack.func_82833_r();
        } else {
            name = stack.func_77973_b() != null ? stack.func_82833_r() : "";
        }
        name = name.replace("Block of ", "").replace("Block ", "").replace(" Block", "").replace("Sugar Canes", "Sugar Cane").replace("Bricks", "Brick").replace("Planks", "Plank");
        name = TextFormatting.func_110646_a((String)name);
        if (slot != null) {
            switch (slot) {
                case HEAD: {
                    name = name + " Helmet";
                    break;
                }
                case CHEST: {
                    name = name + " Chestplate";
                    break;
                }
                case LEGS: {
                    name = name + " Leggings";
                    break;
                }
                case FEET: {
                    name = name + " Boots";
                    break;
                }
            }
        }
        return name;
    }

    public static boolean isWearingFullSet(EntityLivingBase entity, ArmorSet set) {
        return entity != null && set != null && entity.func_184582_a(EntityEquipmentSlot.HEAD) != null && entity.func_184582_a(EntityEquipmentSlot.CHEST) != null && entity.func_184582_a(EntityEquipmentSlot.LEGS) != null && entity.func_184582_a(EntityEquipmentSlot.FEET) != null && entity.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() == set.boots && entity.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() == set.leggings && entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == set.chestplate && entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == set.helmet;
    }

    public static boolean isSetEffectEnabled(ArmorSet set) {
        if (set == null || !set.hasSetEffect || Config.setEffects == 1) {
            return false;
        }
        return setsWithEffects.get(set) != false || Config.setEffects == 0;
    }

    public static ArmorSet getSet(Block block, int meta) {
        for (ArmorSet set : allSets) {
            if (set.block != block || set.meta != meta) continue;
            return set;
        }
        return null;
    }

    public static ArmorSet getSet(Item item, int meta) {
        for (ArmorSet set : allSets) {
            if (set.item != item || set.meta != meta) continue;
            return set;
        }
        return null;
    }

    public static ArmorSet getSet(ItemBlockArmor item) {
        for (ArmorSet set : allSets) {
            if (set.helmet != item && set.chestplate != item && set.leggings != item && set.boots != item) continue;
            return set;
        }
        return null;
    }

    private static boolean isValid(ItemStack stack) {
        try {
            if (stack == null || !(stack.func_77973_b() instanceof ItemBlock) || stack.func_77973_b().getRegistryName().func_110623_a().contains("ore") || stack.func_82833_r().contains(".name") || stack.func_82833_r().contains("Ore") || stack.func_82833_r().contains("%")) {
                return false;
            }
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            if (block instanceof BlockLiquid || block instanceof BlockContainer || block.func_149716_u() || block instanceof BlockOre || block instanceof BlockCrops || block instanceof BlockBush || block == Blocks.field_180401_cv || block instanceof BlockLeaves || block == Blocks.field_150418_aU || block instanceof BlockSlab || block.func_149645_b(block.func_176223_P()) != EnumBlockRenderType.MODEL || block == Blocks.field_150339_S || block == Blocks.field_150340_R || block == Blocks.field_150484_ah) {
                return false;
            }
            String registryName = block.getRegistryName().toString();
            if (registryName.equalsIgnoreCase("evilcraft:darkBlock") || registryName.equalsIgnoreCase("evilcraft:obscuredGlass") || registryName.equalsIgnoreCase("evilcraft:hardenedBlood") || registryName.equalsIgnoreCase("evilcraft:darkPowerGemBlock") || registryName.equalsIgnoreCase("darkutils:filter") || registryName.equalsIgnoreCase("darkutils:filter_inverted") || registryName.equalsIgnoreCase("agriculturalrevolution:rustedanalyser") || registryName.equalsIgnoreCase("agriculturalrevolution:rustedbot") || registryName.equalsIgnoreCase("agriculturalrevolution:rustedmutationstation") || registryName.equalsIgnoreCase("agriculturalrevolution:rustedinscriber") || registryName.equalsIgnoreCase("agriculturalrevolution:rustedhydrophonic") || registryName.equalsIgnoreCase("agriculturalrevolution:rustedresearch") || registryName.equalsIgnoreCase("agriculturalrevolution:rustedpipe") || registryName.equalsIgnoreCase("agriculturalrevolution:rustedironscaff") || registryName.equalsIgnoreCase("tconstruct:clear_glass")) {
                return false;
            }
            ArrayList list = new ArrayList();
            try {
                block.func_185477_a(block.func_176223_P(), null, new BlockPos(0, 0, 0), Block.field_185505_j, list, null);
            }
            catch (Exception e) {
                return false;
            }
            return list.size() == 1 && ((AxisAlignedBB)list.get(0)).equals((Object)Block.field_185505_j);
        }
        catch (Exception e) {
            return false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int initTextures() {
        if (missingSprite == null) {
            missingSprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        int numTextures = 0;
        this.sprites = new TextureAtlasSprite[EntityEquipmentSlot.values().length];
        this.animations = new AnimationMetadataSection[EntityEquipmentSlot.values().length];
        this.frames = new float[EntityEquipmentSlot.values().length];
        this.colors = new int[EntityEquipmentSlot.values().length];
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = -1;
        }
        ArrayList list = new ArrayList();
        try {
            ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
            list.addAll(mesher.func_178089_a(this.stack).func_188616_a(null, null, 0L));
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                list.addAll(mesher.func_178089_a(this.stack).func_188616_a(null, facing, 0L));
            }
            for (BakedQuad quad : list) {
                int color;
                ResourceLocation loc1 = new ResourceLocation(quad.func_187508_a().func_94215_i());
                TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(loc1.toString());
                AnimationMetadataSection animation = (AnimationMetadataSection)(sprite.func_110970_k() > 1 ? ReflectionHelper.getPrivateValue(TextureAtlasSprite.class, (Object)sprite, (int)3) : null);
                int n = color = quad.func_178212_b() ? Minecraft.func_71410_x().getItemColors().func_186728_a(this.stack, quad.func_178211_c()) : -1;
                if (sprite.func_94215_i().contains("overlay")) continue;
                if (quad.func_178210_d() == EnumFacing.UP) {
                    if (sprite != missingSprite) {
                        ++numTextures;
                    }
                    this.sprites[EntityEquipmentSlot.HEAD.func_188454_b()] = sprite;
                    this.animations[EntityEquipmentSlot.HEAD.func_188454_b()] = animation;
                    this.colors[EntityEquipmentSlot.HEAD.func_188454_b()] = color;
                    continue;
                }
                if (quad.func_178210_d() == EnumFacing.NORTH) {
                    if (sprite != missingSprite) {
                        ++numTextures;
                    }
                    this.sprites[EntityEquipmentSlot.CHEST.func_188454_b()] = sprite;
                    this.animations[EntityEquipmentSlot.CHEST.func_188454_b()] = animation;
                    this.colors[EntityEquipmentSlot.CHEST.func_188454_b()] = color;
                    continue;
                }
                if (quad.func_178210_d() == EnumFacing.SOUTH) {
                    if (sprite != missingSprite) {
                        ++numTextures;
                    }
                    this.sprites[EntityEquipmentSlot.LEGS.func_188454_b()] = sprite;
                    this.animations[EntityEquipmentSlot.LEGS.func_188454_b()] = animation;
                    this.colors[EntityEquipmentSlot.LEGS.func_188454_b()] = color;
                    continue;
                }
                if (quad.func_178210_d() != EnumFacing.DOWN) continue;
                if (sprite != missingSprite) {
                    ++numTextures;
                }
                this.sprites[EntityEquipmentSlot.FEET.func_188454_b()] = sprite;
                this.animations[EntityEquipmentSlot.FEET.func_188454_b()] = animation;
                this.colors[EntityEquipmentSlot.FEET.func_188454_b()] = color;
            }
        }
        catch (Exception mesher) {
            // empty catch block
        }
        ResourceLocation texture = new ResourceLocation("blockarmor:textures/items/" + this.item.getRegistryName().func_110623_a().toLowerCase().replace(" ", "_") + ".png");
        try {
            TextureAtlasSprite sprite;
            Minecraft.func_71410_x().func_110442_L().func_110536_a(texture);
            texture = new ResourceLocation(texture.func_110624_b(), texture.func_110623_a().replace("textures/", "").replace(".png", ""));
            this.sprites[EntityEquipmentSlot.HEAD.func_188454_b()] = sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(texture.toString());
            this.animations[EntityEquipmentSlot.HEAD.func_188454_b()] = null;
            this.sprites[EntityEquipmentSlot.CHEST.func_188454_b()] = sprite;
            this.animations[EntityEquipmentSlot.CHEST.func_188454_b()] = null;
            this.sprites[EntityEquipmentSlot.LEGS.func_188454_b()] = sprite;
            this.animations[EntityEquipmentSlot.LEGS.func_188454_b()] = null;
            this.sprites[EntityEquipmentSlot.FEET.func_188454_b()] = sprite;
            this.animations[EntityEquipmentSlot.FEET.func_188454_b()] = null;
            BlockArmor.logger.debug("Override texture found at: " + texture.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.sprites[EntityEquipmentSlot.HEAD.func_188454_b()] == null || this.sprites[EntityEquipmentSlot.CHEST.func_188454_b()] == null || this.sprites[EntityEquipmentSlot.LEGS.func_188454_b()] == null || this.sprites[EntityEquipmentSlot.FEET.func_188454_b()] == null || this.sprites[EntityEquipmentSlot.HEAD.func_188454_b()] == missingSprite || this.sprites[EntityEquipmentSlot.CHEST.func_188454_b()] == missingSprite || this.sprites[EntityEquipmentSlot.LEGS.func_188454_b()] == missingSprite || this.sprites[EntityEquipmentSlot.FEET.func_188454_b()] == missingSprite) {
            disabledItems.add(new ItemStack((Item)this.helmet));
            disabledItems.add(new ItemStack((Item)this.chestplate));
            disabledItems.add(new ItemStack((Item)this.leggings));
            disabledItems.add(new ItemStack((Item)this.boots));
        }
        this.isTranslucent = this.block.func_180664_k() != BlockRenderLayer.SOLID && this.block != Blocks.field_150436_aH;
        return numTextures;
    }

    public static void disableItems() {
        if (disabledItems == null || disabledItems.isEmpty()) {
            return;
        }
        int numDisabled = 0;
        block0: for (ItemStack stack : disabledItems) {
            stack.func_77973_b().func_77637_a(null);
            if (BlockArmor.vanillaTab != null && BlockArmor.vanillaTab.orderedStacks != null) {
                for (ItemStack tabStack : BlockArmor.vanillaTab.orderedStacks) {
                    if (tabStack.func_77973_b() != stack.func_77973_b()) continue;
                    BlockArmor.vanillaTab.orderedStacks.remove(tabStack);
                    break;
                }
            }
            if (BlockArmor.moddedTab != null && BlockArmor.moddedTab.orderedStacks != null) {
                for (ItemStack tabStack : BlockArmor.moddedTab.orderedStacks) {
                    if (tabStack.func_77973_b() != stack.func_77973_b()) continue;
                    BlockArmor.moddedTab.orderedStacks.remove(tabStack);
                    break;
                }
            }
            List recipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe recipe : recipes) {
                if (recipe.func_77571_b() == null || recipe.func_77571_b().func_77973_b() != stack.func_77973_b()) continue;
                BlockArmor.logger.debug("Disabling item: " + stack.func_82833_r());
                recipes.remove(recipe);
                ++numDisabled;
                continue block0;
            }
        }
        if (numDisabled > 0) {
            BlockArmor.logger.info("Disabled " + numDisabled + " items that are missing textures");
        }
    }

    static {
        autoGeneratedSets = Maps.newHashMap();
        setsWithEffects = Maps.newHashMap();
        MANUALLY_ADDED_SETS = new ArrayList<ArmorSet>(){
            {
                this.add(new ArmorSet(new ItemStack(Blocks.field_150357_h, 1, 0), true));
                this.add(new ArmorSet(new ItemStack(Blocks.field_150451_bX, 1, 0), true));
                this.add(new ArmorSet(new ItemStack(Blocks.field_150368_y, 1, 0), true));
                this.add(new ArmorSet(new ItemStack(Blocks.field_150475_bE, 1, 0), true));
                this.add(new ArmorSet(new ItemStack(Blocks.field_150343_Z, 1, 0), true));
                this.add(new ArmorSet(new ItemStack(Blocks.field_150424_aL, 1, 0), true));
                this.add(new ArmorSet(new ItemStack(Blocks.field_150433_aE, 1, 0), true));
                this.add(new ArmorSet(new ItemStack(Blocks.field_150377_bs, 1, 0), true));
                this.add(new ArmorSet(new ItemStack(Blocks.field_180399_cE, 1, 0), true));
                this.add(new ArmorSet(new ItemStack(Items.field_151120_aE, 1, 0), true));
                this.add(new ArmorSet(new ItemStack(Blocks.field_180397_cI, 1, 2), true));
                this.add(new ArmorSet(new ItemStack(Blocks.field_150336_V, 1, 0), true));
                this.add(new ArmorSet(new ItemStack(Blocks.field_150371_ca, 1, 0), true));
                this.add(new ArmorSet(new ItemStack(Blocks.field_150420_aW, 1, 0), false));
                this.add(new ArmorSet(new ItemStack(Blocks.field_150419_aX, 1, 0), false));
                this.add(new ArmorSet(new ItemStack(Blocks.field_150462_ai, 1, 0), false));
            }
        };
        disabledItems = new ArrayList();
    }
}

