/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.item;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import twopiradians.blockArmor.common.BlockArmor;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.item.ItemBlockArmor;
import twopiradians.blockArmor.creativetab.BlockArmorCreativeTab;

public class ModItems {
    public static ArrayList<ItemBlockArmor> allArmors = new ArrayList();

    public static void postInit() {
        int vanillaItems = 0;
        int moddedItems = 0;
        for (ArmorSet set : ArmorSet.allSets) {
            if (!ArmorSet.autoGeneratedSets.containsKey(set) || ArmorSet.autoGeneratedSets.get(set).booleanValue()) {
                String registryName = ArmorSet.getItemStackRegistryName(set.stack);
                set.helmet = (ItemBlockArmor)ModItems.registerItem((Item)new ItemBlockArmor(set.material, 0, EntityEquipmentSlot.HEAD), registryName + "_helmet", true, set.isFromModdedBlock);
                set.chestplate = (ItemBlockArmor)ModItems.registerItem((Item)new ItemBlockArmor(set.material, 0, EntityEquipmentSlot.CHEST), registryName + "_chestplate", true, set.isFromModdedBlock);
                set.leggings = (ItemBlockArmor)ModItems.registerItem((Item)new ItemBlockArmor(set.material, 0, EntityEquipmentSlot.LEGS), registryName + "_leggings", true, set.isFromModdedBlock);
                set.boots = (ItemBlockArmor)ModItems.registerItem((Item)new ItemBlockArmor(set.material, 0, EntityEquipmentSlot.FEET), registryName + "_boots", true, set.isFromModdedBlock);
                if (set.isFromModdedBlock) {
                    moddedItems += 4;
                } else {
                    vanillaItems += 4;
                }
                BlockArmor.logger.debug("Generated armor for: " + set.stack.func_82833_r());
                continue;
            }
            BlockArmor.logger.debug("Armor generation disabled for: " + set.stack.func_82833_r());
        }
        BlockArmor.logger.info("Generated " + vanillaItems + " Block Armor items from Vanilla Blocks");
        if (moddedItems > 0) {
            BlockArmor.logger.info("Generated " + moddedItems + " Block Armor items from Modded Blocks");
        }
    }

    public static void registerRenders() {
        for (ItemBlockArmor item : allArmors) {
            ModItems.registerRender((Item)item);
        }
    }

    private static Item registerItem(Item item, String unlocalizedName, boolean addToTab, boolean isFromModdedBlock) {
        if (item instanceof ItemBlockArmor) {
            allArmors.add((ItemBlockArmor)item);
        }
        item.func_77655_b(unlocalizedName);
        item.setRegistryName("blockarmor", unlocalizedName);
        if (addToTab) {
            if (isFromModdedBlock) {
                if (BlockArmor.moddedTab == null) {
                    BlockArmor.moddedTab = new BlockArmorCreativeTab("tabBlockArmorModded");
                }
                BlockArmor.moddedTab.orderedStacks.add(new ItemStack(item));
                item.func_77637_a((CreativeTabs)BlockArmor.moddedTab);
            } else {
                if (BlockArmor.vanillaTab == null) {
                    BlockArmor.vanillaTab = new BlockArmorCreativeTab("tabBlockArmorVanilla");
                }
                BlockArmor.vanillaTab.orderedStacks.add(new ItemStack(item));
                item.func_77637_a((CreativeTabs)BlockArmor.vanillaTab);
            }
        }
        GameRegistry.register((IForgeRegistryEntry)item);
        return item;
    }

    private static void registerRender(Item item) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, 0, new ModelResourceLocation("blockarmor:" + item.func_77658_a().substring(5), "inventory"));
    }
}

