/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.packets;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import twopiradians.blockArmor.common.item.ArmorSet;

public class DisableItemsPacket
implements IMessage {
    protected ArrayList<ItemStack> itemsToDisable;

    public DisableItemsPacket() {
    }

    public DisableItemsPacket(ArrayList<ItemStack> itemsToDisable) {
        this.itemsToDisable = itemsToDisable;
    }

    public void fromBytes(ByteBuf buf) {
        int num = buf.readInt();
        this.itemsToDisable = new ArrayList();
        for (int i = 0; i < num; ++i) {
            this.itemsToDisable.add(ByteBufUtils.readItemStack((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.itemsToDisable.size());
        for (ItemStack stack : this.itemsToDisable) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
        }
    }

    public static class Handler
    implements IMessageHandler<DisableItemsPacket, IMessage> {
        public IMessage onMessage(final DisableItemsPacket packet, MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    if (ArmorSet.disabledItems == null || ArmorSet.disabledItems.isEmpty()) {
                        ArmorSet.disabledItems = packet.itemsToDisable;
                        ArmorSet.disableItems();
                    }
                }
            });
            return null;
        }
    }
}

