/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.client.gui.armorDisplay;

import com.google.common.collect.Multimap;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twopiradians.blockArmor.client.gui.armorDisplay.EntityGuiPlayer;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.item.ItemBlockArmor;

@SideOnly(value=Side.CLIENT)
public class GuiArmorDisplay
extends GuiScreen {
    private final ResourceLocation backgroundPageTextureWhite = new ResourceLocation("blockarmor:textures/gui/white.png");
    private final ResourceLocation backgroundPageTexture0 = new ResourceLocation("blockarmor:textures/gui/armor_display_background0.jpg");
    private final ResourceLocation backgroundPageTexture2 = new ResourceLocation("blockarmor:textures/gui/armor_display_background2.png");
    private EntityGuiPlayer guiPlayer;
    private float partialTicks;
    private ArrayList<ItemBlockArmor> armors;

    public GuiArmorDisplay() {
        this.guiPlayer = new EntityGuiPlayer((World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().field_71439_g.func_146103_bH(), (AbstractClientPlayer)Minecraft.func_71410_x().field_71439_g);
        this.armors = new ArrayList();
        for (ArmorSet set : ArmorSet.allSets) {
            if (!set.hasSetEffect) continue;
            boolean add = true;
            for (ItemStack stack : ArmorSet.disabledItems) {
                if (stack.func_77973_b() != set.helmet) continue;
                add = false;
            }
            if (!add) continue;
            this.armors.add(set.helmet);
            this.armors.add(set.chestplate);
            this.armors.add(set.leggings);
            this.armors.add(set.boots);
        }
        this.guiPlayer.func_82142_c(false);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.backgroundPageTextureWhite);
        GlStateManager.func_179094_E();
        float scale = 1.0f;
        this.func_73729_b(0, 0, 0, 0, this.field_146294_l, this.field_146295_m);
        GlStateManager.func_179121_F();
        this.partialTicks += 0.3f;
        for (int index = 0; index < this.armors.size(); index += 4) {
            ItemStack helmet = new ItemStack((Item)this.armors.get(index));
            ItemStack chestplate = new ItemStack((Item)this.armors.get(index + 1));
            ItemStack leggings = new ItemStack((Item)this.armors.get(index + 2));
            ItemStack boots = new ItemStack((Item)this.armors.get(index + 3));
            this.guiPlayer.func_184201_a(EntityEquipmentSlot.HEAD, helmet);
            this.guiPlayer.func_184201_a(EntityEquipmentSlot.CHEST, chestplate);
            this.guiPlayer.func_184201_a(EntityEquipmentSlot.LEGS, leggings);
            this.guiPlayer.func_184201_a(EntityEquipmentSlot.FEET, boots);
            helmet.func_77973_b().func_77663_a(helmet, this.guiPlayer.field_70170_p, (Entity)this.guiPlayer, EntityEquipmentSlot.HEAD.func_188454_b(), false);
            chestplate.func_77973_b().func_77663_a(chestplate, this.guiPlayer.field_70170_p, (Entity)this.guiPlayer, EntityEquipmentSlot.CHEST.func_188454_b(), false);
            leggings.func_77973_b().func_77663_a(leggings, this.guiPlayer.field_70170_p, (Entity)this.guiPlayer, EntityEquipmentSlot.LEGS.func_188454_b(), false);
            boots.func_77973_b().func_77663_a(boots, this.guiPlayer.field_70170_p, (Entity)this.guiPlayer, EntityEquipmentSlot.FEET.func_188454_b(), false);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            double spaceBetween = 0.0;
            scale = 50.0f;
            spaceBetween = 22.5;
            if (index / 4 < 7) {
                GlStateManager.func_179137_b((double)(-250.0 + (double)index * spaceBetween), (double)2.0, (double)0.0);
            } else {
                GlStateManager.func_179137_b((double)(-915.0 + (double)index * (spaceBetween + 2.0)), (double)179.0, (double)0.0);
            }
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderHelper.func_74519_b();
            GlStateManager.func_179114_b((float)-165.0f, (float)0.0f, (float)1.0f, (float)-0.0f);
            GlStateManager.func_179114_b((float)-10.0f, (float)-1.0f, (float)0.0f, (float)0.5f);
            this.guiPlayer.field_70759_as = 0.0f;
            this.guiPlayer.field_70761_aq = 0.0f;
            this.field_146297_k.func_175598_ae().func_178631_a(-20.0f);
            this.field_146297_k.func_175598_ae().func_188391_a((Entity)this.guiPlayer, -4.0, -1.5, 5.0, 0.0f, this.partialTicks, true);
            RenderHelper.func_74518_a();
            this.field_146297_k.field_71460_t.func_175072_h();
            GlStateManager.func_179121_F();
            ItemStack stack = new ItemStack((Item)this.armors.get(index));
            GlStateManager.func_179094_E();
            scale = 0.651f;
            if (index / 4 < 7) {
                GlStateManager.func_179137_b((double)(40.0 + (double)index * spaceBetween), (double)116.0, (double)0.0);
            } else {
                GlStateManager.func_179137_b((double)(-625.0 + (double)index * (spaceBetween + 2.0)), (double)293.0, (double)0.0);
            }
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            int length = 0;
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(TextFormatting.AQUA + "" + TextFormatting.UNDERLINE + stack.func_82833_r().replace("Helmet", "Armor"));
            this.armors.get(index).addFullSetEffectTooltip(tooltip);
            this.addStatTooltips(tooltip, new ItemStack[]{helmet, chestplate, leggings, boots});
            for (String string : tooltip) {
                if (this.field_146289_q.func_78256_a(string) <= length) continue;
                length = this.field_146289_q.func_78256_a(string);
            }
            this.func_146283_a(tooltip, -length / 2, 0);
            GlStateManager.func_179121_F();
            RenderHelper.func_74518_a();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private ArrayList<String> addStatTooltips(ArrayList<String> tooltip, ItemStack[] armor) {
        NBTTagList nbttaglist;
        ArrayList<Multimap> list = new ArrayList<Multimap>();
        list.add(armor[0].func_111283_C(EntityEquipmentSlot.HEAD));
        list.add(armor[1].func_111283_C(EntityEquipmentSlot.CHEST));
        list.add(armor[2].func_111283_C(EntityEquipmentSlot.LEGS));
        list.add(armor[3].func_111283_C(EntityEquipmentSlot.FEET));
        if (armor[3].func_77942_o() && (nbttaglist = armor[3].func_77986_q()) != null) {
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                short k = nbttaglist.func_150305_b(j).func_74765_d("id");
                short l = nbttaglist.func_150305_b(j).func_74765_d("lvl");
                if (Enchantment.func_185262_c((int)k) == null) continue;
                tooltip.add(ChatFormatting.GRAY + Enchantment.func_185262_c((int)k).func_77316_c((int)l));
            }
        }
        boolean flag = false;
        ArrayList<Double> finalD0s = new ArrayList<Double>();
        ArrayList<Double> finalD1s = new ArrayList<Double>();
        ArrayList<Map.Entry> entries = new ArrayList<Map.Entry>();
        for (Multimap multimap : list) {
            if (multimap.isEmpty()) continue;
            for (Map.Entry entry : multimap.entries()) {
                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                double d0 = attributemodifier.func_111164_d();
                flag = false;
                if (attributemodifier.func_111167_a() == ItemBlockArmor.ATTACK_STRENGTH_UUID) {
                    d0 += this.guiPlayer.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
                    d0 += (double)EnchantmentHelper.func_152377_a((ItemStack)armor[0], (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
                    flag = true;
                } else if (attributemodifier.func_111167_a() == ItemBlockArmor.ATTACK_SPEED_UUID) {
                    d0 += this.guiPlayer.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111125_b();
                    flag = true;
                }
                double d1 = attributemodifier.func_111169_c() != 1 && attributemodifier.func_111169_c() != 2 ? d0 : d0 * 100.0;
                boolean contains = false;
                int index2 = 0;
                for (int i = 0; i < entries.size(); ++i) {
                    if (((AttributeModifier)((Map.Entry)entries.get(i)).getValue()).func_111166_b() != attributemodifier.func_111166_b()) continue;
                    contains = true;
                    index2 = i;
                }
                if (!contains) {
                    entries.add(entry);
                    finalD0s.add(d0);
                    finalD1s.add(d1);
                    continue;
                }
                if (!((AttributeModifier)((Map.Entry)entries.get(index2)).getValue()).func_111166_b().equalsIgnoreCase("Armor toughness") && !((AttributeModifier)((Map.Entry)entries.get(index2)).getValue()).func_111166_b().equalsIgnoreCase("Armor modifier")) continue;
                finalD0s.set(index2, (Double)finalD0s.get(index2) + d0);
                finalD1s.set(index2, (Double)finalD1s.get(index2) + d1);
            }
        }
        for (int i = 0; i < entries.size(); ++i) {
            AttributeModifier attributemodifier = (AttributeModifier)((Map.Entry)entries.get(i)).getValue();
            if (flag) {
                tooltip.add(TextFormatting.BLUE + " +" + I18n.func_74837_a((String)("attribute.modifier.equals." + attributemodifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(finalD1s.get(i)), I18n.func_74838_a((String)("attribute.name." + (String)((Map.Entry)entries.get(i)).getKey()))}));
                continue;
            }
            if ((Double)finalD0s.get(i) > 0.0) {
                tooltip.add(TextFormatting.BLUE + " " + I18n.func_74837_a((String)("attribute.modifier.plus." + attributemodifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(finalD1s.get(i)), I18n.func_74838_a((String)("attribute.name." + (String)((Map.Entry)entries.get(i)).getKey()))}));
                continue;
            }
            if (!((Double)finalD0s.get(i) < 0.0)) continue;
            finalD1s.set(i, (Double)finalD1s.get(i) * -1.0);
            tooltip.add(TextFormatting.RED + " " + I18n.func_74837_a((String)("attribute.modifier.take." + attributemodifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(finalD1s.get(i)), I18n.func_74838_a((String)("attribute.name." + (String)((Map.Entry)entries.get(i)).getKey()))}));
        }
        return tooltip;
    }
}

