/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common;

import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;
import twopiradians.blockArmor.common.CommonProxy;
import twopiradians.blockArmor.common.block.ModBlocks;
import twopiradians.blockArmor.common.command.CommandDev;
import twopiradians.blockArmor.common.config.Config;
import twopiradians.blockArmor.common.events.IgniteTargetEvent;
import twopiradians.blockArmor.common.events.IncreaseFortuneEvent;
import twopiradians.blockArmor.common.events.StopFallDamageEvent;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.item.ItemBlockArmor;
import twopiradians.blockArmor.common.item.ModItems;
import twopiradians.blockArmor.common.tileentity.ModTileEntities;
import twopiradians.blockArmor.creativetab.BlockArmorCreativeTab;
import twopiradians.blockArmor.packets.DevColorsPacket;
import twopiradians.blockArmor.packets.DisableItemsPacket;

@Mod(modid="blockarmor", version="2.0.1", name="Block Armor", guiFactory="twopiradians.blockArmor.client.gui.config.BlockArmorGuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class BlockArmor {
    public static final String MODNAME = "Block Armor";
    public static final String MODID = "blockarmor";
    public static final String VERSION = "2.0.1";
    public static BlockArmorCreativeTab vanillaTab;
    public static BlockArmorCreativeTab moddedTab;
    @SidedProxy(clientSide="twopiradians.blockArmor.client.ClientProxy", serverSide="twopiradians.blockArmor.common.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static SimpleNetworkWrapper network;
    public static final boolean DISPLAY_ARMOR_GUI = false;
    public static final int GUI_MODE = 2;
    private File configFile;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.registerPackets();
        this.configFile = event.getSuggestedConfigurationFile();
        logger = event.getModLog();
        proxy.preInit();
        ModBlocks.preInit();
        ModTileEntities.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        this.registerEventListeners();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ArmorSet.postInit();
        Config.postInit(this.configFile);
        ModItems.postInit();
        this.registerRecipes();
        proxy.postInit();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandDev());
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        proxy.loadComplete(event);
    }

    private void registerRecipes() {
        for (ArmorSet set : ArmorSet.allSets) {
            ItemStack stack = set.block == Blocks.field_150475_bE ? new ItemStack(Items.field_151166_bC) : set.stack;
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)set.helmet), (Object[])new Object[]{"AAA", "A A", Character.valueOf('A'), stack});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)set.chestplate), (Object[])new Object[]{"A A", "AAA", "AAA", Character.valueOf('A'), stack});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)set.leggings), (Object[])new Object[]{"AAA", "A A", "A A", Character.valueOf('A'), stack});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)set.boots), (Object[])new Object[]{"A A", "A A", Character.valueOf('A'), stack});
        }
    }

    private void registerEventListeners() {
        MinecraftForge.EVENT_BUS.register((Object)new IncreaseFortuneEvent());
        MinecraftForge.EVENT_BUS.register((Object)new Config());
        MinecraftForge.EVENT_BUS.register((Object)new StopFallDamageEvent());
        MinecraftForge.EVENT_BUS.register((Object)new IgniteTargetEvent());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void registerPackets() {
        int id = 0;
        network.registerMessage(DisableItemsPacket.Handler.class, DisableItemsPacket.class, id++, Side.SERVER);
        network.registerMessage(DevColorsPacket.Handler.class, DevColorsPacket.class, id++, Side.CLIENT);
    }

    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            network.sendTo((IMessage)new DevColorsPacket(), (EntityPlayerMP)event.player);
        }
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            try {
                String block = mapping.name.replace("blockarmor:", "");
                String armor = block.substring(block.indexOf("_") + 1);
                block = block.substring(0, block.indexOf("_"));
                ArmorSet set = null;
                if (block.equalsIgnoreCase("sugarcane")) {
                    set = ArmorSet.getSet((Block)Blocks.field_150436_aH, 0);
                } else if (block.equalsIgnoreCase("stone")) {
                    set = ArmorSet.getSet(Blocks.field_150348_b, 0);
                } else if (block.equalsIgnoreCase("sprucewood")) {
                    set = ArmorSet.getSet(Blocks.field_150364_r, 1);
                } else if (block.equalsIgnoreCase("sprucewoodplanks")) {
                    set = ArmorSet.getSet(Blocks.field_150344_f, 1);
                } else if (block.equalsIgnoreCase("snow")) {
                    set = ArmorSet.getSet(Blocks.field_150433_aE, 0);
                } else if (block.equalsIgnoreCase("smoothgranite")) {
                    set = ArmorSet.getSet(Blocks.field_150348_b, 2);
                } else if (block.equalsIgnoreCase("smoothdiorite")) {
                    set = ArmorSet.getSet(Blocks.field_150348_b, 4);
                } else if (block.equalsIgnoreCase("smoothandesite")) {
                    set = ArmorSet.getSet(Blocks.field_150348_b, 6);
                } else if (block.equalsIgnoreCase("slime")) {
                    set = ArmorSet.getSet(Blocks.field_180399_cE, 0);
                } else if (block.equalsIgnoreCase("redstone")) {
                    set = ArmorSet.getSet(Blocks.field_150451_bX, 0);
                } else if (block.equalsIgnoreCase("quartz")) {
                    set = ArmorSet.getSet(Blocks.field_150371_ca, 0);
                } else if (block.equalsIgnoreCase("obsidian")) {
                    set = ArmorSet.getSet(Blocks.field_150343_Z, 0);
                } else if (block.equalsIgnoreCase("oakwood")) {
                    set = ArmorSet.getSet(Blocks.field_150364_r, 0);
                } else if (block.equalsIgnoreCase("oakwoodplanks")) {
                    set = ArmorSet.getSet(Blocks.field_150344_f, 0);
                } else if (block.equalsIgnoreCase("netherrack")) {
                    set = ArmorSet.getSet(Blocks.field_150424_aL, 0);
                } else if (block.equalsIgnoreCase("lapis")) {
                    set = ArmorSet.getSet(Blocks.field_150368_y, 0);
                } else if (block.equalsIgnoreCase("junglewood")) {
                    set = ArmorSet.getSet(Blocks.field_150364_r, 3);
                } else if (block.equalsIgnoreCase("junglewoodplanks")) {
                    set = ArmorSet.getSet(Blocks.field_150344_f, 3);
                } else if (block.equalsIgnoreCase("granite")) {
                    set = ArmorSet.getSet(Blocks.field_150348_b, 1);
                } else if (block.equalsIgnoreCase("endstone")) {
                    set = ArmorSet.getSet(Blocks.field_150377_bs, 0);
                } else if (block.equalsIgnoreCase("emerald")) {
                    set = ArmorSet.getSet(Blocks.field_150475_bE, 0);
                } else if (block.equalsIgnoreCase("dirt")) {
                    set = ArmorSet.getSet(Blocks.field_150346_d, 0);
                } else if (block.equalsIgnoreCase("diorite")) {
                    set = ArmorSet.getSet(Blocks.field_150348_b, 3);
                } else if (block.equalsIgnoreCase("darkprismarine")) {
                    set = ArmorSet.getSet(Blocks.field_180397_cI, 2);
                } else if (block.equalsIgnoreCase("darkoakwood")) {
                    set = ArmorSet.getSet(Blocks.field_150363_s, 1);
                } else if (block.equalsIgnoreCase("darkoakwoodplanks")) {
                    set = ArmorSet.getSet(Blocks.field_150344_f, 5);
                } else if (block.equalsIgnoreCase("cobble")) {
                    set = ArmorSet.getSet(Blocks.field_150347_e, 0);
                } else if (block.equalsIgnoreCase("brick")) {
                    set = ArmorSet.getSet(Blocks.field_150336_V, 0);
                } else if (block.equalsIgnoreCase("birchwood")) {
                    set = ArmorSet.getSet(Blocks.field_150364_r, 2);
                } else if (block.equalsIgnoreCase("birchwoodplanks")) {
                    set = ArmorSet.getSet(Blocks.field_150344_f, 2);
                } else if (block.equalsIgnoreCase("bedrock")) {
                    set = ArmorSet.getSet(Blocks.field_150357_h, 0);
                } else if (block.equalsIgnoreCase("andesite")) {
                    set = ArmorSet.getSet(Blocks.field_150348_b, 5);
                } else if (block.equalsIgnoreCase("acaciawood")) {
                    set = ArmorSet.getSet(Blocks.field_150363_s, 0);
                } else if (block.equalsIgnoreCase("acaciawoodplanks")) {
                    set = ArmorSet.getSet(Blocks.field_150344_f, 4);
                }
                ItemBlockArmor item = null;
                if (set != null) {
                    if (armor.equalsIgnoreCase("helmet")) {
                        item = set.helmet;
                    } else if (armor.equalsIgnoreCase("chestplate")) {
                        item = set.chestplate;
                    } else if (armor.equalsIgnoreCase("leggings")) {
                        item = set.leggings;
                    } else if (armor.equalsIgnoreCase("boots")) {
                        item = set.boots;
                    }
                }
                if (item != null) {
                    mapping.remap(item);
                    continue;
                }
                mapping.ignore();
            }
            catch (Exception exception) {}
        }
    }

    static {
        network = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
    }
}

