/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.config;

import java.io.File;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import twopiradians.blockArmor.common.item.ArmorSet;

public class Config {
    public static Configuration config;
    public static final String SET_EFFECTS_CATEGORY = "config.armorSetEffects";
    public static int setEffects;
    private static final ArrayList<String> setEffectsArray;
    public static final String AUTO_GEN_SETS_CATEGORY = "config.autoGeneratedArmorSets";
    public static int autoGenSets;
    private static final ArrayList<String> autoGenSetsArray;

    public static void postInit(File file) {
        config = new Configuration(file);
        config.load();
        Config.syncConfig();
        config.save();
    }

    public static void syncConfig() {
        ArrayList<String> list = new ArrayList<String>(config.getCategory(AUTO_GEN_SETS_CATEGORY).getPropertyOrder());
        list.remove("Auto-Generate Armor Sets");
        list.add(0, "Auto-Generate Armor Sets");
        config.getCategory(AUTO_GEN_SETS_CATEGORY).setPropertyOrder(list);
        config.getCategory(AUTO_GEN_SETS_CATEGORY).setComment("Choose if you want armor sets to be generated from other mods' blocks.");
        Property autoGenProp = config.get(AUTO_GEN_SETS_CATEGORY, "Auto-Generate Armor Sets", setEffectsArray.get(0), "Allows you to choose if you want armor sets to be generated from other mods' blocks.", autoGenSetsArray.toArray(new String[autoGenSetsArray.size()]));
        autoGenSets = autoGenSetsArray.indexOf(autoGenProp.getString());
        for (ArmorSet set : ArmorSet.autoGeneratedSets.keySet()) {
            String name = ArmorSet.getItemStackDisplayName(set.stack, null);
            Property prop = config.get(AUTO_GEN_SETS_CATEGORY, name + " Armor Set", true, "Determines whether or not the " + name + " Armor set should be generated.");
            if (autoGenSets == 0) {
                prop.set(true);
            } else if (autoGenSets == 1) {
                prop.set(false);
            }
            ArmorSet.autoGeneratedSets.put(set, prop.getBoolean());
            if (!prop.getBoolean()) {
                ArmorSet.allSets.remove(set);
                ArmorSet.disabledItems.remove(set);
                ArmorSet.setsWithEffects.remove(set);
            }
            prop.setRequiresMcRestart(true);
        }
        list = new ArrayList(config.getCategory(SET_EFFECTS_CATEGORY).getPropertyOrder());
        list.remove("Armor Set Effects");
        list.add(0, "Armor Set Effects");
        config.getCategory(SET_EFFECTS_CATEGORY).setPropertyOrder(list);
        config.getCategory(SET_EFFECTS_CATEGORY).setComment("Choose which armor set effects you want enabled.");
        Property setEffectsProp = config.get(SET_EFFECTS_CATEGORY, "Armor Set Effects", setEffectsArray.get(0), "Allows you to choose which armor set effects you want enabled.", setEffectsArray.toArray(new String[setEffectsArray.size()]));
        setEffects = setEffectsArray.indexOf(setEffectsProp.getString());
        for (ArmorSet set : ArmorSet.setsWithEffects.keySet()) {
            String name = ArmorSet.getItemStackDisplayName(set.stack, null);
            Property prop = config.get(SET_EFFECTS_CATEGORY, name + " Armor Effects", true, "Determines whether or not the " + name + " Armor set effect can be used.");
            if (setEffects == 0) {
                prop.set(true);
            } else if (setEffects == 1) {
                prop.set(false);
            }
            ArmorSet.setsWithEffects.put(set, prop.getBoolean());
        }
        config.save();
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("blockarmor")) {
            Config.syncConfig();
        }
    }

    static {
        setEffectsArray = new ArrayList<String>(){
            {
                this.add("Enabled");
                this.add("Disabled");
                this.add("Custom");
            }
        };
        autoGenSetsArray = new ArrayList<String>(){
            {
                this.add("Enabled");
                this.add("Disabled");
                this.add("Custom");
            }
        };
    }
}

