/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.item;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twopiradians.blockArmor.client.model.ModelBlockArmor;
import twopiradians.blockArmor.common.BlockArmor;
import twopiradians.blockArmor.common.block.ModBlocks;
import twopiradians.blockArmor.common.command.CommandDev;
import twopiradians.blockArmor.common.item.ArmorSet;

public class ItemBlockArmor
extends ItemArmor {
    public static final UUID MOVEMENT_SPEED_UUID = UUID.fromString("308e48ee-a300-4846-9b56-05e53e35eb8f");
    public static final UUID ATTACK_SPEED_UUID = UUID.fromString("3094e67f-88f1-4d81-a59d-655d4e7e8065");
    public static final UUID ATTACK_STRENGTH_UUID = UUID.fromString("d7dfa4ea-1cdf-4dd9-8842-883d7448cb00");
    public static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("c8bb1118-78be-4864-9de3-a718047d28bd");
    public static final UUID MAX_HEALTH_UUID = UUID.fromString("0fefa40c-fd5a-4019-a25e-7fffc8dcf621");
    public static final UUID LUCK_UUID = UUID.fromString("537fd0e2-78ef-4dd3-affb-959ff059b1bd");
    private static final String TEXT_FORMATTING_SET_EFFECT_HEADER = TextFormatting.ITALIC + "" + TextFormatting.GOLD;
    private static final String TEXT_FORMATTING_SET_EFFECT_DESCRIPTION = TextFormatting.WHITE + "";
    private static final String TEXT_FORMATTING_SET_EFFECT_EXTRA = TextFormatting.GREEN + "";

    public ItemBlockArmor(ItemArmor.ArmorMaterial material, int renderIndex, EntityEquipmentSlot equipmentSlot) {
        super(material, renderIndex, equipmentSlot);
        this.func_77637_a(null);
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        TextureAtlasSprite sprite = ArmorSet.getSprite(this);
        String texture = sprite.func_94215_i() + ".png";
        int index = texture.indexOf(":");
        texture = texture.substring(0, index + 1) + "textures/" + texture.substring(index + 1);
        return texture;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entity, ItemStack stack, EntityEquipmentSlot slot, ModelBiped oldModel) {
        TextureAtlasSprite sprite = ArmorSet.getSprite(this);
        int width = sprite.func_94211_a();
        int height = sprite.func_94216_b() * sprite.func_110970_k();
        boolean isTranslucent = ArmorSet.getSet((ItemBlockArmor)this).isTranslucent;
        int currentFrame = ArmorSet.getCurrentAnimationFrame(this);
        int nextFrame = ArmorSet.getNextAnimationFrame(this);
        int color = ArmorSet.getColor(this);
        float alpha = ArmorSet.getAlpha(this);
        ModelBlockArmor model = (ModelBlockArmor)((Object)BlockArmor.proxy.getBlockArmorModel(height, width, currentFrame, nextFrame, slot));
        model.translucent = isTranslucent;
        model.color = color;
        model.alpha = alpha;
        return model;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        if (ArmorSet.disabledItems != null) {
            for (ItemStack stack : ArmorSet.disabledItems) {
                if (stack.func_77973_b() != itemIn) continue;
                return;
            }
        }
        subItems.add(new ItemStack(itemIn));
    }

    public String func_77653_i(ItemStack stack) {
        return ArmorSet.getItemStackDisplayName(stack, this.field_77881_a);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap map = this.func_111205_h(slot);
        if (slot != this.field_77881_a) {
            return map;
        }
        ArmorSet set = ArmorSet.getSet(this);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (stack.func_77978_p().func_74767_n("isWearing")) {
            if (set.block == Blocks.field_150436_aH) {
                map.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(MOVEMENT_SPEED_UUID, "Speed Boost", 0.1, 0));
            } else if (set.block == Blocks.field_150357_h) {
                map.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Knockback Resistance", 2.0, 0));
                map.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(MAX_HEALTH_UUID, "Health Boost", 20.0, 0));
            } else if (set.block == Blocks.field_150343_Z) {
                map.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Knockback Resistance", 2.0, 0));
                map.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(MAX_HEALTH_UUID, "Health Boost", 10.0, 0));
            } else if (set.block == Blocks.field_150336_V) {
                map.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Knockback Resistance", 0.5, 0));
                map.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(MAX_HEALTH_UUID, "Health Boost", 4.0, 0));
            } else if (set.block == Blocks.field_150371_ca) {
                map.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(ATTACK_SPEED_UUID, "Attack Speed Boost", 1.0, 0));
                map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(ATTACK_STRENGTH_UUID, "Attack Strength Boost", 3.0, 0));
            } else if (set.block == Blocks.field_150475_bE) {
                map.put((Object)SharedMonsterAttributes.field_188792_h.func_111108_a(), (Object)new AttributeModifier(LUCK_UUID, "Knockback Resistance", 1.0, 0));
            }
        } else if (set.block == Blocks.field_150436_aH) {
            map.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(MOVEMENT_SPEED_UUID, "Speed Boost", 0.0, 0));
        } else if (set.block == Blocks.field_150357_h) {
            map.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Knockback Resistance", 0.0, 0));
            map.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(MAX_HEALTH_UUID, "Health Boost", 0.0, 0));
        } else if (set.block == Blocks.field_150343_Z) {
            map.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Knockback Resistance", 0.0, 0));
            map.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(MAX_HEALTH_UUID, "Health Boost", 0.0, 0));
        } else if (set.block == Blocks.field_150336_V) {
            map.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Knockback Resistance", 0.0, 0));
            map.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(MAX_HEALTH_UUID, "Health Boost", 0.0, 0));
        } else if (set.block == Blocks.field_150371_ca) {
            map.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(ATTACK_SPEED_UUID, "Knockback Resistance", 0.0, 0));
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(ATTACK_STRENGTH_UUID, "Health Boost", 0.0, 0));
        } else if (set.block == Blocks.field_150475_bE) {
            map.put((Object)SharedMonsterAttributes.field_188792_h.func_111108_a(), (Object)new AttributeModifier(LUCK_UUID, "Knockback Resistance", 0.0, 0));
        }
        return map;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        if (stack.func_77948_v()) {
            return EnumRarity.RARE;
        }
        if (ArmorSet.getSet((ItemBlockArmor)this).hasSetEffect) {
            return EnumRarity.UNCOMMON;
        }
        return EnumRarity.COMMON;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        ArmorSet set = ArmorSet.getSet(this);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("devSpawned")) {
            tooltip.add(TextFormatting.DARK_PURPLE + "" + TextFormatting.BOLD + "Dev Spawned");
        }
        if (GuiScreen.func_146272_n()) {
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_EXTRA + "Generated from: " + set.stack.func_82833_r());
        }
        if (set.hasSetEffect) {
            tooltip = this.addFullSetEffectTooltip(tooltip);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> addFullSetEffectTooltip(List<String> tooltip) {
        ArmorSet set = ArmorSet.getSet(this);
        if (!set.hasSetEffect) {
            return tooltip;
        }
        tooltip.add(TEXT_FORMATTING_SET_EFFECT_HEADER + "Full Set Effect:");
        if (!ArmorSet.isSetEffectEnabled(set)) {
            tooltip.add(TextFormatting.RED + "Disabled.");
            if (GuiScreen.func_146272_n()) {
                tooltip.add(TextFormatting.RED + "SP: Disabled in your config.");
                tooltip.add(TextFormatting.RED + "MP: Disabled in server config.");
            }
        } else if (set.block == Blocks.field_150377_bs) {
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Teleports in the direction");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "you're looking upon sneaking!");
            if (GuiScreen.func_146272_n()) {
                tooltip.add(TEXT_FORMATTING_SET_EFFECT_EXTRA + "Now you see me. Now you *poof*");
            }
        } else if (set.block == Blocks.field_180399_cE) {
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Bounces off walls!");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Bounces off the ground!");
            if (GuiScreen.func_146272_n()) {
                tooltip.add(TEXT_FORMATTING_SET_EFFECT_EXTRA + "Bouncy, trouncy, flouncy, pouncy,");
                tooltip.add(TEXT_FORMATTING_SET_EFFECT_EXTRA + "fun, fun, fun, fun, fun!");
            }
        } else if (set.block == Blocks.field_150436_aH) {
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Increases movement speed!");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Can breathe near");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "the water surface.");
            if (GuiScreen.func_146272_n()) {
                tooltip.add(TEXT_FORMATTING_SET_EFFECT_EXTRA + "Just like snorkeling!");
            }
        } else if (set.block == Blocks.field_180397_cI) {
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Sinks faster in liquids!");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Respiration, night vision,");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "and depth strider in water!");
        } else if (set.block == Blocks.field_150475_bE) {
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Increases fortune level!");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Increases luck.");
            if (GuiScreen.func_146272_n()) {
                tooltip.add(TEXT_FORMATTING_SET_EFFECT_EXTRA + "More Goodies!");
            }
        } else if (set.block == Blocks.field_150357_h) {
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Knockback resistance.");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Greatly increases");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "max health.");
        } else if (set.block == Blocks.field_150371_ca) {
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Increases attack strength!");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Increases attack speed!");
        } else if (set.block == Blocks.field_150336_V) {
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Minor knockback resistance.");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Increases max health.");
        } else if (set.block == Blocks.field_150424_aL) {
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Gives Fire Protection.");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Creates light");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "while sneaking.");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Lights target on fire");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "after attacking.");
        } else if (set.block == Blocks.field_150343_Z) {
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Gives Fire Protection.");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Knockback resistance.");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Increases max health.");
        } else if (set.block == Blocks.field_150451_bX) {
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Creates light while sneaking.");
        } else if (set.block == Blocks.field_150433_aE) {
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Spawns snow and snowballs");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "while sneaking!");
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Gives Frost Walking 2.");
            if (GuiScreen.func_146272_n()) {
                tooltip.add(TEXT_FORMATTING_SET_EFFECT_EXTRA + "Do you wanna build a snowman?");
            }
        } else if (set.block == Blocks.field_150368_y) {
            tooltip.add(TEXT_FORMATTING_SET_EFFECT_DESCRIPTION + "Gives xp for wearing!");
        }
        return tooltip;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!(entityIn instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)entityIn;
        ArmorSet set = ArmorSet.getSet(this);
        if (ArmorSet.isSetEffectEnabled(set)) {
            this.doEnchantments(stack, entity);
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!entityIn.field_70170_p.field_72995_K && entityIn instanceof EntityPlayer && stack.func_77978_p().func_74764_b("devSpawned") && !CommandDev.DEVS.contains(entityIn.getPersistentID()) && ((EntityPlayer)entityIn).field_71071_by.func_70301_a(itemSlot) == stack) {
            ((EntityPlayer)entityIn).field_71071_by.func_70299_a(itemSlot, new ItemStack(Blocks.field_150350_a));
            return;
        }
        if (!ArmorSet.isWearingFullSet(entity, set) || !ArmorSet.isSetEffectEnabled(set)) {
            stack.func_77978_p().func_74757_a("isWearing", false);
            return;
        }
        stack.func_77978_p().func_74757_a("isWearing", true);
        int cooldown = stack.func_77978_p().func_74764_b("cooldown") ? stack.func_77978_p().func_74762_e("cooldown") : 0;
        stack.func_77978_p().func_74768_a("cooldown", --cooldown);
        if (worldIn instanceof WorldServer) {
            ((WorldServer)worldIn).func_73039_n().func_72788_a();
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (!entityItem.field_70170_p.field_72995_K && entityItem != null && entityItem.func_92059_d() != null && entityItem.func_92059_d().func_77942_o() && entityItem.func_92059_d().func_77978_p().func_74764_b("devSpawned")) {
            entityItem.func_70106_y();
            return true;
        }
        return false;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!world.field_72995_K && itemStack != null && itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("devSpawned") && !CommandDev.DEVS.contains(player.getPersistentID()) && player.func_184582_a(this.func_185083_B_()) == itemStack) {
            player.func_184201_a(this.func_185083_B_(), new ItemStack(Blocks.field_150350_a));
            return;
        }
        ArmorSet set = ArmorSet.getSet(this);
        if (!ArmorSet.isSetEffectEnabled(set) || !ArmorSet.isWearingFullSet((EntityLivingBase)player, set)) {
            return;
        }
        if (set.block == Blocks.field_180397_cI && player.func_70090_H() && world.func_180495_p(new BlockPos(player.field_70165_t, player.field_70163_u + 1.7, player.field_70161_v)).func_177230_c() instanceof BlockLiquid) {
            if (!player.func_70644_a(Potion.func_188412_a((int)16)) || player.func_70644_a(Potion.func_188412_a((int)16)) && player.func_70660_b(Potion.func_188412_a((int)16)).func_76459_b() < 205) {
                player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)16), 210, 0, false, false));
            }
            try {
                if (world.field_72995_K && !((EntityPlayerSP)player).field_71158_b.field_78901_c && !player.field_70122_E && world.func_180495_p(new BlockPos(player.field_70165_t, player.field_70163_u + 2.0, player.field_70161_v)).func_177230_c() instanceof BlockLiquid && player.field_70181_x < 0.0) {
                    player.field_70181_x = Math.max(-0.3, player.field_70181_x * 1.2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.field_77881_a != EntityEquipmentSlot.FEET) {
            return;
        }
        if (set.block == Blocks.field_150424_aL) {
            int radius = 3;
            if (player.func_70093_af() && !player.func_70090_H()) {
                if (!world.field_72995_K && player.field_70173_aa % 2 == 0) {
                    ((WorldServer)world).func_175739_a(EnumParticleTypes.LAVA, player.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * (double)radius, player.field_70163_u + world.field_73012_v.nextDouble() + 1.0, player.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * (double)radius, 1, 0.0, 0.0, 0.0, 0.0, new int[0]);
                }
                if (world.field_73012_v.nextInt(20) == 0) {
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187616_bj, player.func_184176_by(), 0.5f, world.field_73012_v.nextFloat());
                }
                if (world.func_180495_p(new BlockPos(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v)) != ModBlocks.movinglightsource.func_176223_P() && world.func_180495_p(new BlockPos(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v)) == Blocks.field_150350_a.func_176223_P() && !world.field_72995_K) {
                    world.func_175656_a(new BlockPos(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v), ModBlocks.movinglightsource.func_176223_P());
                }
            }
        }
        if (set.block == Blocks.field_150451_bX && player.func_70093_af() && world.func_180495_p(new BlockPos(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v)) != ModBlocks.movinglightsource.func_176223_P() && world.func_180495_p(new BlockPos(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v)) == Blocks.field_150350_a.func_176223_P()) {
            world.func_175656_a(new BlockPos(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v), ModBlocks.movinglightsource.func_176223_P());
        }
        if (player.func_70093_af() && set.block == Blocks.field_150433_aE) {
            int radius = 3;
            if (!world.field_72995_K && player.field_70173_aa % 2 == 0) {
                ((WorldServer)world).func_175739_a(EnumParticleTypes.SNOW_SHOVEL, player.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * (double)radius, player.field_70163_u + world.field_73012_v.nextDouble() + 1.0, player.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * (double)radius, 1, 0.0, 0.0, 0.0, 0.0, new int[0]);
            }
            if (world.field_73012_v.nextInt(5) == 0) {
                world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187918_gr, player.func_184176_by(), 1.0f, world.field_73012_v.nextFloat());
            }
            if (!world.field_72995_K) {
                for (int x = -radius / 2; x <= radius / 2; ++x) {
                    for (int z = -radius / 2; z <= radius / 2; ++z) {
                        for (int y = 0; y <= 2; ++y) {
                            if (!player.field_71075_bZ.field_75099_e || world.field_73012_v.nextInt(100) != 0 || !world.func_175623_d(new BlockPos(player.field_70165_t + (double)x, player.field_70163_u + (double)y, player.field_70161_v + (double)z))) continue;
                            if (world.func_180495_p(new BlockPos(player.field_70165_t + (double)x, player.field_70163_u + (double)y - 1.0, player.field_70161_v + (double)z)).func_177230_c().func_176214_u()) {
                                world.func_175656_a(new BlockPos(player.field_70165_t + (double)x, player.field_70163_u + (double)y, player.field_70161_v + (double)z), Blocks.field_150431_aC.func_176223_P());
                                continue;
                            }
                            if (world.func_180495_p(new BlockPos(player.field_70165_t + (double)x, player.field_70163_u + (double)y - 1.0, player.field_70161_v + (double)z)).func_177230_c() == Blocks.field_150355_j) {
                                world.func_175656_a(new BlockPos(player.field_70165_t + (double)x, player.field_70163_u + (double)y - 1.0, player.field_70161_v + (double)z), Blocks.field_185778_de.func_176223_P());
                                continue;
                            }
                            if (world.func_180495_p(new BlockPos(player.field_70165_t + (double)x, player.field_70163_u + (double)y - 1.0, player.field_70161_v + (double)z)).func_177230_c() != Blocks.field_185778_de) continue;
                            world.func_175656_a(new BlockPos(player.field_70165_t + (double)x, player.field_70163_u + (double)y - 1.0, player.field_70161_v + (double)z), Blocks.field_185778_de.func_176223_P());
                        }
                    }
                }
                if (world.field_73012_v.nextInt(100) == 0) {
                    EntityItem item = new EntityItem(world, player.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * (double)radius, player.field_70163_u + world.field_73012_v.nextDouble() + 1.5, player.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * (double)radius, new ItemStack(Items.field_151126_ay));
                    item.func_174867_a(40);
                    world.func_72838_d((Entity)item);
                    world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187815_fJ, player.func_184176_by(), 1.0f, world.field_73012_v.nextFloat());
                }
            }
        }
        if (!world.field_72995_K && set.block == Blocks.field_150368_y && itemStack.func_77978_p().func_74762_e("cooldown") <= 0) {
            itemStack.func_77978_p().func_74768_a("cooldown", 50);
            player.func_71023_q(1);
        }
        if (!world.field_72995_K && set.block == Blocks.field_150377_bs && itemStack.func_77978_p().func_74762_e("cooldown") <= 0 && player.func_70093_af() && !player.field_71075_bZ.field_75100_b) {
            itemStack.func_77978_p().func_74768_a("cooldown", 50);
            int distance = player.func_70681_au().nextInt(10) + 16;
            double rotX = -Math.sin((double)player.field_70177_z * Math.PI / 180.0);
            double rotY = -Math.sin((double)player.field_70125_A * Math.PI / 180.0);
            double rotZ = Math.cos((double)player.field_70177_z * Math.PI / 180.0);
            double viewVectorLength = Math.sqrt(Math.pow(rotX, 2.0) + Math.pow(rotY, 2.0) + Math.pow(rotZ, 2.0));
            double x = player.field_70165_t + (double)distance / viewVectorLength * rotX;
            double y = player.field_70163_u + (double)distance / viewVectorLength * rotY;
            double z = player.field_70161_v + (double)distance / viewVectorLength * rotZ;
            BlockPos pos = new BlockPos(x, y, z);
            boolean posFound = false;
            for (int i = 0; i < 128; ++i) {
                double newX = 8.0 * (world.field_73012_v.nextDouble() - 0.5);
                double newY = 8.0 * (world.field_73012_v.nextDouble() - 0.5);
                double newZ = 8.0 * (world.field_73012_v.nextDouble() - 0.5);
                if (posFound || !player.field_70170_p.func_175623_d(pos.func_177963_a(newX, newY, newZ)) || !player.field_70170_p.func_175623_d(pos.func_177963_a(newX, newY + 1.0, newZ)) || player.field_70170_p.func_175623_d(pos.func_177963_a(newX, newY - 1.0, newZ)) || player.field_70170_p.func_180495_p(pos.func_177963_a(newX, newY - 1.0, newZ)).func_177230_c() instanceof BlockLiquid) continue;
                pos = pos.func_177963_a(newX, newY, newZ);
                posFound = true;
                break;
            }
            if (posFound && player.func_184595_k((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5)) {
                if (player.func_184218_aH()) {
                    player.func_184210_p();
                }
                world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
                world.func_184148_a((EntityPlayer)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
                player.func_184185_a(SoundEvents.field_187544_ad, 1.0f, 1.0f);
                for (int j = 0; j < 64; ++j) {
                    ((WorldServer)world).func_175739_a(EnumParticleTypes.PORTAL, player.field_70165_t + 2.0 * world.field_73012_v.nextDouble(), player.field_70163_u + world.field_73012_v.nextDouble() + 1.0, player.field_70161_v + 2.0 * world.field_73012_v.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0, new int[0]);
                    ((WorldServer)world).func_175739_a(EnumParticleTypes.PORTAL, player.field_70165_t + 2.0 * world.field_73012_v.nextDouble(), player.field_70163_u + world.field_73012_v.nextDouble() + 1.0, player.field_70161_v + 2.0 * world.field_73012_v.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0, new int[0]);
                }
            } else {
                world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187679_dF, SoundCategory.PLAYERS, 1.0f, world.field_73012_v.nextFloat() + 0.5f);
            }
        }
        if (!player.func_70093_af() && set.block == Blocks.field_180399_cE && world.field_72995_K && itemStack.func_77978_p().func_74762_e("cooldown") <= 0 && player.field_70123_F && Math.sqrt(Math.pow(player.field_70165_t - player.field_71091_bM, 2.0) + Math.pow(player.field_70161_v - player.field_71097_bO, 2.0)) >= 0.9) {
            itemStack.func_77978_p().func_74768_a("cooldown", 10);
            if (player.field_70159_w == 0.0) {
                player.field_70159_w = -(player.field_70165_t - player.field_71091_bM) * 1.5;
                player.field_70179_y = (player.field_70161_v - player.field_71097_bO) * 1.5;
            } else if (player.field_70179_y == 0.0) {
                player.field_70159_w = (player.field_70165_t - player.field_71091_bM) * 1.5;
                player.field_70179_y = -(player.field_70161_v - player.field_71097_bO) * 1.5;
            }
            player.field_70181_x += 0.1;
            world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187876_fn, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if (!world.field_72995_K && set.block == Blocks.field_150436_aH && player.func_70090_H() && player.field_70173_aa % 10 == 0 && world.func_180495_p(new BlockPos(player.field_70165_t, player.field_70163_u + 3.0, player.field_70161_v)).func_177230_c() == Blocks.field_150350_a) {
            player.func_70050_g(300);
        }
    }

    private void doEnchantments(ItemStack stack, EntityLivingBase entity) {
        NBTTagCompound stackCompound;
        boolean wasEnchanted;
        Enchantment e;
        NBTTagCompound compound;
        int i;
        boolean wasEnchanted2;
        short lvl;
        short id;
        short targetId;
        NBTTagList list;
        ArmorSet set = ArmorSet.getSet(this);
        if (set.block == Blocks.field_180397_cI && this.field_77881_a == EntityEquipmentSlot.FEET) {
            list = stack.func_77986_q();
            targetId = 8;
            id = 0;
            lvl = 0;
            wasEnchanted2 = false;
            if (list != null) {
                for (i = 0; i < list.func_74745_c(); ++i) {
                    compound = list.func_150305_b(i);
                    id = compound.func_74765_d("id");
                    lvl = compound.func_74765_d("lvl");
                    if (id != 8 || lvl < 2) continue;
                    wasEnchanted2 = true;
                }
            }
            if (entity instanceof EntityLivingBase && ArmorSet.isWearingFullSet(entity, set) && entity.func_184582_a(EntityEquipmentSlot.FEET) == stack && entity.func_70090_H() && !wasEnchanted2) {
                stack.func_77966_a(Enchantments.field_185300_i, 2);
            } else if (!(!stack.func_77948_v() || entity.func_70090_H() && ArmorSet.isWearingFullSet(entity, set) && entity.func_184582_a(EntityEquipmentSlot.FEET) == stack || list == null)) {
                for (i = 0; i < list.func_74745_c(); ++i) {
                    compound = list.func_150305_b(i);
                    id = compound.func_74765_d("id");
                    lvl = compound.func_74765_d("lvl");
                    e = Enchantment.func_185262_c((int)id);
                    if (e == null || id != targetId) continue;
                    NBTTagCompound stackCompound2 = stack.func_77978_p();
                    if (stackCompound2 == null) {
                        return;
                    }
                    if (lvl <= 2) {
                        list.func_74744_a(i);
                    }
                    if (list.func_74745_c() <= 0) {
                        stackCompound2.func_82580_o("ench");
                    }
                    return;
                }
            }
        }
        if (set.block == Blocks.field_180397_cI && this.field_77881_a == EntityEquipmentSlot.HEAD) {
            list = stack.func_77986_q();
            targetId = 5;
            id = 0;
            lvl = 0;
            wasEnchanted2 = false;
            if (list != null) {
                for (i = 0; i < list.func_74745_c(); ++i) {
                    compound = list.func_150305_b(i);
                    id = compound.func_74765_d("id");
                    lvl = compound.func_74765_d("lvl");
                    if (id != 5 || lvl != 3) continue;
                    wasEnchanted2 = true;
                }
            }
            if (entity instanceof EntityLivingBase && ArmorSet.isWearingFullSet(entity, set) && entity.func_184582_a(EntityEquipmentSlot.HEAD) == stack && entity.field_70170_p.func_180495_p(new BlockPos(entity.field_70165_t, entity.field_70163_u + 1.7, entity.field_70161_v)).func_177230_c() instanceof BlockLiquid && !wasEnchanted2) {
                stack.func_77966_a(Enchantments.field_185298_f, 3);
            } else if (!(!stack.func_77948_v() || entity.field_70170_p.func_180495_p(new BlockPos(entity.field_70165_t, entity.field_70163_u + 1.7, entity.field_70161_v)).func_177230_c() instanceof BlockLiquid && ArmorSet.isWearingFullSet(entity, set) || list == null)) {
                for (i = 0; i < list.func_74745_c(); ++i) {
                    compound = list.func_150305_b(i);
                    id = compound.func_74765_d("id");
                    lvl = compound.func_74765_d("lvl");
                    e = Enchantment.func_185262_c((int)id);
                    if (e == null || id != targetId) continue;
                    NBTTagCompound stackCompound3 = stack.func_77978_p();
                    if (stackCompound3 == null) {
                        return;
                    }
                    list.func_74744_a(i);
                    if (list.func_74745_c() <= 0) {
                        stackCompound3.func_82580_o("ench");
                    }
                    return;
                }
            }
        }
        if (set.block == Blocks.field_150433_aE && this.field_77881_a == EntityEquipmentSlot.FEET) {
            list = stack.func_77986_q();
            targetId = 9;
            id = 0;
            wasEnchanted = false;
            if (list != null) {
                for (int i2 = 0; i2 < list.func_74745_c(); ++i2) {
                    NBTTagCompound compound2 = list.func_150305_b(i2);
                    id = compound2.func_74765_d("id");
                    if (id != 9) continue;
                    wasEnchanted = true;
                }
            }
            if (entity instanceof EntityLivingBase && ArmorSet.isWearingFullSet(entity, set) && entity.func_184582_a(EntityEquipmentSlot.FEET) == stack && !wasEnchanted) {
                stack.func_77966_a(Enchantments.field_185301_j, 2);
            } else if (stack.func_77948_v() && !ArmorSet.isWearingFullSet(entity, set) && list != null) {
                for (int i3 = 0; i3 < list.func_74745_c(); ++i3) {
                    NBTTagCompound compound3 = list.func_150305_b(i3);
                    id = compound3.func_74765_d("id");
                    Enchantment e2 = Enchantment.func_185262_c((int)id);
                    if (e2 == null || id != targetId) continue;
                    stackCompound = stack.func_77978_p();
                    if (stackCompound == null) {
                        return;
                    }
                    list.func_74744_a(i3);
                    if (list.func_74745_c() <= 0) {
                        stackCompound.func_82580_o("ench");
                    }
                    return;
                }
            }
        }
        if (set.block == Blocks.field_150424_aL || set.block == Blocks.field_150343_Z) {
            list = stack.func_77986_q();
            targetId = 1;
            id = 0;
            wasEnchanted = false;
            if (list != null) {
                for (int i4 = 0; i4 < list.func_74745_c(); ++i4) {
                    NBTTagCompound compound4 = list.func_150305_b(i4);
                    id = compound4.func_74765_d("id");
                    if (id != targetId) continue;
                    wasEnchanted = true;
                }
            }
            if (entity instanceof EntityLivingBase && ArmorSet.isWearingFullSet(entity, set) && entity.func_184582_a(EntityEquipmentSlot.FEET) == stack && !wasEnchanted) {
                stack.func_77966_a(Enchantments.field_77329_d, 4);
            } else if (stack.func_77948_v() && !ArmorSet.isWearingFullSet(entity, set) && list != null) {
                for (int i5 = 0; i5 < list.func_74745_c(); ++i5) {
                    NBTTagCompound compound5 = list.func_150305_b(i5);
                    id = compound5.func_74765_d("id");
                    Enchantment e3 = Enchantment.func_185262_c((int)id);
                    if (e3 == null || id != targetId) continue;
                    stackCompound = stack.func_77978_p();
                    if (stackCompound == null) {
                        return;
                    }
                    list.func_74744_a(i5);
                    if (list.func_74745_c() <= 0) {
                        stackCompound.func_82580_o("ench");
                    }
                    return;
                }
            }
        }
    }
}

