/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.leveling;

import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public enum Ability {
    FIRE(TextFormatting.RED, 0xFF5555, 1, 1.5),
    FROST(TextFormatting.AQUA, 0x55FFFF, 1, 1.5),
    POISON(TextFormatting.DARK_GREEN, 43520, 1, 1.5),
    LIGHT(TextFormatting.YELLOW, 0xFFFF55, 2, 1.5),
    BLOODLUST(TextFormatting.DARK_RED, 0xAA0000, 2, 1.5),
    ETHEREAL(TextFormatting.GREEN, 0x55FF55, 2, 2.0),
    CHAINED(TextFormatting.GRAY, 0xAAAAAA, 3, 1.5),
    VOID(TextFormatting.DARK_GRAY, 0x555555, 3, 1.0);

    public static final int WEAPON_ABILITIES = 8;
    private String color;
    private int hex;
    private int tier;
    private double multiplier;

    private Ability(Object color, int hex, int tier, double multiplier) {
        this.color = color.toString();
        this.hex = hex;
        this.tier = tier;
        this.multiplier = multiplier;
    }

    public boolean hasAbility(NBTTagCompound nbt) {
        return nbt != null && nbt.func_74767_n(this.toString());
    }

    public void addAbility(NBTTagCompound nbt, int level) {
        nbt.func_74757_a(this.toString(), true);
        this.setLevel(nbt, level);
    }

    public void removeAbility(NBTTagCompound nbt) {
        nbt.func_82580_o(this.toString());
        nbt.func_82580_o(this.toString() + "_level");
    }

    public void setLevel(NBTTagCompound nbt, int level) {
        if (level <= 2) {
            nbt.func_74768_a(this.toString() + "_level", level);
        }
    }

    public int getLevel(NBTTagCompound nbt) {
        if (nbt != null) {
            return nbt.func_74762_e(this.toString() + "_level");
        }
        return 0;
    }

    public double getMultiplier(int level) {
        if (level == 1) {
            return 1.0;
        }
        if (level == 2) {
            return this.multiplier;
        }
        if (level == 3) {
            return this.multiplier + this.multiplier / 2.0;
        }
        return 1.0;
    }

    public int getTier() {
        return this.tier;
    }

    public String getColor() {
        return this.color;
    }

    public int getHex() {
        return this.hex;
    }

    public String getName() {
        return I18n.func_135052_a((String)("levels.ability." + this.ordinal()), (Object[])new Object[0]);
    }
}

