/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.leveling;

import com.thexfactor117.levels.util.RandomCollection;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public enum Rarity {
    DEFAULT("", 0, 0.0),
    COMMON(TextFormatting.GRAY, 0xAAAAAA, 0.5),
    UNCOMMON(TextFormatting.DARK_GREEN, 43520, 0.25),
    RARE(TextFormatting.AQUA, 0x55FFFF, 0.13),
    ULTRA_RARE(TextFormatting.DARK_PURPLE, 0xAA00AA, 0.07),
    LEGENDARY(TextFormatting.GOLD, 0xFFAA00, 0.035),
    ARCHAIC(TextFormatting.WHITE, 0xFFFFFF, 0.015);

    private String color;
    private int hex;
    private double weight;
    private static final Rarity[] RARITIES;
    private static final RandomCollection<Rarity> RANDOM_RARITIES;

    private Rarity(Object color, int hex, double weight) {
        this.color = color.toString();
        this.hex = hex;
        this.weight = weight;
    }

    public static Rarity getRandomRarity(Random random) {
        return RANDOM_RARITIES.next(random);
    }

    public static Rarity getRarity(NBTTagCompound nbt) {
        return nbt != null && nbt.func_74764_b("RARITY") ? RARITIES[nbt.func_74762_e("RARITY")] : DEFAULT;
    }

    public void setRarity(NBTTagCompound nbt) {
        if (nbt != null) {
            nbt.func_74768_a("RARITY", this.ordinal());
        }
    }

    public static void setRarity(NBTTagCompound nbt, String rarityName) {
        int rarity = Integer.parseInt(rarityName);
        nbt.func_74768_a("RARITY", rarity);
    }

    public String getName() {
        return I18n.func_135052_a((String)("levels.rarity." + this.ordinal()), (Object[])new Object[0]);
    }

    public String getColor() {
        return this.color;
    }

    public int getHex() {
        return this.hex;
    }

    static {
        RARITIES = Rarity.values();
        RANDOM_RARITIES = new RandomCollection();
        for (Rarity rarity : RARITIES) {
            if (!(rarity.weight > 0.0)) continue;
            RANDOM_RARITIES.add(rarity.weight, rarity);
        }
    }
}

