/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.event;

import com.thexfactor117.levels.leveling.Ability;
import com.thexfactor117.levels.leveling.Experience;
import com.thexfactor117.levels.leveling.Rarity;
import com.thexfactor117.levels.util.ConfigHandler;
import com.thexfactor117.levels.util.NBTHelper;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class EventItemTooltip {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void addInformation(ItemTooltipEvent event) {
        NBTTagCompound nbt;
        ArrayList tooltip = (ArrayList)event.getToolTip();
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (item != null && (item instanceof ItemSword || item instanceof ItemAxe) && (nbt = NBTHelper.loadStackNBT(stack)) != null && Experience.isEnabled(nbt)) {
            Rarity rarity = Rarity.getRarity(nbt);
            int level = Experience.getLevel(nbt);
            int experience = Experience.getExperience(nbt);
            int maxExperience = Experience.getMaxLevelExp(level);
            tooltip.add("");
            tooltip.add(rarity.getColor() + "===============");
            tooltip.add("");
            tooltip.add(rarity.getColor() + TextFormatting.ITALIC + I18n.func_135052_a((String)("levels.rarity." + rarity.ordinal()), (Object[])new Object[0]));
            if (level >= ConfigHandler.MAX_LEVEL) {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"levels.misc.max", (Object[])new Object[0]));
            } else {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"levels.misc.level", (Object[])new Object[0]) + ": " + level);
            }
            if (level >= ConfigHandler.MAX_LEVEL) {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"levels.misc.max", (Object[])new Object[0]));
            } else {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"levels.misc.experience", (Object[])new Object[0]) + ": " + experience + " / " + maxExperience);
            }
            if (ConfigHandler.SHOW_DURABILITY) {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"levels.misc.durability", (Object[])new Object[0]) + ": " + (stack.func_77958_k() - stack.func_77952_i()) + " / " + stack.func_77958_k());
            }
            tooltip.add("");
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                tooltip.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"levels.misc.abilities", (Object[])new Object[0]));
                tooltip.add("");
                for (Ability ability : Ability.values()) {
                    if (!ability.hasAbility(nbt)) continue;
                    tooltip.add(ability.getColor() + I18n.func_135052_a((String)("levels.ability." + ability.ordinal()), (Object[])new Object[0]));
                }
            } else {
                tooltip.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"levels.misc.abilities.shift", (Object[])new Object[0]));
            }
            tooltip.add("");
            tooltip.add(rarity.getColor() + "===============");
            tooltip.add("");
        }
    }
}

