/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.event.hurt;

import com.thexfactor117.levels.leveling.Ability;
import com.thexfactor117.levels.leveling.Experience;
import com.thexfactor117.levels.leveling.Rarity;
import com.thexfactor117.levels.util.ConfigHandler;
import com.thexfactor117.levels.util.NBTHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventLivingHurtMelee {
    @SubscribeEvent
    public void onHurt(LivingHurtEvent event) {
        if (event.getSource().func_76364_f() instanceof EntityPlayer && !(event.getSource().func_76364_f() instanceof FakePlayer)) {
            NBTTagCompound nbt;
            EntityPlayer player = (EntityPlayer)event.getSource().func_76364_f();
            EntityLivingBase enemy = event.getEntityLiving();
            ItemStack stack = player.field_71071_by.func_70448_g();
            if (stack != null && (stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemAxe) && (nbt = NBTHelper.loadStackNBT(stack)) != null) {
                this.updateExperience(nbt);
                this.useRarity(event, stack, nbt);
                this.useAbilities(event, player, enemy, nbt);
                this.updateLevel(player, stack, nbt);
            }
        }
    }

    private void updateExperience(NBTTagCompound nbt) {
        if (Experience.getLevel(nbt) < ConfigHandler.MAX_LEVEL) {
            boolean isDev = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
            if (isDev) {
                Experience.setExperience(nbt, Experience.getExperience(nbt) + 10);
            } else {
                Experience.setExperience(nbt, Experience.getExperience(nbt) + 1);
            }
        }
    }

    private void useRarity(LivingHurtEvent event, ItemStack stack, NBTTagCompound nbt) {
        Rarity rarity = Rarity.getRarity(nbt);
        float damageMultiplier = 1.0f;
        if (rarity != Rarity.DEFAULT) {
            switch (rarity) {
                case UNCOMMON: {
                    int var = (int)(Math.random() * 20.0);
                    int var1 = (int)(Math.random() * 20.0);
                    int var2 = (int)(Math.random() * 1.0);
                    if (var == 0) {
                        damageMultiplier = 1.25f;
                    }
                    if (var1 == 0) {
                        Experience.setExperience(nbt, Experience.getExperience(nbt) + var2);
                    }
                    int var3 = (int)(Math.random() * 20.0);
                    int var4 = (int)(Math.random() * 1.0);
                    if (var3 != 0) break;
                    stack.func_77964_b(stack.func_77952_i() - var4);
                    break;
                }
                case RARE: {
                    int var = (int)(Math.random() * 13.0);
                    int var1 = (int)(Math.random() * 13.0);
                    int var2 = (int)(Math.random() * 2.0);
                    if (var == 0) {
                        damageMultiplier = 1.5f;
                    }
                    if (var1 == 0) {
                        Experience.setExperience(nbt, Experience.getExperience(nbt) + var2);
                    }
                    int var3 = (int)(Math.random() * 13.0);
                    int var4 = (int)(Math.random() * 2.0);
                    if (var3 != 0) break;
                    stack.func_77964_b(stack.func_77952_i() - var4);
                    break;
                }
                case ULTRA_RARE: {
                    int var = (int)(Math.random() * 10.0);
                    int var1 = (int)(Math.random() * 10.0);
                    int var2 = (int)(Math.random() * 3.0);
                    if (var == 0) {
                        damageMultiplier = 2.0f;
                    }
                    if (var1 == 0) {
                        Experience.setExperience(nbt, Experience.getExperience(nbt) + var2);
                    }
                    int var3 = (int)(Math.random() * 10.0);
                    int var4 = (int)(Math.random() * 3.0);
                    if (var3 != 0) break;
                    stack.func_77964_b(stack.func_77952_i() - var4);
                    break;
                }
                case LEGENDARY: {
                    int var = (int)(Math.random() * 7.0);
                    int var1 = (int)(Math.random() * 7.0);
                    int var2 = (int)(Math.random() * 5.0);
                    if (var == 0) {
                        damageMultiplier = 2.5f;
                    }
                    if (var1 == 0) {
                        Experience.setExperience(nbt, Experience.getExperience(nbt) + var2);
                    }
                    int var3 = (int)(Math.random() * 7.0);
                    int var4 = (int)(Math.random() * 5.0);
                    if (var3 != 0) break;
                    stack.func_77964_b(stack.func_77952_i() - var4);
                    break;
                }
                case ARCHAIC: {
                    int var = (int)(Math.random() * 5.0);
                    int var1 = (int)(Math.random() * 5.0);
                    int var2 = (int)(Math.random() * 10.0);
                    if (var == 0) {
                        damageMultiplier = 3.0f;
                    }
                    if (var1 == 0) {
                        Experience.setExperience(nbt, Experience.getExperience(nbt) + var2);
                    }
                    int var3 = (int)(Math.random() * 5.0);
                    int var4 = (int)(Math.random() * 10.0);
                    if (var3 != 0) break;
                    stack.func_77964_b(stack.func_77952_i() - var4);
                    break;
                }
            }
            event.setAmount(event.getAmount() * damageMultiplier);
        }
    }

    private void useAbilities(LivingHurtEvent event, EntityPlayer player, EntityLivingBase enemy, NBTTagCompound nbt) {
        if (enemy != null) {
            double multiplier;
            if (Ability.FIRE.hasAbility(nbt) && (int)(Math.random() * 4.0) == 0) {
                multiplier = Ability.FIRE.getMultiplier(Ability.FIRE.getLevel(nbt));
                enemy.func_70015_d((int)(4.0 * multiplier));
            }
            if (Ability.FROST.hasAbility(nbt) && (int)(Math.random() * 4.0) == 0) {
                multiplier = Ability.FROST.getMultiplier(Ability.FROST.getLevel(nbt));
                enemy.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(20.0 * (2.0 * multiplier)), 10));
            }
            if (Ability.POISON.hasAbility(nbt) && (int)(Math.random() * 4.0) == 0) {
                multiplier = Ability.POISON.getMultiplier(Ability.POISON.getLevel(nbt));
                enemy.func_70690_d(new PotionEffect(MobEffects.field_76436_u, (int)(20.0 * (7.0 * multiplier)), Ability.POISON.getLevel(nbt)));
            }
            if (Ability.LIGHT.hasAbility(nbt) && (int)(Math.random() * 7.0) == 0) {
                multiplier = Ability.LIGHT.getMultiplier(Ability.LIGHT.getLevel(nbt));
                enemy.func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)(20.0 * (4.0 * multiplier)), Ability.LIGHT.getLevel(nbt)));
                enemy.func_70690_d(new PotionEffect(MobEffects.field_76440_q, (int)(20.0 * (4.0 * multiplier)), Ability.LIGHT.getLevel(nbt)));
            }
            if (Ability.BLOODLUST.hasAbility(nbt) && (int)(Math.random() * 7.0) == 0) {
                multiplier = Ability.BLOODLUST.getMultiplier(Ability.BLOODLUST.getLevel(nbt));
                enemy.func_70690_d(new PotionEffect(MobEffects.field_82731_v, (int)(20.0 * (4.0 * multiplier)), Ability.BLOODLUST.getLevel(nbt)));
            }
            if (Ability.ETHEREAL.hasAbility(nbt) && (int)(Math.random() * 7.0) == 0) {
                multiplier = Ability.ETHEREAL.getMultiplier(Ability.ETHEREAL.getLevel(nbt));
                float health = (float)((double)player.func_110143_aJ() + (double)event.getAmount() / (4.0 / multiplier));
                player.func_70606_j(health);
            }
            if (Ability.CHAINED.hasAbility(nbt) && (int)(Math.random() * 10.0) == 0) {
                multiplier = Ability.CHAINED.getMultiplier(Ability.CHAINED.getLevel(nbt));
                double radius = 10.0 * multiplier;
                World world = enemy.func_130014_f_();
                List entityList = world.func_72872_a(EntityMob.class, new AxisAlignedBB(player.field_70165_t - radius, player.field_70163_u - radius, player.field_70161_v - radius, player.field_70165_t + radius, player.field_70163_u + radius, player.field_70161_v + radius));
                for (Entity entity : entityList) {
                    if (!(entity instanceof EntityLivingBase)) continue;
                    entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), event.getAmount());
                }
            }
            if (Ability.VOID.hasAbility(nbt) && (int)(Math.random() * 20.0) == 0) {
                float multiplier2 = 0.0f;
                if (Ability.VOID.getLevel(nbt) == 1) {
                    multiplier2 = 0.4f;
                } else if (Ability.VOID.getLevel(nbt) == 2) {
                    multiplier2 = 0.6f;
                } else if (Ability.VOID.getLevel(nbt) == 3) {
                    multiplier2 = 0.8f;
                }
                float damage = enemy.func_110138_aP() * multiplier2;
                event.setAmount(damage);
            }
        }
    }

    private void updateLevel(EntityPlayer player, ItemStack stack, NBTTagCompound nbt) {
        int level = Experience.getNextLevel(player, stack, nbt, Experience.getLevel(nbt), Experience.getExperience(nbt));
        Experience.setLevel(nbt, level);
        NBTHelper.saveStackNBT(stack, nbt);
    }
}

