/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.gui;

import com.thexfactor117.levels.Levels;
import com.thexfactor117.levels.leveling.Ability;
import com.thexfactor117.levels.leveling.Experience;
import com.thexfactor117.levels.leveling.Rarity;
import com.thexfactor117.levels.network.PacketGuiAbility;
import com.thexfactor117.levels.util.ConfigHandler;
import com.thexfactor117.levels.util.NBTHelper;
import java.io.IOException;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiAbilitySelection
extends GuiScreen {
    private GuiButton[] weaponAbilities = new GuiButton[8];

    @SideOnly(value=Side.CLIENT)
    public void func_73866_w_() {
        NBTTagCompound nbt;
        ItemStack stack;
        EntityPlayerSP player = this.field_146297_k.field_71439_g;
        if (player != null && (stack = player.field_71071_by.func_70448_g()) != null && stack.func_77973_b() instanceof ItemSword && (nbt = stack.func_77978_p()) != null) {
            int i;
            for (i = 0; i < this.weaponAbilities.length / 2; ++i) {
                this.weaponAbilities[i] = new GuiButton(i, this.field_146294_l / 2 - 200, 100 + i * 20, 75, 20, Ability.values()[i].getName());
                this.field_146292_n.add(this.weaponAbilities[i]);
                this.weaponAbilities[i].field_146124_l = false;
            }
            for (i = this.weaponAbilities.length / 2; i < this.weaponAbilities.length; ++i) {
                this.weaponAbilities[i] = new GuiButton(i, this.field_146294_l / 2 - 100, 20 + i * 20, 75, 20, Ability.values()[i].getName());
                this.field_146292_n.add(this.weaponAbilities[i]);
                this.weaponAbilities[i].field_146124_l = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        NBTTagCompound nbt;
        ItemStack stack;
        this.func_146276_q_();
        EntityPlayerSP player = this.field_146297_k.field_71439_g;
        if (player != null && (stack = player.field_71071_by.func_70448_g()) != null && stack.func_77973_b() instanceof ItemSword && (nbt = NBTHelper.loadStackNBT(stack)) != null) {
            this.drawStrings(stack, nbt);
            this.displayButtons(nbt);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @SideOnly(value=Side.CLIENT)
    protected void func_146284_a(GuiButton button) throws IOException {
        NBTTagCompound nbt;
        ItemStack stack;
        EntityPlayerSP player = this.field_146297_k.field_71439_g;
        if (player != null && (stack = player.field_71071_by.func_70448_g()) != null && (nbt = NBTHelper.loadStackNBT(stack)) != null && Experience.getAbilityTokens(nbt) > 0) {
            for (int i = 0; i < this.weaponAbilities.length; ++i) {
                if (button != this.weaponAbilities[i]) continue;
                Levels.network.sendToServer((IMessage)new PacketGuiAbility(i));
            }
        }
    }

    private void drawStrings(ItemStack stack, NBTTagCompound nbt) {
        Rarity rarity = Rarity.getRarity(nbt);
        this.func_73732_a(this.field_146289_q, stack.func_82833_r(), this.field_146294_l / 2, 20, rarity.getHex());
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"levels.misc.rarity", (Object[])new Object[0]) + ": " + rarity.getName(), this.field_146294_l / 2 - 50, 40, rarity.getHex());
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"levels.misc.level", (Object[])new Object[0]) + ": " + Experience.getLevel(nbt), this.field_146294_l / 2 - 50, 50, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"levels.misc.experience", (Object[])new Object[0]) + ": " + Experience.getExperience(nbt) + " / " + Experience.getMaxLevelExp(Experience.getLevel(nbt)), this.field_146294_l / 2 - 50, 60, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"levels.misc.abilities", (Object[])new Object[0]), this.field_146294_l / 2, 80, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"levels.misc.abilities.tokens", (Object[])new Object[0]) + ": " + Experience.getAbilityTokens(nbt), this.field_146294_l / 2 - 112, 190, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"levels.misc.abilities.purchased", (Object[])new Object[0]), this.field_146294_l / 2 + 112, 100, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"levels.misc.abilities.active", (Object[])new Object[0]), this.field_146294_l / 2 + 75, 120, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"levels.misc.abilities.passive", (Object[])new Object[0]), this.field_146294_l / 2 + 150, 120, 0xFFFFFF);
        int j = -1;
        for (int i = 0; i < Ability.values().length; ++i) {
            if (!Ability.values()[i].hasAbility(nbt)) continue;
            this.func_73732_a(this.field_146289_q, Ability.values()[i].getName(), this.field_146294_l / 2 + 150, 135 + ++j * 10, Ability.values()[i].getHex());
        }
    }

    private void displayButtons(NBTTagCompound nbt) {
        block9: {
            block8: {
                int i;
                if (Experience.getAbilityTokens(nbt) <= 0) break block8;
                int j = 0;
                for (i = 0; i < this.weaponAbilities.length; ++i) {
                    if (Ability.values()[i].getTier() == 1) {
                        this.weaponAbilities[i].field_146124_l = true;
                    } else if ((double)Experience.getLevel(nbt) > (double)ConfigHandler.MAX_LEVEL * 0.5 && Ability.values()[i].getTier() <= 2) {
                        this.weaponAbilities[i].field_146124_l = true;
                    } else if ((double)Experience.getLevel(nbt) > (double)ConfigHandler.MAX_LEVEL * 0.6666666666666666) {
                        this.weaponAbilities[i].field_146124_l = true;
                    }
                    if (!Ability.values()[i].hasAbility(nbt)) continue;
                    ++j;
                    this.weaponAbilities[i].field_146124_l = false;
                }
                if (j != 3) break block9;
                for (i = 0; i < this.weaponAbilities.length; ++i) {
                    this.weaponAbilities[i].field_146124_l = false;
                }
                break block9;
            }
            for (int i = 0; i < this.weaponAbilities.length; ++i) {
                this.weaponAbilities[i].field_146124_l = false;
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

