/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launcher.updater.VersionList;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Rule;
import net.minecraft.launcher.versions.Version;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import net.minecraft.launcher.versions.json.LowerCaseEnumTypeAdapterFactory;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.util.OS;
import ru.turikhay.util.U;

public class CompleteVersion
implements Version,
Cloneable {
    String id;
    String jar;
    String inheritsFrom;
    Date time;
    Date releaseTime;
    ReleaseType type;
    String jvmArguments;
    String minecraftArguments;
    String mainClass;
    Integer minimumLauncherVersion = 0;
    Integer tlauncherVersion = 0;
    String assets;
    Repository source;
    VersionList list;
    List<Library> libraries;
    List<Rule> rules;
    List<String> deleteEntries;

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("ID is NULL or empty");
        }
        this.id = id;
    }

    @Override
    public ReleaseType getReleaseType() {
        return this.type;
    }

    @Override
    public Repository getSource() {
        return this.source;
    }

    @Override
    public void setSource(Repository repository) {
        if (repository == null) {
            throw new NullPointerException();
        }
        this.source = repository;
    }

    @Override
    public Date getUpdatedTime() {
        return this.time;
    }

    public void setUpdatedTime(Date time) {
        if (time == null) {
            throw new NullPointerException("Time is NULL!");
        }
        this.time = time;
    }

    @Override
    public Date getReleaseTime() {
        return this.releaseTime;
    }

    @Override
    public VersionList getVersionList() {
        return this.list;
    }

    @Override
    public void setVersionList(VersionList list) {
        if (list == null) {
            throw new NullPointerException("VersionList cannot be NULL!");
        }
        this.list = list;
    }

    @Override
    public String getJar() {
        return this.jar;
    }

    public String getInheritsFrom() {
        return this.inheritsFrom;
    }

    public String getJVMArguments() {
        return this.jvmArguments;
    }

    public String getMinecraftArguments() {
        return this.minecraftArguments;
    }

    public void setMinecraftArguments(String args) {
        this.minecraftArguments = args;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String clazz) {
        this.mainClass = clazz;
    }

    public List<Library> getLibraries() {
        return this.libraries;
    }

    public List<Rule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public List<String> getDeleteEntries() {
        return this.deleteEntries;
    }

    public int getMinimumLauncherVersion() {
        return this.minimumLauncherVersion;
    }

    public int getMinimumCustomLauncherVersion() {
        return this.tlauncherVersion;
    }

    public String getAssets() {
        return this.assets == null ? "legacy" : this.assets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.hashCode() == o.hashCode()) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version compare = (Version)o;
        return compare.getID() == null ? false : compare.getID().equals(this.id);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id='" + this.id + "', time=" + this.time + ", release=" + this.releaseTime + ", type=" + (Object)((Object)this.type) + ", class=" + this.mainClass + ", minimumVersion=" + this.minimumLauncherVersion + ", assets='" + this.assets + "', source=" + (Object)((Object)this.source) + ", list=" + this.list + ", libraries=" + this.libraries + "}";
    }

    public File getFile(File base) {
        return new File(base, "versions/" + this.getID() + "/" + this.getID() + ".jar");
    }

    public boolean appliesToCurrentEnvironment() {
        Rule rule;
        Rule.Action action;
        if (this.rules == null) {
            return true;
        }
        Iterator<Rule> i$ = this.rules.iterator();
        do {
            if (i$.hasNext()) continue;
            return true;
        } while ((action = (rule = i$.next()).getAppliedAction()) != Rule.Action.DISALLOW);
        return false;
    }

    public Collection<Library> getRelevantLibraries() {
        ArrayList<Library> result = new ArrayList<Library>();
        for (Library library : this.libraries) {
            if (!library.appliesToCurrentEnvironment()) continue;
            result.add(library);
        }
        return result;
    }

    public Collection<File> getClassPath(OS os, File base) {
        Collection<Library> libraries = this.getRelevantLibraries();
        ArrayList<File> result = new ArrayList<File>();
        for (Library library : libraries) {
            if (library.getNatives() != null) continue;
            result.add(new File(base, "libraries/" + library.getArtifactPath()));
        }
        result.add(new File(base, "versions/" + this.getID() + "/" + this.getID() + ".jar"));
        return result;
    }

    public Collection<File> getClassPath(File base) {
        return this.getClassPath(OS.CURRENT, base);
    }

    public Collection<String> getNatives(OS os) {
        Collection<Library> libraries = this.getRelevantLibraries();
        ArrayList<String> result = new ArrayList<String>();
        for (Library library : libraries) {
            Map<OS, String> natives = library.getNatives();
            if (natives == null || !natives.containsKey((Object)os)) continue;
            result.add("libraries/" + library.getArtifactPath(natives.get((Object)os)));
        }
        return result;
    }

    public Collection<String> getNatives() {
        return this.getNatives(OS.CURRENT);
    }

    public Set<String> getRequiredFiles(OS os) {
        HashSet<String> neededFiles = new HashSet<String>();
        for (Library library : this.getRelevantLibraries()) {
            if (library.getNatives() != null) {
                String natives = library.getNatives().get((Object)os);
                if (natives == null) continue;
                neededFiles.add("libraries/" + library.getArtifactPath(natives));
                continue;
            }
            neededFiles.add("libraries/" + library.getArtifactPath());
        }
        return neededFiles;
    }

    public Collection<String> getExtractFiles(OS os) {
        Collection<Library> libraries = this.getRelevantLibraries();
        ArrayList<String> result = new ArrayList<String>();
        for (Library library : libraries) {
            Map<OS, String> natives = library.getNatives();
            if (natives == null || !natives.containsKey((Object)os)) continue;
            result.add("libraries/" + library.getArtifactPath(natives.get((Object)os)));
        }
        return result;
    }

    public CompleteVersion resolve(VersionManager vm) throws IOException {
        return this.resolve(vm, false);
    }

    public CompleteVersion resolve(VersionManager vm, boolean useLatest) throws IOException {
        return this.resolve(vm, useLatest, new ArrayList<String>());
    }

    protected CompleteVersion resolve(VersionManager vm, boolean useLatest, List<String> inheristance) throws IOException {
        CompleteVersion result;
        if (vm == null) {
            throw new NullPointerException("version manager");
        }
        if (this.inheritsFrom == null) {
            return this;
        }
        this.log("Resolving...");
        if (inheristance.contains(this.id)) {
            throw new IllegalArgumentException(this.id + " should be already resolved.");
        }
        inheristance.add(this.id);
        this.log("Inherits from", this.inheritsFrom);
        VersionSyncInfo parentSyncInfo = vm.getVersionSyncInfo(this.inheritsFrom);
        try {
            if (parentSyncInfo == null) {
                return null;
            }
            result = (CompleteVersion)parentSyncInfo.getCompleteVersion(useLatest).resolve(vm, useLatest, inheristance).clone();
        }
        catch (CloneNotSupportedException var7) {
            throw new RuntimeException(var7);
        }
        return this.copyInto(result);
    }

    public CompleteVersion copyInto(CompleteVersion result) {
        ArrayList<Library> rulesCopy;
        result.id = this.id;
        if (this.jar != null) {
            result.jar = this.jar;
        }
        result.inheritsFrom = null;
        if (this.time.getTime() != 0L) {
            result.time = this.time;
        }
        if (this.type != ReleaseType.UNKNOWN) {
            result.type = this.type;
        }
        if (this.jvmArguments != null) {
            result.jvmArguments = this.jvmArguments;
        }
        if (this.minecraftArguments != null) {
            result.minecraftArguments = this.minecraftArguments;
        }
        if (this.mainClass != null) {
            result.mainClass = this.mainClass;
        }
        if (this.libraries != null) {
            rulesCopy = new ArrayList<Library>();
            rulesCopy.addAll(this.libraries);
            if (result.libraries != null) {
                rulesCopy.addAll(result.libraries);
            }
            result.libraries = rulesCopy;
        }
        if (this.rules != null) {
            if (result.rules != null) {
                result.rules.addAll(this.rules);
            } else {
                rulesCopy = new ArrayList(this.rules.size());
                Collections.copy(rulesCopy, this.rules);
                result.rules = this.rules;
            }
        }
        if (this.deleteEntries != null) {
            if (result.deleteEntries != null) {
                result.deleteEntries.addAll(this.deleteEntries);
            } else {
                result.deleteEntries = new ArrayList<String>(this.deleteEntries);
            }
        }
        if (this.minimumLauncherVersion != 0) {
            result.minimumLauncherVersion = this.minimumLauncherVersion;
        }
        if (this.tlauncherVersion != 0) {
            result.tlauncherVersion = this.tlauncherVersion;
        }
        if (this.assets != null && !this.assets.equals("legacy")) {
            result.assets = this.assets;
        }
        if (this.source != null) {
            result.source = this.source;
        }
        result.list = this.list;
        return result;
    }

    private void log(Object ... o) {
        U.log("[Version:" + this.id + "]", o);
    }

    public static class CompleteVersionSerializer
    implements JsonSerializer<CompleteVersion>,
    JsonDeserializer<CompleteVersion> {
        private final Gson defaultContext;

        public CompleteVersionSerializer() {
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
            builder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
            builder.enableComplexMapKeySerialization();
            builder.setPrettyPrinting();
            this.defaultContext = builder.create();
        }

        @Override
        public CompleteVersion deserialize(JsonElement elem, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonElement unnecessaryEntries1;
            JsonObject object = elem.getAsJsonObject();
            JsonElement originalId = object.get("original_id");
            if (originalId != null && originalId.isJsonPrimitive()) {
                String unnecessaryEntries = originalId.getAsString();
                object.remove("original_id");
                object.addProperty("jar", unnecessaryEntries);
            }
            if ((unnecessaryEntries1 = object.get("unnecessaryEntries")) != null && unnecessaryEntries1.isJsonArray()) {
                object.remove("unnecessaryEntries");
                object.add("deleteEntries", unnecessaryEntries1);
            }
            CompleteVersion version = this.defaultContext.fromJson(elem, CompleteVersion.class);
            if (version.id == null) {
                throw new JsonParseException("Version ID is NULL!");
            }
            if (version.type == null) {
                version.type = ReleaseType.UNKNOWN;
            }
            if (version.source == null) {
                version.source = Repository.LOCAL_VERSION_REPO;
            }
            if (version.time == null) {
                version.time = new Date(0L);
            }
            if (version.assets == null) {
                version.assets = "legacy";
            }
            return version;
        }

        @Override
        public JsonElement serialize(CompleteVersion version0, Type type, JsonSerializationContext context) {
            CompleteVersion version;
            try {
                version = (CompleteVersion)version0.clone();
            }
            catch (CloneNotSupportedException var7) {
                U.log("Cloning of CompleteVersion is not supported O_o", var7);
                return this.defaultContext.toJsonTree(version0, type);
            }
            version.list = null;
            JsonObject object = (JsonObject)this.defaultContext.toJsonTree(version, type);
            JsonElement jar = object.get("jar");
            if (jar == null) {
                object.remove("downloadJarLibraries");
            }
            return object;
        }
    }
}

