/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.downloader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.downloader.DownloadableContainer;
import ru.turikhay.tlauncher.downloader.DownloaderListener;
import ru.turikhay.tlauncher.downloader.DownloaderThread;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.TLauncherFrame;
import ru.turikhay.tlauncher.ui.login.buttons.PlayButton;
import ru.turikhay.util.U;
import ru.turikhay.util.async.ExtendedThread;

public class Downloader
extends ExtendedThread {
    public static final int MAX_THREADS = 6;
    public static final String DOWNLOAD_BLOCK = "download";
    static final String ITERATION_BLOCK = "iteration";
    private final DownloaderThread[] threads;
    private final List<Downloadable> list;
    private final List<DownloaderListener> listeners;
    private Configuration.ConnectionQuality configuration;
    private final AtomicInteger remainingObjects = new AtomicInteger();
    private int runningThreads;
    private int workingThreads;
    private final double[] speedContainer;
    private final double[] progressContainer;
    private double lastAverageProgress;
    private double averageProgress;
    private double averageSpeed;
    private boolean aborted;
    private final Object workLock;
    private boolean haveWork;

    private Downloader(Configuration.ConnectionQuality configuration) {
        super("MD");
        this.setConfiguration(configuration);
        this.threads = new DownloaderThread[6];
        this.list = Collections.synchronizedList(new ArrayList());
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.speedContainer = new double[6];
        this.progressContainer = new double[6];
        this.workLock = new Object();
        this.startAndWait();
    }

    public Downloader(TLauncher tlauncher) {
        this(tlauncher.getSettings().getConnectionQuality());
    }

    public Configuration.ConnectionQuality getConfiguration() {
        return this.configuration;
    }

    public int getRemaining() {
        return this.remainingObjects.get();
    }

    public double getProgress() {
        return this.averageProgress;
    }

    public double getSpeed() {
        return this.averageSpeed;
    }

    public void add(Downloadable d) {
        if (d == null) {
            throw new NullPointerException();
        }
        this.list.add(d);
    }

    public void add(DownloadableContainer c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.list.addAll(c.list);
    }

    public void addAll(Downloadable ... ds) {
        if (ds == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < ds.length; ++i) {
            if (ds[i] == null) {
                throw new NullPointerException("Downloadable at " + i + " is NULL!");
            }
            this.list.add(ds[i]);
        }
    }

    public void addAll(Collection<Downloadable> coll) {
        if (coll == null) {
            throw new NullPointerException();
        }
        int i = -1;
        for (Downloadable d : coll) {
            ++i;
            if (d == null) {
                throw new NullPointerException("Downloadable at" + i + " is NULL!");
            }
            this.list.add(d);
        }
    }

    public void addListener(DownloaderListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(listener);
    }

    public boolean startDownload() {
        TLauncherFrame f;
        boolean haveWork;
        boolean bl = haveWork = !this.list.isEmpty();
        if (haveWork) {
            this.unlockThread(ITERATION_BLOCK);
        }
        if ((f = TLauncher.getInstance().getFrame()) != null && f.mp.defaultScene.loginForm.play.getState() == PlayButton.PlayButtonState.CANCEL) {
            f.mp.defaultScene.loginForm.play.unblock("entered inot loading");
        }
        return haveWork;
    }

    public void startDownloadAndWait() {
        if (this.startDownload()) {
            this.waitWork();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitWork() {
        this.haveWork = true;
        while (this.haveWork) {
            Object var1 = this.workLock;
            Object object = this.workLock;
            synchronized (object) {
                try {
                    this.workLock.wait();
                }
                catch (InterruptedException var4) {
                    var4.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWork() {
        this.haveWork = false;
        Object var1 = this.workLock;
        Object object = this.workLock;
        synchronized (object) {
            this.workLock.notifyAll();
        }
    }

    public void stopDownload() {
        if (!this.isThreadLocked()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException var2) {
                var2.printStackTrace();
            }
        }
        if (!this.isThreadLocked()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.runningThreads; ++i) {
            this.threads[i].stopDownload();
        }
        this.aborted = true;
        if (this.isThreadLocked()) {
            this.tryUnlock(DOWNLOAD_BLOCK);
        }
    }

    public void stopDownloadAndWait() {
        this.stopDownload();
        this.waitForThreads();
    }

    public void setConfiguration(Configuration.ConnectionQuality configuration) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        Downloader.log(new Object[]{"Loaded configuration:", configuration});
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.checkCurrent();
        while (true) {
            this.lockThread(ITERATION_BLOCK);
            Downloader.log("Files in queue", this.list.size());
            List<Downloadable> i = this.list;
            List<Downloadable> list = this.list;
            synchronized (list) {
                this.sortOut();
            }
            for (int var4 = 0; var4 < this.runningThreads; ++var4) {
                this.threads[var4].startDownload();
            }
            this.lockThread(DOWNLOAD_BLOCK);
            if (this.aborted) {
                this.waitForThreads();
                this.onAbort();
                this.aborted = false;
            }
            this.notifyWork();
            Arrays.fill(this.speedContainer, 0.0);
            Arrays.fill(this.progressContainer, 0.0);
            this.averageProgress = 0.0;
            this.lastAverageProgress = 0.0;
            this.workingThreads = 0;
            this.remainingObjects.set(0);
        }
    }

    private void sortOut() {
        int size = this.list.size();
        if (size != 0) {
            int downloadablesAtThread = U.getMaxMultiply(size, 6);
            int x = 0;
            boolean y = true;
            Downloader.log("Starting download " + size + " files...");
            this.onStart(size);
            int max = this.configuration.getMaxThreads();
            boolean[] workers = new boolean[max];
            boolean flag = false;
            while (size > 0) {
                for (int arr$ = 0; arr$ < max; ++arr$) {
                    PlayButton len$;
                    int var12;
                    workers[arr$] = true;
                    size -= downloadablesAtThread;
                    if (this.threads[arr$] == null) {
                        this.threads[arr$] = new DownloaderThread(this, ++this.runningThreads);
                    }
                    for (var12 = x; var12 < x + downloadablesAtThread; ++var12) {
                        this.threads[arr$].add(this.list.get(var12));
                    }
                    x = var12;
                    if (size == 0) break;
                    if (flag || (len$ = TLauncher.getInstance().getFrame().mp.defaultScene.loginForm.play).getState() != PlayButton.PlayButtonState.CANCEL) continue;
                    len$.unblock("entered inot loading");
                }
                downloadablesAtThread = U.getMaxMultiply(size, 6);
            }
            boolean[] var13 = workers;
            int var14 = workers.length;
            for (int i$ = 0; i$ < var14; ++i$) {
                boolean worker = var13[i$];
                if (!worker) continue;
                ++this.workingThreads;
            }
            this.list.clear();
        }
    }

    private void onStart(int size) {
        for (DownloaderListener listener : this.listeners) {
            listener.onDownloaderStart(this, size);
        }
        this.remainingObjects.addAndGet(size);
    }

    void onAbort() {
        for (DownloaderListener listener : this.listeners) {
            listener.onDownloaderAbort(this);
        }
    }

    void onProgress(DownloaderThread thread, double curprogress, double curspeed) {
        int id = thread.getID() - 1;
        this.progressContainer[id] = curprogress;
        this.speedContainer[id] = curspeed;
        this.averageProgress = U.getAverage(this.progressContainer, this.workingThreads);
        if (this.averageProgress - this.lastAverageProgress >= 0.01) {
            this.lastAverageProgress = this.averageProgress;
            this.averageSpeed = U.getSum(this.speedContainer);
            for (DownloaderListener listener : this.listeners) {
                listener.onDownloaderProgress(this, this.averageProgress, this.averageSpeed);
            }
        }
    }

    void onFileComplete(DownloaderThread thread, Downloadable file) {
        int remaining = this.remainingObjects.decrementAndGet();
        Downloader.log("Objects remaining:", remaining);
        for (DownloaderListener listener : this.listeners) {
            listener.onDownloaderFileComplete(this, file);
        }
        if (remaining < 1) {
            this.onComplete();
        }
    }

    private void onComplete() {
        for (DownloaderListener listener : this.listeners) {
            listener.onDownloaderComplete(this);
        }
        this.unlockThread(DOWNLOAD_BLOCK);
    }

    private void waitForThreads() {
        boolean blocked;
        Downloader.log("Waiting for", this.workingThreads, "threads...");
        do {
            blocked = true;
            for (int i = 0; i < this.workingThreads; ++i) {
                if (this.threads[i].isThreadLocked()) continue;
                blocked = false;
            }
        } while (!blocked);
        Downloader.log("All threads are blocked by now");
    }

    private static void log(Object ... o) {
        U.log("[Downloader2]", o);
    }
}

