/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.review;

import ru.turikhay.tlauncher.entity.Review;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.util.ValidateUtil;

public class ValidateReview {
    public static boolean validate(Review review) {
        if (review.getTitle().isEmpty()) {
            Alert.showWarning("", Localizable.get().get("review.message.fill") + " " + Localizable.get().get("review.label.titleReview"));
            return false;
        }
        if (review.getDescription().isEmpty()) {
            Alert.showWarning("", Localizable.get().get("review.message.fill") + " " + Localizable.get().get("review.message.description"));
            return false;
        }
        if (review.getDescription().equals(Localizable.get("review.description"))) {
            Alert.showWarning("", Localizable.get().get("review.message.fill") + " " + Localizable.get().get("review.message.description"));
            return false;
        }
        if (review.getMailReview().isEmpty()) {
            review.setMailReview("user didn't write");
        } else if (!ValidateUtil.validateEmail(review.getMailReview())) {
            Alert.showWarning("", Localizable.get().get("review.message.email.invalid"));
            return false;
        }
        return true;
    }
}

