/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.rmo;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;
import joptsimple.OptionSet;
import ru.turikhay.tlauncher.configuration.ArgumentParser;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.configuration.LangConfiguration;
import ru.turikhay.tlauncher.downloader.Downloader;
import ru.turikhay.tlauncher.downloader.popup.menu.ManagerQuickServers;
import ru.turikhay.tlauncher.entity.ServerInfo;
import ru.turikhay.tlauncher.handlers.ExceptionHandler;
import ru.turikhay.tlauncher.handlers.SimpleHostnameVerifier;
import ru.turikhay.tlauncher.managers.ComponentManager;
import ru.turikhay.tlauncher.managers.ComponentManagerListenerHelper;
import ru.turikhay.tlauncher.managers.ElyManager;
import ru.turikhay.tlauncher.managers.ProfileManager;
import ru.turikhay.tlauncher.managers.ProfileManagerListener;
import ru.turikhay.tlauncher.managers.ServerList;
import ru.turikhay.tlauncher.managers.ServerListManager;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.managers.popup.menu.PopupMenuManager;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorDatabase;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftLauncher;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftListener;
import ru.turikhay.tlauncher.rmo.Bootstrapper;
import ru.turikhay.tlauncher.ui.TLauncherFrame;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.browser.BrowserHolder;
import ru.turikhay.tlauncher.ui.browser.JFXStartPageLoader;
import ru.turikhay.tlauncher.ui.console.Console;
import ru.turikhay.tlauncher.ui.listener.MinecraftUIListener;
import ru.turikhay.tlauncher.ui.listener.RequiredUpdateListener;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.log.LogFrame;
import ru.turikhay.tlauncher.ui.util.LogUtil;
import ru.turikhay.tlauncher.updater.AutoUpdater;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.OS;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.Time;
import ru.turikhay.util.U;
import ru.turikhay.util.statistics.GameRunningListener;
import ru.turikhay.util.statistics.InstallVersionListener;
import ru.turikhay.util.statistics.StatisticsCommand;
import ru.turikhay.util.statistics.StatisticsSending;
import ru.turikhay.util.statistics.StatisticsSendingWrapper;
import ru.turikhay.util.statistics.TlauncherRunningUnique;
import ru.turikhay.util.stream.MirroredLinkedStringStream;
import ru.turikhay.util.stream.PrintLogger;

public class TLauncher {
    private static final String[] UPDATE_REPO = new String[]{"http://repo.tlauncher.org/update/lch/update.json"};
    private static final String[] OFFICIAL_REPO = new String[]{"http://s3.amazonaws.com/Minecraft.Download/"};
    private static final String[] EXTRA_REPO = new String[]{"http://repo.tlauncher.org/update/downloads/"};
    private static final String[] LIBRARY_REPO = new String[]{"https://libraries.minecraft.net/"};
    private static final String[] ASSETS_REPO = new String[]{"http://resources.download.minecraft.net/"};
    private static final String[] SERVER_LIST = new String[]{"http://repo.tlauncher.org/update/servers.json"};
    private static final String[] UPDATE_REPO_SPARE = new String[]{"http://minecraft-mod.su/launcher/update/lch/update.json"};
    private static final String[] SERVER_LIST_SPARE = new String[]{"http://minecraft-mod.su/launcher/update/servers.json"};
    private static boolean accessMinecraftmod_su;
    private static boolean accessRepo_tlauncher_org;
    private static TLauncher instance;
    private static String[] sargs;
    private static File directory;
    private static PrintLogger print;
    private static Console console;
    private static Gson gson;
    private LangConfiguration lang;
    private Configuration settings;
    private Downloader downloader;
    private AutoUpdater updater;
    private TLauncherFrame frame;
    private ComponentManager manager;
    private VersionManager versionManager;
    private ProfileManager profileManager;
    private ElyManager elyManager;
    private final OptionSet args;
    private MinecraftLauncher launcher;
    private RequiredUpdateListener updateListener;
    private MinecraftUIListener minecraftListener;
    private ManagerQuickServers managerQuickServers;
    private PopupMenuManager popupMenuManager;
    private boolean ready;
    public static boolean DEBUG;

    private TLauncher(OptionSet set) throws Exception {
        Time.start(this);
        instance = this;
        this.args = set;
        gson = new Gson();
        File oldConfig = MinecraftUtil.getSystemRelatedFile("tlauncher.cfg");
        File newConfig = MinecraftUtil.getSystemRelatedDirectory("tlauncher/minecraft-su.properties");
        if (!oldConfig.isFile()) {
            oldConfig = MinecraftUtil.getSystemRelatedFile(".tlauncher/tlauncher.properties");
        }
        if (oldConfig.isFile() && !newConfig.isFile()) {
            boolean lastSending = true;
            try {
                FileUtil.createFile(newConfig);
                FileUtil.copyFile(oldConfig, newConfig, true);
            }
            catch (IOException var6) {
                U.log("Cannot copy old configuration to the new place", oldConfig, newConfig, var6);
                lastSending = false;
            }
            if (lastSending) {
                U.log("Old configuration successfully moved to the new place:", newConfig);
                FileUtil.deleteFile(oldConfig);
            }
        }
        U.setLoadingStep(Bootstrapper.LoadingStep.LOADING_CONFIGURATION);
        this.settings = Configuration.createConfiguration(set);
        this.reloadLocale();
        JFXStartPageLoader.getInstance();
        BrowserHolder.getInstance();
        U.setLoadingStep(Bootstrapper.LoadingStep.LOADING_CONSOLE);
        console = new Console(this.settings, print, this.lang.get("console"), this.settings.getConsoleType() == Configuration.ConsoleType.GLOBAL);
        console.setCloseAction(Console.CloseAction.KILL);
        Console.updateLocale();
        U.setLoadingStep(Bootstrapper.LoadingStep.LOADING_MANAGERS);
        this.manager = new ComponentManager(this);
        this.elyManager = this.manager.loadComponent(ElyManager.class);
        this.versionManager = this.manager.loadComponent(VersionManager.class);
        this.profileManager = this.manager.loadComponent(ProfileManager.class);
        this.manager.loadComponent(ServerListManager.class);
        this.manager.loadComponent(ComponentManagerListenerHelper.class);
        this.managerQuickServers = new ManagerQuickServers();
        this.managerQuickServers.loadServersInfo();
        this.init();
        this.downloader.addListener(new InstallVersionListener());
        U.log("Started! (" + Time.stop(this) + " ms.)");
        this.ready = true;
        U.setLoadingStep(Bootstrapper.LoadingStep.SUCCESS);
        new StatisticsSendingWrapper(StatisticsCommand.TLAUNCHER_RUNNING, "tl_run").startSending();
        Long lastSending1 = this.settings.getLong("sending.tlauncher.unique");
        if (!this.enterGap(lastSending1)) {
            this.settings.set("sending.tlauncher.unique", System.currentTimeMillis());
            new StatisticsSending(StatisticsCommand.TLAUNCHER_RUNNING_UNIQUE, TlauncherRunningUnique.build()).start();
        }
    }

    private boolean enterGap(Long last) {
        if (last == 0L) {
            return false;
        }
        Calendar start = Calendar.getInstance();
        start.set(10, 0);
        start.set(12, 0);
        start.set(13, 0);
        Calendar end = Calendar.getInstance();
        end.set(10, 23);
        end.set(12, 59);
        end.set(13, 59);
        return start.getTimeInMillis() < last && last < end.getTimeInMillis();
    }

    private void init() {
        this.downloader = new Downloader(this);
        this.minecraftListener = new MinecraftUIListener(this);
        this.updater = new AutoUpdater(this);
        this.updater.asyncFindUpdate();
        U.setLoadingStep(Bootstrapper.LoadingStep.LOADING_WINDOW);
        this.frame = new TLauncherFrame(this);
        U.setLoadingStep(Bootstrapper.LoadingStep.REFRESHING_INFO);
        this.versionManager.asyncRefresh();
        this.versionManager.addListener(this.frame);
        this.profileManager.addListener(new ProfileManagerListener(){

            @Override
            public void onAccountsRefreshed(AuthenticatorDatabase db) {
                boolean allow = false;
                for (Account check : db.getAccounts()) {
                    allow |= check.getType() == Account.AccountType.ELY;
                }
                TLauncher.this.elyManager.setRefreshAllowed(allow);
                if (allow) {
                    TLauncher.this.elyManager.asyncRefresh();
                }
            }

            @Override
            public void onProfilesRefreshed(ProfileManager pm) {
                this.onAccountsRefreshed(pm.getAuthDatabase());
            }

            @Override
            public void onProfileManagerChanged(ProfileManager pm) {
                this.onAccountsRefreshed(pm.getAuthDatabase());
            }
        });
        this.profileManager.refresh();
        this.manager.getComponent(ServerListManager.class).asyncRefresh();
    }

    public static boolean hostAvailabilityCheck(String host) {
        try {
            URL e = new URL(host);
            HttpURLConnection httpConn = (HttpURLConnection)e.openConnection();
            httpConn.setConnectTimeout(3000);
            httpConn.setInstanceFollowRedirects(false);
            httpConn.setRequestMethod("HEAD");
            httpConn.connect();
            U.debug(host + " : " + httpConn.getResponseCode());
            return true;
        }
        catch (Exception var3) {
            U.debug(host + " is down ");
            return false;
        }
    }

    public Downloader getDownloader() {
        return this.downloader;
    }

    public LangConfiguration getLang() {
        return this.lang;
    }

    public Configuration getSettings() {
        return this.settings;
    }

    public AutoUpdater getUpdater() {
        return this.updater;
    }

    public OptionSet getArguments() {
        return this.args;
    }

    public TLauncherFrame getFrame() {
        return this.frame;
    }

    public static Console getConsole() {
        return console;
    }

    public static Gson getGson() {
        return gson;
    }

    public ComponentManager getManager() {
        return this.manager;
    }

    public VersionManager getVersionManager() {
        return this.versionManager;
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    public ElyManager getElyManager() {
        return this.elyManager;
    }

    public MinecraftLauncher getLauncher() {
        return this.launcher;
    }

    public MinecraftUIListener getMinecraftListener() {
        return this.minecraftListener;
    }

    public RequiredUpdateListener getUpdateListener() {
        return this.updateListener;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void reloadLocale() throws IOException {
        Locale locale = this.settings.getLocale();
        U.log("Selected locale: " + locale);
        if (this.lang == null) {
            this.lang = new LangConfiguration(this.settings.getLocales(), locale);
        } else {
            this.lang.setSelected(locale);
        }
        Localizable.setLang(this.lang);
        Alert.prepareLocal();
        if (console != null) {
            console.setName(this.lang.get("console"));
        }
    }

    public void launch(MinecraftListener listener, ServerList.Server server, boolean forceupdate) {
        this.launcher = new MinecraftLauncher(this, forceupdate);
        this.launcher.addListener(this.minecraftListener);
        this.launcher.addListener(listener);
        this.launcher.addListener(this.frame.mp.getProgress());
        if (this.popupMenuManager != null) {
            this.launcher.addListener(this.popupMenuManager);
        }
        this.launcher.addListener(new GameRunningListener(this.launcher));
        this.launcher.setServer(server);
        this.launcher.start();
    }

    public boolean isLauncherWorking() {
        return this.launcher != null && this.launcher.isWorking();
    }

    public static void kill() {
        U.log("Good bye!");
        System.exit(0);
    }

    public void hide() {
        if (this.frame != null) {
            boolean doAgain = true;
            while (doAgain) {
                try {
                    this.frame.setVisible(false);
                    doAgain = false;
                }
                catch (Exception exception) {}
            }
        }
        U.log("I'm hiding!");
    }

    public void show() {
        if (this.frame != null) {
            boolean doAgain = true;
            while (doAgain) {
                try {
                    this.frame.setVisible(true);
                    doAgain = false;
                }
                catch (Exception var3) {
                    U.log(var3);
                }
            }
        }
        U.log("Here I am!");
    }

    public static void main(String[] args) {
        U.initializeLoggerU(MinecraftUtil.getWorkingDirectory().getPath(), "tlaucnher");
        accessMinecraftmod_su = TLauncher.hostAvailabilityCheck("http://minecraft-mod.su");
        accessRepo_tlauncher_org = false;
        ExceptionHandler handler = ExceptionHandler.getInstance();
        Thread.setDefaultUncaughtExceptionHandler(handler);
        Thread.currentThread().setUncaughtExceptionHandler(handler);
        HttpsURLConnection.setDefaultHostnameVerifier(SimpleHostnameVerifier.getInstance());
        MirroredLinkedStringStream stream = new MirroredLinkedStringStream(){

            @Override
            public void flush() {
                if (console == null) {
                    try {
                        this.getMirror().flush();
                    }
                    catch (IOException iOException) {}
                } else {
                    super.flush();
                }
            }
        };
        stream.setMirror(System.out);
        print = new PrintLogger(stream);
        stream.setLogger(print);
        System.setOut(print);
        U.setLoadingStep(Bootstrapper.LoadingStep.INITALIZING);
        SwingUtil.initLookAndFeel();
        try {
            TLauncher.launch(args);
        }
        catch (Throwable var4) {
            U.log("Error launching ALauncher:");
            U.log(var4);
            var4.printStackTrace(print);
            TLauncher.sendLog(var4);
        }
    }

    public static void sendLog(Throwable e) {
        TLauncher.log("send log files");
        if (Localizable.get() == null) {
            try {
                Configuration e1 = Configuration.createConfiguration();
                Locale locale = e1.getLocale();
                Localizable.setLang(new LangConfiguration(e1.getLocales(), locale));
            }
            catch (IOException var3) {
                var3.addSuppressed(e);
                e = var3;
                var3.printStackTrace();
            }
        }
        LogUtil.flushAllLogs();
        new LogFrame(TLauncher.getInstance().getFrame(), e).setVisible(true);
    }

    private static void log(String line) {
        U.log("[ALauncher] " + line);
    }

    private static void launch(String[] args) throws Exception {
        U.log("Starting ALauncher", "for Minecraft-Mod.su ", 1.964);
        U.log("Have question? Find my e-mail in lang files.");
        U.log("Machine info:", OS.getSummary());
        U.log("Startup time:", DateFormat.getDateTimeInstance().format(new Date()));
        U.log("---");
        sargs = args;
        new TLauncher(ArgumentParser.parseArgs(args));
    }

    public static String[] getArgs() {
        if (sargs == null) {
            sargs = new String[0];
        }
        return sargs;
    }

    public static File getDirectory() {
        if (directory == null) {
            directory = new File(".");
        }
        return directory;
    }

    public static TLauncher getInstance() {
        return instance;
    }

    public void newInstance() {
        Bootstrapper.main(sargs);
    }

    public static double getVersion() {
        return 1.964;
    }

    public static String getBrand() {
        return "for Minecraft-Mod.su ";
    }

    public static String getFolder() {
        return "minecraft";
    }

    public static String[] getUpdateRepos() {
        return accessRepo_tlauncher_org ? UPDATE_REPO : UPDATE_REPO_SPARE;
    }

    public static String getSettingsFile() {
        return "tlauncher/minecraft-su.properties";
    }

    public static String[] getOfficialRepo() {
        return OFFICIAL_REPO;
    }

    public static String[] getExtraRepo() {
        return EXTRA_REPO;
    }

    public static String[] getLibraryRepo() {
        return LIBRARY_REPO;
    }

    public static String[] getAssetsRepo() {
        return ASSETS_REPO;
    }

    public static String[] getServerList() {
        return accessRepo_tlauncher_org ? SERVER_LIST : SERVER_LIST_SPARE;
    }

    public ManagerQuickServers getManagerQuickServers() {
        return this.managerQuickServers;
    }

    public static String getHotServers() {
        return accessRepo_tlauncher_org ? "http://repo.tlauncher.org/update/lch/servers/" : "http://minecraft-mod.su/launcher/update/lch/servers/";
    }

    public static String getPageprefix() {
        return accessMinecraftmod_su ? "http://minecraft-mod.su/launcher/update/lch/" : "http://repo.tlauncher.org/update/lch/";
    }

    public static String getAddressServer() {
        return accessRepo_tlauncher_org ? "http://repo.tlauncher.org/update/ConfigReferenceServer.json" : "http://minecraft-mod.su/launcher/update/ConfigReferenceServer.json";
    }

    public static String getServerUrl() {
        return accessRepo_tlauncher_org ? "http://repo.tlauncher.org/update/ConfigSALF.json" : "http://minecraft-mod.su/launcher/update/ConfigSALF.json";
    }

    public static String getStatisticsConfigUrl() {
        return accessRepo_tlauncher_org ? "http://repo.tlauncher.org/update/StatisticsConfigUrl.json" : "http://minecraft-mod.su/launcher/update/StatisticsConfigUrl.json";
    }

    public static String getServerInfoPage() {
        return accessRepo_tlauncher_org ? "http://repo.tlauncher.org/update/lch/server_info_page.json" : "http://minecraft-mod.su/launcher/update/lch/server_info_page.json";
    }

    public PopupMenuManager getPopupMenuManager() {
        return this.popupMenuManager;
    }

    public void initPopupMenu(VersionManager manager) {
        if (this.popupMenuManager == null) {
            TLauncher.log("init popupMenuManager");
            if (manager == null) {
                manager = TLauncher.getInstance().getVersionManager();
            }
            this.popupMenuManager = new PopupMenuManager(manager.getVersions());
            this.popupMenuManager.putServers(this.getManagerQuickServers().getServerList(), ServerInfo.class, this.frame);
            this.popupMenuManager.enablePopup();
        }
    }

    static {
        DEBUG = true;
    }
}

