/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.login;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javafx.application.Platform;
import net.minecraft.launcher.updater.VersionSyncInfo;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.BlockablePanel;
import ru.turikhay.tlauncher.ui.loc.LocalizableCheckbox;
import ru.turikhay.tlauncher.ui.login.InputPanel;
import ru.turikhay.tlauncher.ui.login.LoginException;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.tlauncher.ui.swing.CheckBoxListener;
import ru.turikhay.util.OS;

public class CheckBoxPanel
extends BlockablePanel
implements LoginForm.LoginProcessListener {
    private static final long serialVersionUID = 768489049585749260L;
    public final LocalizableCheckbox forceupdate;
    private static boolean helperOpen = false;
    public final LocalizableCheckbox chooseTypeAccount;
    private final Configuration settings;
    private boolean state;
    private final LoginForm loginForm;
    private InputPanel inputPanel;

    CheckBoxPanel(LoginForm lf, InputPanel input, boolean chooserState) {
        this.loginForm = lf;
        this.inputPanel = input;
        this.forceupdate = new LocalizableCheckbox("loginform.checkbox.forceupdate");
        this.chooseTypeAccount = new LocalizableCheckbox("loginform.checkbox.account");
        this.settings = TLauncher.getInstance().getSettings();
        if (!OS.is(OS.WINDOWS)) {
            Font f = this.chooseTypeAccount.getFont();
            this.chooseTypeAccount.setFont(new Font(f.getFamily(), f.getStyle(), 11));
            this.forceupdate.setFont(new Font(f.getFamily(), f.getStyle(), 11));
        }
        this.add((Component)this.forceupdate);
        this.add((Component)this.chooseTypeAccount);
        this.chooseTypeAccount.getModel().setSelected(chooserState);
        this.forceupdate.addItemListener(new CheckBoxListener(){

            @Override
            public void itemStateChanged(boolean newstate) {
                CheckBoxPanel.this.state = newstate;
                ((CheckBoxPanel)CheckBoxPanel.this).loginForm.play.updateState();
            }
        });
        this.chooseTypeAccount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CheckBoxPanel.this.inputPanel.changeTypeAccount(Account.AccountType.MOJANG);
                            TLauncher.getInstance().getSettings().set("chooser.type.account", (Object)true);
                            if (CheckBoxPanel.this.settings.isFirstRun() && !helperOpen) {
                                ((CheckBoxPanel)CheckBoxPanel.this).loginForm.pane.openAccountEditor();
                                ((CheckBoxPanel)CheckBoxPanel.this).loginForm.pane.accountEditor.setShownAccountHelper(true, true);
                                helperOpen = true;
                                ((CheckBoxPanel)CheckBoxPanel.this).loginForm.pane.accountEditor.addComponentListener(new ComponentListener(){

                                    @Override
                                    public void componentShown(ComponentEvent e) {
                                    }

                                    @Override
                                    public void componentResized(ComponentEvent e) {
                                    }

                                    @Override
                                    public void componentMoved(ComponentEvent e) {
                                    }

                                    @Override
                                    public void componentHidden(ComponentEvent e) {
                                        ((CheckBoxPanel)CheckBoxPanel.this).loginForm.pane.accountEditor.setShownAccountHelper(false, false);
                                    }
                                });
                            }
                        }
                    });
                } else {
                    CheckBoxPanel.this.inputPanel.changeTypeAccount(Account.AccountType.FREE);
                    TLauncher.getInstance().getSettings().set("chooser.type.account", (Object)false);
                }
            }
        });
    }

    @Override
    public void logginingIn() throws LoginException {
        VersionSyncInfo syncInfo = this.loginForm.versions.getVersion();
        if (syncInfo != null) {
            boolean supporting = syncInfo.hasRemote();
            boolean installed = syncInfo.isInstalled();
            if (this.state) {
                if (!supporting) {
                    Alert.showLocError("forceupdate.local");
                    throw new LoginException("Cannot update local version!");
                }
                if (installed && !Alert.showLocQuestion("forceupdate.question")) {
                    throw new LoginException("User has cancelled force updating.");
                }
            }
        }
    }

    @Override
    public void loginFailed() {
    }

    @Override
    public void loginSucceed() {
    }
}

