/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

public class Range<T extends Number> {
    private final T minValue;
    private final T maxValue;
    private final boolean including;
    private final double doubleMin;
    private final double doubleMax;

    public Range(T minValue, T maxValue, boolean including) {
        if (minValue == null) {
            throw new NullPointerException("min");
        }
        if (maxValue == null) {
            throw new NullPointerException("max");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.doubleMin = ((Number)minValue).doubleValue();
        this.doubleMax = ((Number)maxValue).doubleValue();
        if (this.doubleMin >= this.doubleMax) {
            throw new IllegalArgumentException("min >= max");
        }
        this.including = including;
    }

    public Range(T minValue, T maxValue) {
        this(minValue, maxValue, true);
    }

    public T getMinValue() {
        return this.minValue;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    public boolean getIncluding() {
        return this.including;
    }

    public RangeDifference getDifference(T value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        double doubleValue = ((Number)value).doubleValue();
        double min = doubleValue - this.doubleMin;
        if (min == 0.0) {
            return this.including ? RangeDifference.FITS : RangeDifference.LESS;
        }
        if (min < 0.0) {
            return RangeDifference.LESS;
        }
        double max = doubleValue - this.doubleMax;
        return max == 0.0 ? (this.including ? RangeDifference.FITS : RangeDifference.GREATER) : (max > 0.0 ? RangeDifference.GREATER : RangeDifference.FITS);
    }

    public boolean fits(T value) {
        return this.getDifference(value) == RangeDifference.FITS;
    }

    public static enum RangeDifference {
        LESS,
        FITS,
        GREATER;

    }
}

