/*
 * Decompiled with CFR 0.152.
 */
package sparkless101.crosshairmod.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import sparkless101.crosshairmod.utils.GuiTheme;
import sparkless101.crosshairmod.utils.RGBA;

public class GuiGraphics {
    private static FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;

    public static void drawHorizontalLine(int y, int x1, int x2, RGBA colour) {
        GuiGraphics.drawFilledRectangle(x1, y, x2, y + 1, colour);
    }

    public static void drawVerticalLine(int x, int y1, int y2, RGBA colour) {
        GuiGraphics.drawFilledRectangle(x, y1, x + 1, y2, colour);
    }

    public static void drawRectangle(int x1, int y1, int x2, int y2, RGBA colour) {
        GuiGraphics.drawHorizontalLine(y1, x1, x2, colour);
        GuiGraphics.drawHorizontalLine(y2, x1, x2 + 1, colour);
        GuiGraphics.drawVerticalLine(x1, y1, y2, colour);
        GuiGraphics.drawVerticalLine(x2, y1, y2, colour);
    }

    public static void drawFilledRectangle(int x1, int y1, int x2, int y2, RGBA colour) {
        if (x1 < x2) {
            int tempX = x1;
            x1 = x2;
            x2 = tempX;
        }
        if (y1 < y2) {
            int tempY = y1;
            y1 = y2;
            y2 = tempY;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f), (float)((float)colour.getOpacity() / 255.0f));
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b((double)x1, (double)y2, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)x2, (double)y2, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)x2, (double)y1, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)x1, (double)y1, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawTexturedRectangle(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_181673_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181673_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + 0), 0.0).func_181673_a((double)((float)(textureX + width) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_181673_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawBorderedRectangle(int x1, int y1, int x2, int y2, RGBA innerColour, RGBA outerColour) {
        GuiGraphics.drawFilledRectangle(x1, y1, x2, y2, innerColour);
        GuiGraphics.drawRectangle(x1, y1, x2, y2, outerColour);
    }

    public static void drawThemeBorderedRectangle(int x1, int y1, int x2, int y2) {
        GuiGraphics.drawBorderedRectangle(x1, y1, x2, y2, GuiTheme.PRIMARY_T, GuiTheme.SECONDARY);
    }

    public static void drawString(String text, int x, int y, int colour) {
        fontRenderer.func_78276_b(text, x, y, colour);
    }

    public static void drawStringWithShadow(String text, int x, int y, int colour) {
        fontRenderer.func_175063_a(text, (float)x, (float)y, colour);
    }

    public static int getStringWidth(String text) {
        return fontRenderer.func_78256_a(text);
    }

    public static int[] getScreenSize() {
        int[] size = new int[2];
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
        size[0] = resolution.func_78326_a();
        size[1] = resolution.func_78328_b();
        return size;
    }

    public static double[] getScreenSizeDouble() {
        double[] size = new double[2];
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
        size[0] = resolution.func_78327_c();
        size[1] = resolution.func_78324_d();
        return size;
    }

    public static void drawLine(int x1, int y1, int x2, int y2, RGBA colour) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f), (float)((float)colour.getOpacity() / 255.0f));
        worldrenderer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b((double)x1, (double)y1, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)x2, (double)y2, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawCircle(double x, double y, int radius, RGBA colour) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f), (float)((float)colour.getOpacity() / 255.0f));
        worldrenderer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        for (int degrees = 0; degrees <= 360; ++degrees) {
            float radians = (float)((double)degrees * (Math.PI / 180));
            worldrenderer.func_181662_b(x + Math.cos(radians) * (double)radius, y + Math.sin(radians) * (double)radius, 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }
}

