/*
 * Decompiled with CFR 0.152.
 */
package sparkless101.crosshairmod.main;

import java.io.BufferedReader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import org.lwjgl.input.Keyboard;
import sparkless101.crosshairmod.crosshair.Crosshair;
import sparkless101.crosshairmod.crosshair.CrosshairConfig;
import sparkless101.crosshairmod.crosshair.properties.Properties;
import sparkless101.crosshairmod.crosshair.properties.Property;
import sparkless101.crosshairmod.gui.screens.ScreenMain;
import sparkless101.crosshairmod.main.KeyInputHandler;
import sparkless101.crosshairmod.utils.WebUtils;

@Mod(modid="customcrosshairmod", version="0.7.1", acceptedMinecraftVersions="[1.11.2]")
public class CustomCrosshairMod {
    public static final String NAME = "Custom Crosshair Mod";
    public static final String VERSION = "0.7.1";
    public static final String MCVERSION = "1.11.2-forge";
    public static final String FORUMURL = "http://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/2637819/";
    public static final String CURSEFORGEURL = "https://www.curseforge.com/projects/242995/";
    public static final String LATESTVERSIONURL = "http://pastebin.com/raw/B2sL8QCh";
    public Property customise_keyBind = new Property("Customise Keybind", "customise_keyBind", "GRAVE");
    public static KeyBinding guiEditKeyBind;
    private Crosshair crosshair;
    private static CustomCrosshairMod crosshairMod;
    public String detectedLatestVersion;
    public static boolean showNewVersionMessage;

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        crosshairMod = this;
        this.crosshair = new Crosshair();
        if (!CrosshairConfig.readConfigFile()) {
            CrosshairConfig.writeDefaultConfigFile();
        }
        guiEditKeyBind = new KeyBinding("Open GUI", Keyboard.getKeyIndex((String)this.customise_keyBind.getStringValue()), NAME);
        ClientRegistry.registerKeyBinding((KeyBinding)guiEditKeyBind);
        this.detectedLatestVersion = this.sendLatestVersionGetRequest();
        GuiIngameForge.renderCrosshairs = this.crosshair.properties.mod_enabled.getBooleanValue() == false;
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this.crosshair);
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void keyUpdates(Minecraft mc) {
        if (guiEditKeyBind.func_151468_f()) {
            mc.func_147108_a((GuiScreen)new ScreenMain());
        }
    }

    public void addChatMessage(String message) {
        String pre = "\u00a79[Custom Crosshair Mod] \u00a7r";
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation(pre + message, new Object[0]));
    }

    public String sendLatestVersionGetRequest() {
        BufferedReader reader = WebUtils.get(LATESTVERSIONURL);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] lineSplit = line.split(" ");
                if (!lineSplit[0].equals(MCVERSION)) continue;
                reader.close();
                return lineSplit[1];
            }
            reader.close();
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean usingCorrectVersion() {
        return this.detectedLatestVersion == null ? true : this.detectedLatestVersion.equals(VERSION);
    }

    public static CustomCrosshairMod getCrosshairMod() {
        return crosshairMod;
    }

    public Crosshair getCrosshair() {
        return this.crosshair;
    }

    public void resetCrosshair() {
        this.crosshair.properties = new Properties();
    }

    static {
        crosshairMod = new CustomCrosshairMod();
        showNewVersionMessage = true;
    }
}

