/*
 * Decompiled with CFR 0.152.
 */
package sparkless101.crosshairmod.gui.elements;

import net.minecraft.client.gui.GuiScreen;
import sparkless101.crosshairmod.gui.GuiGraphics;
import sparkless101.crosshairmod.gui.GuiTheme;
import sparkless101.crosshairmod.gui.elements.ElementBase;
import sparkless101.crosshairmod.utils.RGBA;

public class ElementTickBox
extends ElementBase {
    private boolean checked;

    public ElementTickBox(GuiScreen screen, String text, int x, int y) {
        this(screen, text, x, y, false);
    }

    public ElementTickBox(GuiScreen screen, String text, int x, int y, boolean startChecked) {
        super(screen, text, x, y, 11, 11);
        this.setChecked(startChecked);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY) {
        this.toggleChecked();
    }

    @Override
    public void drawElement(int mouseX, int mouseY) {
        RGBA backgroundColour = this.isMouseOver(mouseX, mouseY) ? GuiTheme.THEME_L3 : GuiTheme.THEME_L5;
        GuiGraphics.drawBorderedRectangle(this.getPosX(), this.getPosY(), this.getPosX() + this.getWidth(), this.getPosY() + this.getHeight(), backgroundColour, GuiTheme.PRIMARY);
        GuiGraphics.drawString(this.getDisplayText(), this.getPosX() + this.getWidth() + 5, this.getPosY() + this.getHeight() / 2 - 3, 0);
        if (this.getChecked()) {
            GuiGraphics.drawFilledRectangle(this.getPosX() + 2, this.getPosY() + 2, this.getPosX() + this.getWidth() - 1, this.getPosY() + this.getHeight() - 1, new RGBA(50, 255, 50, 255));
        }
    }

    public boolean getChecked() {
        return this.checked;
    }

    public void setChecked(boolean newChecked) {
        this.checked = newChecked;
    }

    public void toggleChecked() {
        this.checked = !this.checked;
    }
}

