/*
 * Decompiled with CFR 0.152.
 */
package crosshairmod.gui.items;

import crosshairmod.gui.items.GuiItem;
import crosshairmod.utils.GuiGraphics;
import crosshairmod.utils.GuiTheme;
import crosshairmod.utils.RGBA;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Mouse;

public class Slider
extends GuiItem {
    private int minValue;
    private int maxValue;
    private int value;
    private int boxPosition;
    private boolean mouseDown;
    private int offset;
    private int boxWidth;
    private RGBA boxColour;

    public Slider(GuiScreen screen) {
        this(screen, -1, "no name", 0, 0, 100, 10, 0, 100);
    }

    public Slider(GuiScreen screen, int id, String displayText, int posX, int posY, int width, int height, int minValue, int maxValue) {
        super(screen, id, displayText, posX, posY, width, height);
        this.setMinMaxValue(minValue, maxValue);
        this.boxWidth = 15;
        this.boxPosition = 1;
        this.offset = 0;
        this.mouseDown = false;
        this.value = 0;
        this.boxColour = GuiTheme.PRIMARY_T;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY) {
        if (this.isMouseOverBox(mouseX, mouseY)) {
            this.mouseDown = true;
            this.offset = mouseX - (this.getPosX() + this.boxPosition);
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY) {
    }

    @Override
    public void drawItem(int mouseX, int mouseY) {
        if (!Mouse.isButtonDown((int)0)) {
            this.mouseDown = false;
            this.setValue(this.value);
        }
        GuiGraphics.drawThemeBorderedRectangle(this.getPosX(), this.getPosY(), this.getPosX() + this.getWidth(), this.getPosY() + this.getHeight());
        RGBA borderColour = new RGBA(255, 255, 255, 255);
        if (this.isMouseOverBox(mouseX, mouseY) || this.mouseDown) {
            borderColour = new RGBA(255, 180, 0, 255);
        }
        int x = this.getPosX() + this.boxPosition;
        if (this.mouseDown) {
            x = mouseX - this.offset;
            if (x < this.getPosX() + 1) {
                x = this.getPosX() + 1;
            }
            if (x > this.getPosX() + this.getWidth() - this.boxWidth - 1) {
                x = this.getPosX() + this.getWidth() - this.boxWidth - 1;
            }
            this.setCurrentPosition(x - this.getPosX());
        }
        GuiGraphics.drawBorderedRectangle(x, this.getPosY() + 1, x + this.boxWidth, this.getPosY() + this.getHeight() - 1, this.getBoxColour(), borderColour);
        GuiGraphics.drawString(this.getDisplayText() + ": " + this.getValue(), this.getPosX() + this.getWidth() + 3, this.getPosY() + this.getHeight() / 2 - 3, 0xFFFFFF);
    }

    private boolean isMouseOverBox(int mouseX, int mouseY) {
        return mouseX >= this.getPosX() + this.boxPosition && mouseX <= this.getPosX() + this.boxPosition + this.boxWidth && mouseY >= this.getPosY() + 1 && mouseY <= this.getPosY() + this.getHeight() - 1;
    }

    private void setCurrentPosition(int x) {
        this.boxPosition = x;
        this.value = (int)((float)this.getMinValue() + (float)(this.boxPosition - 1) / (float)(this.getWidth() - this.boxWidth - 2) * (float)(this.maxValue - this.minValue));
    }

    public void setValue(int newValue) {
        this.value = newValue;
        this.boxPosition = (this.getWidth() - this.boxWidth - 2) * (this.getValue() - this.minValue) / (this.maxValue - this.minValue) + 1;
    }

    public void setMinMaxValue(int min, int max) {
        this.minValue = min;
        this.maxValue = max;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getValue() {
        return this.value;
    }

    public RGBA getBoxColour() {
        return this.boxColour;
    }

    public void setBoxColour(RGBA colour) {
        this.boxColour = colour;
    }
}

