/*
 * Decompiled with CFR 0.152.
 */
package sparkless101.crosshairmod.crosshair;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import org.lwjgl.opengl.GL11;
import sparkless101.crosshairmod.crosshair.Crosshair;
import sparkless101.crosshairmod.utils.EntityUtils;
import sparkless101.crosshairmod.utils.GuiGraphics;
import sparkless101.crosshairmod.utils.RGBA;

public class CrosshairRenderer {
    private Crosshair crosshair;
    private Minecraft mc;
    private int[] screenSize;
    private int screenWidth;
    private int screenHeight;
    private int currentRaindowTicks;

    public CrosshairRenderer(Minecraft minecraft, Crosshair c) {
        this.mc = minecraft;
        this.crosshair = c;
        this.currentRaindowTicks = 0;
    }

    public void drawCrosshair() {
        if (this.crosshair.isEnabled() && this.crosshair.isVisibleDefault() && this.renderCrosshairConditions_ThirdPerson() && this.renderCrosshairConditions_HideGui() && this.renderCrosshairConditions_Spectator()) {
            this.screenSize = GuiGraphics.getScreenSize();
            this.screenWidth = this.screenSize[0] / 2;
            this.screenHeight = this.screenSize[1] / 2;
            if (this.crosshair.isItemCooldownVisible()) {
                this.drawItemCooldownCircle();
            }
            this.prepareTranslationHideGui();
            RGBA renderColour = this.crosshair.getColour();
            int renderGap = this.crosshair.getGap();
            if (this.mc.field_71476_x != null && this.mc.field_71476_x.field_72313_a == RayTraceResult.Type.ENTITY) {
                if (this.changeColourConditions_thePlayer()) {
                    renderColour = this.crosshair.getHighlightPlayerColour();
                } else if (this.mc.field_71476_x.field_72308_g instanceof EntityLiving) {
                    if (this.changeColourConditions_Hostile()) {
                        renderColour = this.crosshair.getHighlightHostileColour();
                    } else if (this.changeColourConditions_Passive()) {
                        renderColour = this.crosshair.getHighlightPassiveColour();
                    }
                }
            }
            if (this.crosshair.getRainbowCrosshair()) {
                int[] rainbowColours = this.getRainbowCrosshairColours();
                renderColour = new RGBA(rainbowColours[0], rainbowColours[1], rainbowColours[2], this.crosshair.getColour().getOpacity());
            }
            if (this.isRenderingDynamicCrosshair()) {
                ItemStack item = this.mc.field_71439_g.func_184614_ca();
                int useCount = this.mc.field_71439_g.func_184605_cv();
                if (this.crosshair.getDynamicAttackIndicator()) {
                    float attackCooldown = this.mc.field_71439_g.func_184825_o(this.mc.func_184121_ak());
                    renderGap = this.crosshair.getGap() + (int)((1.0f - attackCooldown) * (float)(this.crosshair.getGap() + 5) * 2.0f);
                }
                if (this.renderDynamicCrosshair_Bow()) {
                    float bowExtension = (float)(item.func_77973_b().func_77626_a(item) - useCount) / 20.0f;
                    if (useCount == 0 || bowExtension > 1.0f) {
                        bowExtension = 1.0f;
                    }
                    renderGap = this.crosshair.getGap() + (int)((1.0f - bowExtension) * (float)(this.crosshair.getGap() + 5) * 2.0f);
                }
            }
            if (this.renderCrosshairConditions_DebugInfo()) {
                switch (this.crosshair.getCrosshairType()) {
                    case CIRCLE: {
                        this.drawCrosshairType_Circle(renderColour, renderGap);
                        break;
                    }
                    case SQUARE: {
                        this.drawCrosshairType_Square(renderColour, renderGap);
                        break;
                    }
                    case DEFAULT: {
                        this.drawCrosshairType_Default();
                        break;
                    }
                    case ARROW: {
                        this.drawCrosshairType_Arrow(renderColour, renderGap);
                        break;
                    }
                    default: {
                        this.drawCrosshairType_Cross(renderColour, renderGap);
                    }
                }
                if (this.renderCrosshairConditions_DrawDot()) {
                    GuiGraphics.drawFilledRectangle(this.screenWidth, this.screenHeight, this.screenWidth + 1, this.screenHeight + 1, this.crosshair.getDotColour());
                }
            } else {
                this.drawCrosshairType_Debug();
            }
        }
    }

    private void drawItemCooldownCircle() {
        int cooldownRadius = this.crosshair.getHeight() > this.crosshair.getWidth() ? this.crosshair.getHeight() : this.crosshair.getWidth();
        Item[] checkItems = new Item[]{Items.field_151079_bi, Items.field_185161_cS};
        GL11.glLineWidth((float)2.5f);
        for (int i = 0; i < checkItems.length; ++i) {
            float itemCooldown = this.mc.field_71439_g.func_184811_cZ().func_185143_a(checkItems[i], this.mc.func_184121_ak());
            if (!(itemCooldown > 0.0f)) continue;
            GuiGraphics.drawPartialCircle((float)this.screenWidth + 0.5f, (float)this.screenHeight + 0.5f, (float)(cooldownRadius + this.crosshair.getGap()) + 3.0f, itemCooldown * (float)Math.PI, this.crosshair.getItemCooldownColour());
        }
    }

    private void drawCrosshairType_Cross(RGBA renderColour, int renderGap) {
        int renderThickness = this.crosshair.getThickness() / 2;
        if (this.crosshair.isOutlineVisible()) {
            this.drawOutline(renderGap, renderThickness);
        }
        GuiGraphics.drawFilledRectangle(this.screenWidth - renderThickness, this.screenHeight - renderGap + 1, this.screenWidth + renderThickness + 1, this.screenHeight - renderGap - this.crosshair.getHeight() + 1, renderColour);
        GuiGraphics.drawFilledRectangle(this.screenWidth - renderThickness, this.screenHeight + renderGap, this.screenWidth + renderThickness + 1, this.screenHeight + renderGap + this.crosshair.getHeight(), renderColour);
        GuiGraphics.drawFilledRectangle(this.screenWidth - renderGap + 1, this.screenHeight - this.crosshair.getThickness() / 2, this.screenWidth - renderGap - this.crosshair.getWidth() + 1, this.screenHeight + renderThickness + 1, renderColour);
        GuiGraphics.drawFilledRectangle(this.screenWidth + renderGap, this.screenHeight - this.crosshair.getThickness() / 2, this.screenWidth + renderGap + this.crosshair.getWidth(), this.screenHeight + renderThickness + 1, renderColour);
    }

    private void drawCrosshairType_Circle(RGBA renderColour, int renderGap) {
        if (this.crosshair.isOutlineVisible()) {
            int t = (this.crosshair.getThickness() - this.crosshair.getThickness() % 2) / 2 + 1;
            if (t > 3) {
                t = 3;
            }
            GL11.glLineWidth((float)2.0f);
            GuiGraphics.drawCircle((double)this.screenWidth + 0.5, (double)this.screenHeight + 0.5, renderGap - 1, this.crosshair.getOutlineColour());
            GuiGraphics.drawCircle((double)this.screenWidth + 0.5, (double)this.screenHeight + 0.5, renderGap + t + 1, this.crosshair.getOutlineColour());
        }
        GL11.glLineWidth((float)(this.crosshair.getThickness() + 1));
        GuiGraphics.drawCircle((double)this.screenWidth + 0.5, (double)this.screenHeight + 0.5, renderGap + 1, renderColour);
    }

    private void drawCrosshairType_Square(RGBA renderColour, int renderGap) {
        if (this.crosshair.isOutlineVisible()) {
            GuiGraphics.drawRectangle(this.screenWidth - renderGap - 1, this.screenHeight - renderGap - 1, this.screenWidth + renderGap + 1, this.screenHeight + renderGap + 1, this.crosshair.getOutlineColour());
            GuiGraphics.drawRectangle(this.screenWidth - renderGap + 1, this.screenHeight - renderGap + 1, this.screenWidth + renderGap - 1, this.screenHeight + renderGap - 1, this.crosshair.getOutlineColour());
        }
        GuiGraphics.drawRectangle(this.screenWidth - renderGap, this.screenHeight - renderGap, this.screenWidth + renderGap, this.screenHeight + renderGap, renderColour);
    }

    private void drawCrosshairType_Default() {
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        GuiGraphics.drawTexturedRectangle(this.screenWidth - 7, this.screenHeight - 7, 0, 0, 16, 16);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
    }

    private void drawCrosshairType_Arrow(RGBA renderColour, int renderGap) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2848);
        GL11.glDisable((int)2832);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        if (this.crosshair.isOutlineVisible()) {
            GL11.glLineWidth((float)(this.crosshair.getThickness() + 6));
            GuiGraphics.drawLine(this.screenWidth - this.crosshair.getWidth() - 1, this.screenHeight + this.crosshair.getHeight() + 1, this.screenWidth, this.screenHeight, this.crosshair.getOutlineColour());
            GuiGraphics.drawLine(this.screenWidth, this.screenHeight, this.screenWidth + this.crosshair.getWidth() + 1, this.screenHeight + this.crosshair.getHeight() + 1, this.crosshair.getOutlineColour());
        }
        GL11.glLineWidth((float)(this.crosshair.getThickness() + 1));
        GuiGraphics.drawLine(this.screenWidth - this.crosshair.getWidth(), this.screenHeight + this.crosshair.getHeight(), this.screenWidth, this.screenHeight, renderColour);
        GuiGraphics.drawLine(this.screenWidth, this.screenHeight, this.screenWidth + this.crosshair.getWidth(), this.screenHeight + this.crosshair.getHeight(), renderColour);
        GL11.glPopMatrix();
    }

    private void drawCrosshairType_Debug() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.screenWidth, (float)this.screenHeight, (float)0.0f);
        Entity entity = this.mc.func_175606_aa();
        GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * 1.0f), (float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * 1.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        GL11.glLineWidth((float)2.0f);
        vertexbuffer.func_181662_b(0.0, 0.0, 0.0).func_181669_b(255, 0, 0, 255).func_181675_d();
        vertexbuffer.func_181662_b(10.0, 0.0, 0.0).func_181669_b(255, 0, 0, 255).func_181675_d();
        vertexbuffer.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 255, 0, 255).func_181675_d();
        vertexbuffer.func_181662_b(0.0, 10.0, 0.0).func_181669_b(0, 255, 0, 255).func_181675_d();
        vertexbuffer.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 0, 255, 255).func_181675_d();
        vertexbuffer.func_181662_b(0.0, 0.0, 10.0).func_181669_b(0, 0, 255, 255).func_181675_d();
        tessellator.func_78381_a();
        GL11.glLineWidth((float)1.0f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    private boolean renderDynamicCrosshair_Bow() {
        return this.crosshair.getDynamicBow() && this.mc.field_71439_g.func_184614_ca().func_77973_b() == Items.field_151031_f;
    }

    private boolean isRenderingDynamicCrosshair() {
        return !this.mc.field_71439_g.func_175149_v() && this.mc.field_71439_g.func_184614_ca() != null && (this.crosshair.getDynamicBow() || this.crosshair.getDynamicAttackIndicator());
    }

    private int[] getRainbowCrosshairColours() {
        int red = (int)(Math.sin((float)this.crosshair.getRainbowSpeed() / 100000.0f * (float)this.currentRaindowTicks + 0.0f) * 127.0 + 128.0);
        int green = (int)(Math.sin((float)this.crosshair.getRainbowSpeed() / 100000.0f * (float)this.currentRaindowTicks + 2.0f) * 127.0 + 128.0);
        int blue = (int)(Math.sin((float)this.crosshair.getRainbowSpeed() / 100000.0f * (float)this.currentRaindowTicks + 4.0f) * 127.0 + 128.0);
        ++this.currentRaindowTicks;
        return new int[]{red, green, blue};
    }

    private void prepareTranslationHideGui() {
        if (this.mc.field_71474_y.field_74319_N) {
            double[] screenSizeDouble = GuiGraphics.getScreenSizeDouble();
            GlStateManager.func_179086_m((int)256);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)screenSizeDouble[0], (double)screenSizeDouble[1], (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        }
    }

    private boolean changeColourConditions_Passive() {
        return !EntityUtils.isEntityHostile(this.mc.field_71476_x.field_72308_g) && this.crosshair.getHighlightPassive();
    }

    private boolean changeColourConditions_Hostile() {
        return EntityUtils.isEntityHostile(this.mc.field_71476_x.field_72308_g) && this.crosshair.getHighlightHostile();
    }

    private boolean changeColourConditions_thePlayer() {
        return this.mc.field_71476_x.field_72308_g instanceof EntityPlayer && this.crosshair.getHighlightPlayer();
    }

    private boolean renderCrosshairConditions_DrawDot() {
        return this.crosshair.isDotVisible() && this.crosshair.getCrosshairType() != Crosshair.CrosshairType.DEFAULT;
    }

    private boolean renderCrosshairConditions_DebugInfo() {
        return !this.mc.field_71474_y.field_74330_P || this.mc.field_71474_y.field_74330_P && this.crosshair.isVisibleDebug();
    }

    private boolean renderCrosshairConditions_ThirdPerson() {
        return this.mc.field_71474_y.field_74320_O > 0 && this.crosshair.isVisibleThirdPerson() || this.mc.field_71474_y.field_74320_O <= 0;
    }

    private boolean renderCrosshairConditions_HideGui() {
        return this.mc.field_71474_y.field_74319_N && this.crosshair.isVisibleHiddenGui() || !this.mc.field_71474_y.field_74319_N;
    }

    private boolean renderCrosshairConditions_Spectator() {
        return this.mc.field_71439_g.func_175149_v() && this.crosshair.isVisibleSpectator() || !this.mc.field_71439_g.func_175149_v();
    }

    private void drawOutline(int renderGap, int renderThickness) {
        if (this.crosshair.isThinOutline()) {
            GuiGraphics.drawLineF((float)(this.screenWidth - renderThickness) - 0.5f, (float)(this.screenHeight - renderGap) + 1.5f, this.screenWidth - renderThickness, (float)(this.screenHeight - renderGap - this.crosshair.getHeight()) + 0.5f, this.crosshair.getOutlineColour());
            GuiGraphics.drawLineF((float)(this.screenWidth + renderThickness) + 1.0f, (float)(this.screenHeight - renderGap) + 1.5f, (float)(this.screenWidth + renderThickness) + 1.5f, (float)(this.screenHeight - renderGap - this.crosshair.getHeight()) + 0.5f, this.crosshair.getOutlineColour());
            GuiGraphics.drawLineF(this.screenWidth - renderThickness, (float)(this.screenHeight - renderGap) + 1.0f, (float)(this.screenWidth + renderThickness) + 1.0f, this.screenHeight - renderGap + 1, this.crosshair.getOutlineColour());
            GuiGraphics.drawLineF(this.screenWidth - renderThickness, (float)(this.screenHeight - renderGap - this.crosshair.getHeight()) + 0.5f, (float)(this.screenWidth + renderThickness) + 1.0f, this.screenHeight - renderGap - this.crosshair.getHeight() + 1, this.crosshair.getOutlineColour());
            GuiGraphics.drawLineF(this.screenWidth - renderThickness, (float)(this.screenHeight + renderGap) - 0.5f, this.screenWidth - renderThickness, (float)(this.screenHeight + renderGap + this.crosshair.getHeight()) + 0.5f, this.crosshair.getOutlineColour());
            GuiGraphics.drawLineF((float)(this.screenWidth + renderThickness) + 1.0f, (float)(this.screenHeight + renderGap) - 0.5f, (float)(this.screenWidth + renderThickness) + 1.5f, (float)(this.screenHeight + renderGap + this.crosshair.getHeight()) + 0.5f, this.crosshair.getOutlineColour());
            GuiGraphics.drawLineF(this.screenWidth - renderThickness, (float)(this.screenHeight + renderGap) - 0.5f, (float)(this.screenWidth + renderThickness) + 1.0f, this.screenHeight + renderGap, this.crosshair.getOutlineColour());
            GuiGraphics.drawLineF(this.screenWidth - renderThickness, this.screenHeight + renderGap + this.crosshair.getHeight(), (float)(this.screenWidth + renderThickness) + 1.0f, (float)(this.screenHeight + renderGap + this.crosshair.getHeight()) + 0.5f, this.crosshair.getOutlineColour());
            GuiGraphics.drawLineF((float)(this.screenWidth + renderGap) - 0.5f, (float)(this.screenHeight - renderThickness) - 0.5f, (float)(this.screenWidth + renderGap + this.crosshair.getWidth()) + 0.5f, this.screenHeight - renderThickness, this.crosshair.getOutlineColour());
            GuiGraphics.drawLineF((float)(this.screenWidth + renderGap) - 0.5f, (float)(this.screenHeight + renderThickness) + 1.0f, (float)(this.screenWidth + renderGap + this.crosshair.getWidth()) + 0.5f, (float)(this.screenHeight + renderThickness) + 1.0f, this.crosshair.getOutlineColour());
            GuiGraphics.drawLineF(this.screenWidth + renderGap, this.screenHeight - renderThickness, this.screenWidth + renderGap, (float)(this.screenHeight + renderThickness) + 1.0f, this.crosshair.getOutlineColour());
            GuiGraphics.drawLineF((float)(this.screenWidth + renderGap + this.crosshair.getWidth()) + 0.5f, this.screenHeight - renderThickness, (float)(this.screenWidth + renderGap + this.crosshair.getWidth()) + 0.5f, (float)(this.screenHeight + renderThickness) + 1.0f, this.crosshair.getOutlineColour());
            GuiGraphics.drawLineF((float)(this.screenWidth - renderGap) + 1.5f, (float)(this.screenHeight - renderThickness) - 0.5f, (float)(this.screenWidth - renderGap - this.crosshair.getWidth()) + 0.5f, (float)(this.screenHeight - renderThickness) - 0.5f, this.crosshair.getOutlineColour());
            GuiGraphics.drawLineF((float)(this.screenWidth - renderGap) + 1.5f, (float)(this.screenHeight + renderThickness) + 1.0f, (float)(this.screenWidth - renderGap - this.crosshair.getWidth()) + 0.5f, (float)(this.screenHeight + renderThickness) + 1.0f, this.crosshair.getOutlineColour());
            GuiGraphics.drawLineF((float)(this.screenWidth - renderGap) + 1.5f, this.screenHeight - renderThickness, (float)(this.screenWidth - renderGap) + 1.5f, (float)(this.screenHeight + renderThickness) + 1.0f, this.crosshair.getOutlineColour());
            GuiGraphics.drawLineF((float)(this.screenWidth - renderGap - this.crosshair.getWidth()) + 1.0f, this.screenHeight - renderThickness, (float)(this.screenWidth - renderGap - this.crosshair.getWidth()) + 1.0f, (float)(this.screenHeight + renderThickness) + 1.0f, this.crosshair.getOutlineColour());
        } else {
            GuiGraphics.drawFilledRectangle(this.screenWidth - renderThickness - 1, this.screenHeight - renderGap + 1, this.screenWidth - renderThickness, this.screenHeight - renderGap - this.crosshair.getHeight() + 1, this.crosshair.getOutlineColour());
            GuiGraphics.drawFilledRectangle(this.screenWidth + renderThickness + 1, this.screenHeight - renderGap + 1, this.screenWidth + renderThickness + 2, this.screenHeight - renderGap - this.crosshair.getHeight() + 1, this.crosshair.getOutlineColour());
            GuiGraphics.drawFilledRectangle(this.screenWidth - renderThickness - 1, this.screenHeight - renderGap + 2, this.screenWidth + renderThickness + 2, this.screenHeight - renderGap + 1, this.crosshair.getOutlineColour());
            GuiGraphics.drawFilledRectangle(this.screenWidth - renderThickness - 1, this.screenHeight - renderGap - this.crosshair.getHeight(), this.screenWidth + renderThickness + 2, this.screenHeight - renderGap - this.crosshair.getHeight() + 1, this.crosshair.getOutlineColour());
            GuiGraphics.drawFilledRectangle(this.screenWidth - renderThickness - 1, this.screenHeight + renderGap, this.screenWidth - renderThickness, this.screenHeight + renderGap + this.crosshair.getHeight() + 1, this.crosshair.getOutlineColour());
            GuiGraphics.drawFilledRectangle(this.screenWidth + renderThickness + 1, this.screenHeight + renderGap, this.screenWidth + renderThickness + 2, this.screenHeight + renderGap + this.crosshair.getHeight() + 1, this.crosshair.getOutlineColour());
            GuiGraphics.drawFilledRectangle(this.screenWidth - renderThickness - 1, this.screenHeight + renderGap - 1, this.screenWidth + renderThickness + 2, this.screenHeight + renderGap, this.crosshair.getOutlineColour());
            GuiGraphics.drawFilledRectangle(this.screenWidth - renderThickness - 1, this.screenHeight + renderGap + this.crosshair.getHeight(), this.screenWidth + renderThickness + 2, this.screenHeight + renderGap + this.crosshair.getHeight() + 1, this.crosshair.getOutlineColour());
            GuiGraphics.drawFilledRectangle(this.screenWidth + renderGap, this.screenHeight - renderThickness - 1, this.screenWidth + renderGap + this.crosshair.getWidth(), this.screenHeight - renderThickness, this.crosshair.getOutlineColour());
            GuiGraphics.drawFilledRectangle(this.screenWidth + renderGap, this.screenHeight + renderThickness + 1, this.screenWidth + renderGap + this.crosshair.getWidth(), this.screenHeight + renderThickness + 2, this.crosshair.getOutlineColour());
            GuiGraphics.drawFilledRectangle(this.screenWidth + renderGap - 1, this.screenHeight - renderThickness - 1, this.screenWidth + renderGap, this.screenHeight + renderThickness + 2, this.crosshair.getOutlineColour());
            GuiGraphics.drawFilledRectangle(this.screenWidth + renderGap + this.crosshair.getWidth(), this.screenHeight - renderThickness - 1, this.screenWidth + renderGap + this.crosshair.getWidth() + 1, this.screenHeight + renderThickness + 2, this.crosshair.getOutlineColour());
            GuiGraphics.drawFilledRectangle(this.screenWidth - renderGap + 1, this.screenHeight - renderThickness - 1, this.screenWidth - renderGap - this.crosshair.getWidth(), this.screenHeight - renderThickness, this.crosshair.getOutlineColour());
            GuiGraphics.drawFilledRectangle(this.screenWidth - renderGap + 1, this.screenHeight + renderThickness + 1, this.screenWidth - renderGap - this.crosshair.getWidth(), this.screenHeight + renderThickness + 2, this.crosshair.getOutlineColour());
            GuiGraphics.drawFilledRectangle(this.screenWidth - renderGap + 2, this.screenHeight - renderThickness - 1, this.screenWidth - renderGap + 1, this.screenHeight + renderThickness + 2, this.crosshair.getOutlineColour());
            GuiGraphics.drawFilledRectangle(this.screenWidth - renderGap - this.crosshair.getWidth(), this.screenHeight - renderThickness - 1, this.screenWidth - renderGap - this.crosshair.getWidth() + 1, this.screenHeight + renderThickness + 2, this.crosshair.getOutlineColour());
        }
    }
}

