/*
 * Decompiled with CFR 0.152.
 */
package sparkless101.crosshairmod.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import sparkless101.crosshairmod.utils.GuiTheme;
import sparkless101.crosshairmod.utils.RGBA;

public class GuiGraphics {
    private static FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;

    public static void drawHorizontalLine(int y, int x1, int x2, RGBA colour) {
        GuiGraphics.drawFilledRectangle(x1, y, x2, y + 1, colour);
    }

    public static void drawVerticalLine(int x, int y1, int y2, RGBA colour) {
        GuiGraphics.drawFilledRectangle(x, y1, x + 1, y2, colour);
    }

    public static void drawRectangle(int x1, int y1, int x2, int y2, RGBA colour) {
        GuiGraphics.drawHorizontalLine(y1, x1, x2, colour);
        GuiGraphics.drawHorizontalLine(y2, x1, x2 + 1, colour);
        GuiGraphics.drawVerticalLine(x1, y1, y2, colour);
        GuiGraphics.drawVerticalLine(x2, y1, y2, colour);
    }

    public static void drawFilledRectangle(int x1, int y1, int x2, int y2, RGBA colour) {
        if (x1 < x2) {
            int tempX = x1;
            x1 = x2;
            x2 = tempX;
        }
        if (y1 < y2) {
            int tempY = y1;
            y1 = y2;
            y2 = tempY;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f), (float)((float)colour.getOpacity() / 255.0f));
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b((double)x1, (double)y2, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)x2, (double)y2, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)x2, (double)y1, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)x1, (double)y1, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawTexturedRectangle(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0), 0.0).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawBorderedRectangle(int x1, int y1, int x2, int y2, RGBA innerColour, RGBA outerColour) {
        GuiGraphics.drawFilledRectangle(x1, y1, x2, y2, innerColour);
        GuiGraphics.drawRectangle(x1, y1, x2, y2, outerColour);
    }

    public static void drawThemeBorderedRectangle(int x1, int y1, int x2, int y2) {
        GuiGraphics.drawBorderedRectangle(x1, y1, x2, y2, GuiTheme.PRIMARY_T, GuiTheme.SECONDARY);
    }

    public static void drawString(String text, int x, int y, int colour) {
        fontRenderer.func_78276_b(text, x, y, colour);
    }

    public static void drawStringWithShadow(String text, int x, int y, int colour) {
        fontRenderer.func_175063_a(text, (float)x, (float)y, colour);
    }

    public static int getStringWidth(String text) {
        return fontRenderer.func_78256_a(text);
    }

    public static int[] getScreenSize() {
        int[] size = new int[2];
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
        size[0] = resolution.func_78326_a();
        size[1] = resolution.func_78328_b();
        return size;
    }

    public static double[] getScreenSizeDouble() {
        double[] size = new double[2];
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
        size[0] = resolution.func_78327_c();
        size[1] = resolution.func_78324_d();
        return size;
    }

    public static void drawLine(int x1, int y1, int x2, int y2, RGBA colour) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f), (float)((float)colour.getOpacity() / 255.0f));
        vertexbuffer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b((double)x1, (double)y1, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)x2, (double)y2, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawLineF(float x1, float y1, float x2, float y2, RGBA colour) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f), (float)((float)colour.getOpacity() / 255.0f));
        GL11.glLineWidth((float)0.5f);
        vertexbuffer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b((double)x1, (double)y1, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)x2, (double)y2, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawLineFWidth(float x1, float y1, float y2, float width, RGBA colour) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f), (float)((float)colour.getOpacity() / 255.0f));
        vertexbuffer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        GL11.glLineWidth((float)0.5f);
        int lines = Math.round(width / 0.5f);
        for (int i = 0; i < lines; ++i) {
            vertexbuffer.func_181662_b((double)(x1 + 0.5f * (float)i), (double)y1, 0.0).func_181675_d();
            vertexbuffer.func_181662_b((double)(x1 + 0.5f * (float)i), (double)y2, 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawLines(int[][] points, RGBA colour) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f), (float)((float)colour.getOpacity() / 255.0f));
        vertexbuffer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < points.length; ++i) {
            vertexbuffer.func_181662_b((double)points[i][0], (double)points[i][1], 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawCircle(double x, double y, double radius, RGBA colour) {
        GuiGraphics.drawPartialCircle(x, y, radius, (float)Math.PI, colour);
    }

    public static void drawPartialCircle(double x, double y, double radius, float partial, RGBA colour) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GL11.glEnable((int)2848);
        GlStateManager.func_179131_c((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f), (float)((float)colour.getOpacity() / 255.0f));
        vertexbuffer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        for (int degrees = 0; degrees <= 360; ++degrees) {
            float radians = (float)degrees * partial / 180.0f;
            vertexbuffer.func_181662_b(x + Math.sin(radians) * radius, y + Math.cos(radians) * -radius, 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawFilledCircle(double x, double y, double radius, RGBA colour) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)colour.getRed(), (float)colour.getGreen(), (float)colour.getBlue(), (float)colour.getOpacity());
        GL11.glBegin((int)9);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)(x + radius), (double)(y + radius));
        GL11.glEnd();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawImage(String directory, int x, int y, int width, int height) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation(directory));
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }
}

